/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.binary.BaseNCodec;

public class BaseNCodecInputStream
extends FilterInputStream {
    private final BaseNCodec baseNCodec;
    private final boolean doEncode;
    private final byte[] singleByte = new byte[1];
    private final BaseNCodec.Context context = new BaseNCodec.Context();

    /*
     * WARNING - void declaration
     */
    protected BaseNCodecInputStream(InputStream in, BaseNCodec baseNCodec, boolean doEncode) {
        super((InputStream)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.doEncode = var3_3;
        this.baseNCodec = var2_2;
    }

    @Override
    public int available() throws IOException {
        if (this.context.eof) {
            return 0;
        }
        return 1;
    }

    @Override
    public synchronized void mark(int readLimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() throws IOException {
        BaseNCodecInputStream baseNCodecInputStream = this;
        int r = baseNCodecInputStream.read(baseNCodecInputStream.singleByte, 0, 1);
        while (r == 0) {
            BaseNCodecInputStream baseNCodecInputStream2 = this;
            r = baseNCodecInputStream2.read(baseNCodecInputStream2.singleByte, 0, 1);
        }
        if (r > 0) {
            void var1_1;
            byte b = this.singleByte[0];
            if (b < 0) {
                return b + 256;
            }
            return (int)var1_1;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int offset, int len) throws IOException {
        int n;
        if (b == null) {
            throw new NullPointerException();
        }
        if (offset < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (offset > b.length || offset + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        boolean readLen = false;
        while (!readLen) {
            if (!this.baseNCodec.hasData(this.context)) {
                byte[] buf = new byte[this.doEncode ? 4096 : 8192];
                int c = this.in.read(buf);
                if (this.doEncode) {
                    this.baseNCodec.encode(buf, 0, c, this.context);
                } else {
                    this.baseNCodec.decode(buf, 0, c, this.context);
                }
            }
            n = this.baseNCodec.readResults(b, offset, len, this.context);
        }
        return n;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long n) throws IOException {
        void var1_1;
        long todo;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("Negative skip length: " + n);
        }
        byte[] b = new byte[512];
        for (todo = n; todo > 0L; todo -= (long)len) {
            int cfr_ignored_0 = b.length;
            len = (int)Math.min(512L, todo);
            len = this.read(b, 0, len);
            if (len == -1) break;
        }
        return (long)(var1_1 - todo);
    }
}

