/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.util.Arrays;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.StringUtils;

public abstract class BaseNCodec
implements BinaryDecoder,
BinaryEncoder {
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected final byte PAD = (byte)61;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;

    /*
     * WARNING - void declaration
     */
    protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.unencodedBlockSize = unencodedBlockSize;
        this.encodedBlockSize = encodedBlockSize;
        boolean useChunking = lineLength > 0 && chunkSeparatorLength > 0;
        this.lineLength = var1_1 != false ? var3_3 / encodedBlockSize * var2_2 : 0;
        this.chunkSeparatorLength = chunkSeparatorLength;
    }

    boolean hasData(Context context) {
        return context.buffer != null;
    }

    /*
     * WARNING - void declaration
     */
    int available(Context context) {
        if (context.buffer != null) {
            void var1_1;
            return context.pos - var1_1.readPos;
        }
        return 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] resizeBuffer(Context context) {
        void var1_1;
        if (context.buffer == null) {
            context.buffer = new byte[this.getDefaultBufferSize()];
            context.pos = 0;
            context.readPos = 0;
        } else {
            void var2_2;
            byte[] b = new byte[context.buffer.length << 1];
            System.arraycopy(context.buffer, 0, b, 0, context.buffer.length);
            context.buffer = var2_2;
        }
        return var1_1.buffer;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] ensureBufferSize(int size, Context context) {
        void var2_2;
        void var1_1;
        if (context.buffer == null || context.buffer.length < context.pos + var1_1) {
            return this.resizeBuffer(context);
        }
        return var2_2.buffer;
    }

    /*
     * WARNING - void declaration
     */
    int readResults(byte[] b, int bPos, int bAvail, Context context) {
        if (context.buffer != null) {
            void var3_3;
            void var2_2;
            void var1_1;
            int len = Math.min(this.available(context), bAvail);
            System.arraycopy(context.buffer, context.readPos, var1_1, (int)var2_2, len);
            context.readPos += len;
            if (context.readPos >= context.pos) {
                context.buffer = null;
            }
            return (int)var3_3;
        }
        if (context.eof) {
            return -1;
        }
        return 0;
    }

    protected static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object encode(Object obj) throws EncoderException {
        void var1_1;
        if (!(obj instanceof byte[])) {
            throw new EncoderException("Parameter supplied to Base-N encode is not a byte[]");
        }
        return this.encode((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String encodeToString(byte[] pArray) {
        void var1_1;
        return StringUtils.newStringUtf8(this.encode((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String encodeAsString(byte[] pArray) {
        void var1_1;
        return StringUtils.newStringUtf8(this.encode((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object decode(Object obj) throws DecoderException {
        if (obj instanceof byte[]) {
            return this.decode((byte[])obj);
        }
        if (obj instanceof String) {
            void var1_1;
            return this.decode((String)var1_1);
        }
        throw new DecoderException("Parameter supplied to Base-N decode is not a byte[] or a String");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] decode(String pArray) {
        void var1_1;
        return this.decode(StringUtils.getBytesUtf8((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decode(byte[] pArray) {
        void var1_1;
        void var2_2;
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context = new Context();
        this.decode(pArray, 0, pArray.length, context);
        this.decode(pArray, 0, -1, context);
        byte[] result = new byte[context.pos];
        this.readResults(result, 0, result.length, (Context)var2_2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] encode(byte[] pArray) {
        void var1_1;
        void var2_2;
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context = new Context();
        this.encode(pArray, 0, pArray.length, context);
        this.encode(pArray, 0, -1, context);
        byte[] buf = new byte[context.pos - context.readPos];
        this.readResults(buf, 0, buf.length, (Context)var2_2);
        return var1_1;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] arrayOctet, boolean allowWSPad) {
        for (int i = 0; i < arrayOctet.length; ++i) {
            if (this.isInAlphabet(arrayOctet[i]) || allowWSPad && (arrayOctet[i] == 61 || BaseNCodec.isWhiteSpace(arrayOctet[i]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isInAlphabet(String basen) {
        void var1_1;
        return this.isInAlphabet(StringUtils.getBytesUtf8((String)var1_1), true);
    }

    protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
        if (arrayOctet == null) {
            return false;
        }
        byte[] arr$ = arrayOctet;
        int len$ = arrayOctet.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            byte element = arr$[i$];
            if (61 != element && !this.isInAlphabet(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public long getEncodedLength(byte[] pArray) {
        void var2_2;
        long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            long l = len;
            len = l + (l + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return (long)var2_2;
    }

    static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

