/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.binary;

import java.math.BigInteger;
import org.apache.commons.codec.binary.BaseNCodec;
import org.apache.commons.codec.binary.StringUtils;

public class Base64
extends BaseNCodec {
    private static final int BITS_PER_ENCODED_BYTE = 6;
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] URL_SAFE_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 45, 95};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private final byte[] encodeTable;
    private final byte[] decodeTable = DECODE_TABLE;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;

    public Base64() {
        this(0);
    }

    /*
     * WARNING - void declaration
     */
    public Base64(boolean urlSafe) {
        this(76, CHUNK_SEPARATOR, (boolean)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Base64(int lineLength) {
        this((int)var1_1, CHUNK_SEPARATOR);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Base64(int lineLength, byte[] lineSeparator) {
        this((int)var1_1, (byte[])var2_2, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Base64(int lineLength, byte[] lineSeparator, boolean urlSafe) {
        super(3, 4, lineLength, lineSeparator == null ? 0 : lineSeparator.length);
        void var3_4;
        if (lineSeparator != null) {
            void var1_1;
            if (this.containsAlphabetOrPad(lineSeparator)) {
                void var1_2;
                String sep = StringUtils.newStringUtf8(lineSeparator);
                throw new IllegalArgumentException("lineSeparator must not contain base64 characters: [" + (String)var1_2 + "]");
            }
            if (var1_1 > 0) {
                void var2_3;
                this.encodeSize = 4 + lineSeparator.length;
                this.lineSeparator = new byte[lineSeparator.length];
                System.arraycopy(lineSeparator, 0, this.lineSeparator, 0, ((void)var2_3).length);
            } else {
                this.encodeSize = 4;
                this.lineSeparator = null;
            }
        } else {
            this.encodeSize = 4;
            this.lineSeparator = null;
        }
        this.decodeSize = this.encodeSize - 1;
        this.encodeTable = var3_4 != false ? URL_SAFE_ENCODE_TABLE : STANDARD_ENCODE_TABLE;
    }

    public boolean isUrlSafe() {
        return this.encodeTable == URL_SAFE_ENCODE_TABLE;
    }

    @Override
    void encode(byte[] in, int inPos, int inAvail, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (inAvail < 0) {
            context.eof = true;
            if (context.modulus == 0 && this.lineLength == 0) {
                return;
            }
            Base64 base64 = this;
            byte[] buffer = base64.ensureBufferSize(base64.encodeSize, context);
            int savedPos = context.pos;
            switch (context.modulus) {
                case 0: {
                    break;
                }
                case 1: {
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 2 & 0x3F];
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea << 4 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    buffer[context.pos++] = 61;
                    buffer[context.pos++] = 61;
                    break;
                }
                case 2: {
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 10 & 0x3F];
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 4 & 0x3F];
                    buffer[context.pos++] = this.encodeTable[context.ibitWorkArea << 2 & 0x3F];
                    if (this.encodeTable != STANDARD_ENCODE_TABLE) break;
                    buffer[context.pos++] = 61;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible modulus " + context.modulus);
                }
            }
            context.currentLinePos += context.pos - savedPos;
            if (this.lineLength > 0 && context.currentLinePos > 0) {
                System.arraycopy(this.lineSeparator, 0, buffer, context.pos, this.lineSeparator.length);
                context.pos += this.lineSeparator.length;
            }
            return;
        }
        for (int i = 0; i < inAvail; ++i) {
            int b;
            Base64 base64 = this;
            byte[] buffer = base64.ensureBufferSize(base64.encodeSize, context);
            context.modulus = (context.modulus + 1) % 3;
            if ((b = in[inPos++]) < 0) {
                b += 256;
            }
            context.ibitWorkArea = (context.ibitWorkArea << 8) + b;
            if (context.modulus != 0) continue;
            buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 18 & 0x3F];
            buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 12 & 0x3F];
            buffer[context.pos++] = this.encodeTable[context.ibitWorkArea >> 6 & 0x3F];
            buffer[context.pos++] = this.encodeTable[context.ibitWorkArea & 0x3F];
            context.currentLinePos += 4;
            if (this.lineLength <= 0 || this.lineLength > context.currentLinePos) continue;
            System.arraycopy(this.lineSeparator, 0, buffer, context.pos, this.lineSeparator.length);
            context.pos += this.lineSeparator.length;
            context.currentLinePos = 0;
        }
    }

    @Override
    void decode(byte[] in, int inPos, int inAvail, BaseNCodec.Context context) {
        if (context.eof) {
            return;
        }
        if (inAvail < 0) {
            context.eof = true;
        }
        for (int i = 0; i < inAvail; ++i) {
            byte result;
            byte b;
            Base64 base64 = this;
            byte[] buffer = base64.ensureBufferSize(base64.decodeSize, context);
            if ((b = in[inPos++]) == 61) {
                context.eof = true;
                break;
            }
            if (b < 0 || b >= DECODE_TABLE.length || (result = DECODE_TABLE[b]) < 0) continue;
            context.modulus = (context.modulus + 1) % 4;
            context.ibitWorkArea = (context.ibitWorkArea << 6) + result;
            if (context.modulus != 0) continue;
            buffer[context.pos++] = (byte)(context.ibitWorkArea >> 16);
            buffer[context.pos++] = (byte)(context.ibitWorkArea >> 8);
            buffer[context.pos++] = (byte)context.ibitWorkArea;
        }
        if (context.eof && context.modulus != 0) {
            Base64 base64 = this;
            byte[] buffer = base64.ensureBufferSize(base64.decodeSize, context);
            switch (context.modulus) {
                case 1: {
                    return;
                }
                case 2: {
                    context.ibitWorkArea >>= 4;
                    buffer[context.pos++] = (byte)context.ibitWorkArea;
                    return;
                }
                case 3: {
                    context.ibitWorkArea >>= 2;
                    buffer[context.pos++] = (byte)(context.ibitWorkArea >> 8);
                    buffer[context.pos++] = (byte)context.ibitWorkArea;
                    return;
                }
            }
            throw new IllegalStateException("Impossible modulus " + context.modulus);
        }
    }

    @Deprecated
    public static boolean isArrayByteBase64(byte[] arrayOctet) {
        return Base64.isBase64(arrayOctet);
    }

    public static boolean isBase64(byte octet) {
        byte by;
        return octet == 61 || octet >= 0 && octet < DECODE_TABLE.length && DECODE_TABLE[by] != -1;
    }

    public static boolean isBase64(String base64) {
        return Base64.isBase64(StringUtils.getBytesUtf8(base64));
    }

    public static boolean isBase64(byte[] arrayOctet) {
        for (int i = 0; i < arrayOctet.length; ++i) {
            if (Base64.isBase64(arrayOctet[i]) || Base64.isWhiteSpace(arrayOctet[i])) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeBase64(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, false);
    }

    public static String encodeBase64String(byte[] binaryData) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(binaryData, false));
    }

    public static byte[] encodeBase64URLSafe(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, false, true);
    }

    public static String encodeBase64URLSafeString(byte[] binaryData) {
        return StringUtils.newStringUtf8(Base64.encodeBase64(binaryData, false, true));
    }

    public static byte[] encodeBase64Chunked(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, true);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked) {
        void var1_1;
        return Base64.encodeBase64(binaryData, (boolean)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked, boolean urlSafe) {
        void var2_2;
        void var1_1;
        return Base64.encodeBase64(binaryData, (boolean)var1_1, (boolean)var2_2, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked, boolean urlSafe, int maxResultSize) {
        byte[] byArray;
        void var1_2;
        void var2_3;
        if (binaryData == null || binaryData.length == 0) {
            return binaryData;
        }
        Base64 b64 = isChunked ? new Base64(urlSafe) : new Base64(0, CHUNK_SEPARATOR, (boolean)var2_3);
        long len = b64.getEncodedLength(binaryData);
        if (len > (long)maxResultSize) {
            void var3_4;
            throw new IllegalArgumentException("Input array too big, the output array would be bigger (" + len + ") than the specified maximum size of " + (int)var3_4);
        }
        return var1_2.encode(byArray);
    }

    public static byte[] decodeBase64(String base64String) {
        String string;
        return new Base64().decode(string);
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        byte[] byArray;
        return new Base64().decode(byArray);
    }

    public static BigInteger decodeInteger(byte[] pArray) {
        byte[] byArray;
        return new BigInteger(1, Base64.decodeBase64(byArray));
    }

    public static byte[] encodeInteger(BigInteger bigInt) {
        BigInteger bigInteger;
        if (bigInt == null) {
            throw new NullPointerException("encodeInteger called with null parameter");
        }
        return Base64.encodeBase64(Base64.toIntegerBytes(bigInteger), false);
    }

    /*
     * WARNING - void declaration
     */
    static byte[] toIntegerBytes(BigInteger bigInt) {
        void var1_3;
        void var0_1;
        void var3_5;
        void var2_4;
        int n = bigInt.bitLength();
        int bitlen = n + 7 >> 3 << 3;
        byte[] bigBytes = bigInt.toByteArray();
        if (bigInt.bitLength() % 8 != 0 && bigInt.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        boolean startSrc = false;
        int len = bigBytes.length;
        if (bigInt.bitLength() % 8 == 0) {
            startSrc = true;
            --len;
        }
        int startDst = bitlen / 8 - len;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(var2_4, (int)var3_5, resizedBytes, (int)var0_1, len);
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isInAlphabet(byte octet) {
        void var1_1;
        return octet >= 0 && octet < this.decodeTable.length && this.decodeTable[var1_1] != -1;
    }
}

