/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.AbstractAuthentication;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SPNEGOAuthentication
extends AbstractAuthentication {
    private static final Logger LOG = Log.getLogger(SPNEGOAuthentication.class);
    private static final String NEGOTIATE = HttpHeader.NEGOTIATE.asString();
    private final GSSManager gssManager = GSSManager.getInstance();
    private String userName;
    private String userPassword;
    private Path userKeyTabPath;
    private String serviceName;
    private boolean useTicketCache;
    private Path ticketCachePath;
    private boolean renewTGT;

    /*
     * WARNING - void declaration
     */
    public SPNEGOAuthentication(URI uri) {
        super((URI)var1_1, "<<ANY_REALM>>");
        void var1_1;
    }

    @Override
    public String getType() {
        return NEGOTIATE;
    }

    public String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserName(String userName) {
        void var1_1;
        this.userName = var1_1;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserPassword(String userPassword) {
        void var1_1;
        this.userPassword = var1_1;
    }

    public Path getUserKeyTabPath() {
        return this.userKeyTabPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserKeyTabPath(Path userKeyTabPath) {
        void var1_1;
        this.userKeyTabPath = var1_1;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    /*
     * WARNING - void declaration
     */
    public void setServiceName(String serviceName) {
        void var1_1;
        this.serviceName = var1_1;
    }

    public boolean isUseTicketCache() {
        return this.useTicketCache;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseTicketCache(boolean useTicketCache) {
        void var1_1;
        this.useTicketCache = var1_1;
    }

    public Path getTicketCachePath() {
        return this.ticketCachePath;
    }

    /*
     * WARNING - void declaration
     */
    public void setTicketCachePath(Path ticketCachePath) {
        void var1_1;
        this.ticketCachePath = var1_1;
    }

    public boolean isRenewTGT() {
        return this.renewTGT;
    }

    /*
     * WARNING - void declaration
     */
    public void setRenewTGT(boolean renewTGT) {
        void var1_1;
        this.renewTGT = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, Authentication.HeaderInfo headerInfo, Attributes context) {
        void var1_1;
        void var3_3;
        void var2_2;
        String b64Input;
        SPNEGOContext spnegoContext = (SPNEGOContext)context.getAttribute(SPNEGOContext.ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Authenticate with context {}", new Object[]{spnegoContext});
        }
        if (spnegoContext == null) {
            spnegoContext = this.login();
            context.setAttribute(SPNEGOContext.ATTRIBUTE, (Object)spnegoContext);
        }
        byte[] input = (b64Input = headerInfo.getBase64()) == null ? new byte[]{} : Base64.getDecoder().decode(b64Input);
        byte[] output = Subject.doAs(spnegoContext.subject, this.initGSSContext((SPNEGOContext)var2_2, request.getHost(), (byte[])var3_3));
        String b64Output = output == null ? null : new String(Base64.getEncoder().encode(output));
        return new SPNEGOResult(null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private SPNEGOContext login() {
        try {
            void var2_3;
            String user = this.getUserName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Logging in user {}", new Object[]{user});
            }
            PasswordCallbackHandler callbackHandler = new PasswordCallbackHandler();
            LoginContext loginContext = new LoginContext("", null, callbackHandler, new SPNEGOConfiguration());
            loginContext.login();
            Subject subject = loginContext.getSubject();
            SPNEGOContext spnegoContext = new SPNEGOContext();
            SPNEGOContext.access$102(spnegoContext, subject);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initialized {}", new Object[]{spnegoContext});
            }
            return var2_3;
        }
        catch (LoginException x) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private PrivilegedAction<byte[]> initGSSContext(SPNEGOContext spnegoContext, String host, byte[] bytes) {
        void var3_3;
        void var2_2;
        void var1_1;
        return () -> this.lambda$initGSSContext$0((SPNEGOContext)var1_1, (String)var2_2, (byte[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ byte[] lambda$initGSSContext$0(SPNEGOContext spnegoContext, String host, byte[] bytes) {
        try {
            void var2_2;
            void var3_3;
            Object spnegoOid;
            GSSContext gssContext = spnegoContext.gssContext;
            if (gssContext == null) {
                void var1_1;
                String principal = this.getServiceName() + "@" + host;
                GSSName serviceName = this.gssManager.createName(principal, GSSName.NT_HOSTBASED_SERVICE);
                spnegoOid = new Oid("1.3.6.1.5.5.2");
                spnegoOid = this.gssManager.createContext(serviceName, (Oid)spnegoOid, null, Integer.MAX_VALUE);
                SPNEGOContext.access$702((SPNEGOContext)var1_1, (GSSContext)spnegoOid);
                spnegoOid.requestMutualAuth(true);
            }
            byte[] result = spnegoOid.initSecContext(bytes, 0, ((void)var3_3).length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}", new Object[]{spnegoOid.isEstablished() ? "Initialized" : "Initializing", spnegoOid});
            }
            return var2_2;
        }
        catch (GSSException x) {
            throw new RuntimeException(x);
        }
    }

    private class SPNEGOConfiguration
    extends Configuration {
        private SPNEGOConfiguration() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            void var1_1;
            void var2_5;
            HashMap<String, String> options = new HashMap<String, String>();
            if (LOG.isDebugEnabled()) {
                options.put("debug", "true");
            }
            options.put("refreshKrb5Config", "true");
            options.put("principal", SPNEGOAuthentication.this.getUserName());
            options.put("isInitiator", "true");
            Path keyTabPath = SPNEGOAuthentication.this.getUserKeyTabPath();
            if (keyTabPath != null) {
                options.put("doNotPrompt", "true");
                options.put("useKeyTab", "true");
                options.put("keyTab", keyTabPath.toAbsolutePath().toString());
                options.put("storeKey", "true");
            }
            if (keyTabPath = SPNEGOAuthentication.this.isUseTicketCache()) {
                options.put("useTicketCache", "true");
                Path ticketCachePath = SPNEGOAuthentication.this.getTicketCachePath();
                if (ticketCachePath != null) {
                    options.put("ticketCache", ticketCachePath.toAbsolutePath().toString());
                }
                options.put("renewTGT", String.valueOf(SPNEGOAuthentication.this.isRenewTGT()));
            }
            String moduleClass = "com.sun.security.auth.module.Krb5LoginModule";
            AppConfigurationEntry config = new AppConfigurationEntry((String)var2_5, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
            return new AppConfigurationEntry[]{var1_1};
        }
    }

    private class PasswordCallbackHandler
    implements CallbackHandler {
        private PasswordCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException {
            PasswordCallback passwordCallback = Arrays.stream(callbacks).filter(PasswordCallback.class::isInstance).map(PasswordCallback.class::cast).findAny().filter(c -> c.getPrompt().contains(SPNEGOAuthentication.this.getUserName())).orElseThrow(IOException::new);
            passwordCallback.setPassword(SPNEGOAuthentication.this.getUserPassword().toCharArray());
        }
    }

    private static class SPNEGOContext {
        private static final String ATTRIBUTE = SPNEGOContext.class.getName();
        private Subject subject;
        private GSSContext gssContext;

        private SPNEGOContext() {
        }

        public String toString() {
            return String.format("%s@%x[context=%s]", this.getClass().getSimpleName(), this.hashCode(), this.gssContext);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Subject access$102(SPNEGOContext x0, Subject x1) {
            void var1_1;
            x0.subject = var1_1;
            return x0.subject;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ GSSContext access$702(SPNEGOContext x0, GSSContext x1) {
            void var1_1;
            x0.gssContext = var1_1;
            return x0.gssContext;
        }
    }

    public static class SPNEGOResult
    implements Authentication.Result {
        private final URI uri;
        private final HttpHeader header;
        private final String value;

        /*
         * WARNING - void declaration
         */
        public SPNEGOResult(URI uri, String token) {
            this((URI)var1_1, HttpHeader.AUTHORIZATION, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public SPNEGOResult(URI uri, HttpHeader header, String token) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.uri = var1_1;
            this.header = var2_2;
            this.value = NEGOTIATE + (token == null ? "" : " " + (String)var3_3);
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public void apply(Request request) {
            request.header(this.header, this.value);
        }
    }
}

