/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.Synchronizable;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.util.AbstractTypedContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class MultiPartContentProvider
extends AbstractTypedContentProvider
implements Closeable,
AsyncContentProvider {
    private static final Logger LOG = Log.getLogger(MultiPartContentProvider.class);
    private static final byte[] COLON_SPACE_BYTES = new byte[]{58, 32};
    private static final byte[] CR_LF_BYTES = new byte[]{13, 10};
    private final List<Part> parts = new ArrayList<Part>();
    private final ByteBuffer firstBoundary;
    private final ByteBuffer middleBoundary;
    private final ByteBuffer onlyBoundary;
    private final ByteBuffer lastBoundary;
    private final AtomicBoolean closed = new AtomicBoolean();
    private AsyncContentProvider.Listener listener;
    private long length = -1L;

    public MultiPartContentProvider() {
        this(MultiPartContentProvider.makeBoundary());
    }

    /*
     * WARNING - void declaration
     */
    public MultiPartContentProvider(String boundary) {
        super("multipart/form-data; boundary=" + boundary);
        void var1_1;
        void var2_2;
        String firstBoundaryLine = "--" + boundary + "\r\n";
        this.firstBoundary = ByteBuffer.wrap(firstBoundaryLine.getBytes(StandardCharsets.US_ASCII));
        String middleBoundaryLine = "\r\n" + firstBoundaryLine;
        this.middleBoundary = ByteBuffer.wrap(var2_2.getBytes(StandardCharsets.US_ASCII));
        String onlyBoundaryLine = "--" + boundary + "--\r\n";
        this.onlyBoundary = ByteBuffer.wrap(onlyBoundaryLine.getBytes(StandardCharsets.US_ASCII));
        String lastBoundaryLine = "\r\n" + onlyBoundaryLine;
        this.lastBoundary = ByteBuffer.wrap(var1_1.getBytes(StandardCharsets.US_ASCII));
    }

    /*
     * WARNING - void declaration
     */
    private static String makeBoundary() {
        void var0;
        StringBuilder builder = new StringBuilder("JettyHttpClientBoundary");
        builder.append(Long.toString(System.identityHashCode(builder), 36));
        builder.append(Long.toString(System.identityHashCode(Thread.currentThread()), 36));
        builder.append(Long.toString(System.nanoTime(), 36));
        return var0.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void addFieldPart(String name, ContentProvider content, HttpFields fields) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addPart(new Part((String)var1_1, null, "text/plain", (ContentProvider)var2_2, (HttpFields)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void addFilePart(String name, String fileName, ContentProvider content, HttpFields fields) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addPart(new Part((String)var1_1, (String)var2_2, "application/octet-stream", (ContentProvider)var3_3, fields));
    }

    /*
     * WARNING - void declaration
     */
    private void addPart(Part part) {
        this.parts.add(part);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("Added {}", new Object[]{var1_1});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        void var1_1;
        this.listener = var1_1;
        if (this.closed.get()) {
            this.length = this.calculateLength();
        }
    }

    /*
     * WARNING - void declaration
     */
    private long calculateLength() {
        void var1_1;
        if (this.parts.isEmpty()) {
            return this.onlyBoundary.remaining();
        }
        long result = 0L;
        for (int i = 0; i < this.parts.size(); ++i) {
            result += i == 0 ? (long)this.firstBoundary.remaining() : (long)this.middleBoundary.remaining();
            Part part = this.parts.get(i);
            long partLength = part.length;
            result += partLength;
            if (partLength >= 0L) continue;
            result = -1L;
            break;
        }
        if (result > 0L) {
            result += (long)this.lastBoundary.remaining();
        }
        return (long)var1_1;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new MultiPartIterator();
    }

    @Override
    public void close() {
        this.closed.compareAndSet(false, true);
    }

    private static enum State {
        FIRST_BOUNDARY,
        HEADERS,
        CONTENT,
        MIDDLE_BOUNDARY,
        LAST_BOUNDARY,
        COMPLETE;

    }

    private class MultiPartIterator
    implements Closeable,
    Iterator<ByteBuffer>,
    Synchronizable,
    Callback {
        private Iterator<ByteBuffer> iterator;
        private int index;
        private State state = State.FIRST_BOUNDARY;

        private MultiPartIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.state != State.COMPLETE;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteBuffer next() {
            while (true) {
                switch (this.state) {
                    case FIRST_BOUNDARY: {
                        if (MultiPartContentProvider.this.parts.isEmpty()) {
                            this.state = State.COMPLETE;
                            return MultiPartContentProvider.this.onlyBoundary.slice();
                        }
                        this.state = State.HEADERS;
                        return MultiPartContentProvider.this.firstBoundary.slice();
                    }
                    case HEADERS: {
                        void var1_1;
                        void var2_2;
                        Part part = (Part)MultiPartContentProvider.this.parts.get(this.index);
                        ContentProvider content = part.content;
                        if (content instanceof AsyncContentProvider) {
                            ((AsyncContentProvider)content).setListener(MultiPartContentProvider.this.listener);
                        }
                        this.iterator = var2_2.iterator();
                        this.state = State.CONTENT;
                        return ((Part)var1_1).headers.slice();
                    }
                    case CONTENT: {
                        if (this.iterator.hasNext()) {
                            return this.iterator.next();
                        }
                        ++this.index;
                        if (this.index < MultiPartContentProvider.this.parts.size()) {
                            this.state = State.MIDDLE_BOUNDARY;
                            if (!(this.iterator instanceof Closeable)) break;
                            IO.close((Closeable)((Closeable)((Object)this.iterator)));
                            break;
                        }
                        this.state = State.LAST_BOUNDARY;
                        break;
                    }
                    case MIDDLE_BOUNDARY: {
                        this.state = State.HEADERS;
                        return MultiPartContentProvider.this.middleBoundary.slice();
                    }
                    case LAST_BOUNDARY: {
                        this.state = State.COMPLETE;
                        return MultiPartContentProvider.this.lastBoundary.slice();
                    }
                    case COMPLETE: {
                        throw new NoSuchElementException();
                    }
                }
            }
        }

        @Override
        public Object getLock() {
            if (this.iterator instanceof Synchronizable) {
                return ((Synchronizable)((Object)this.iterator)).getLock();
            }
            return this;
        }

        public void succeeded() {
            if (this.state == State.CONTENT && this.iterator instanceof Callback) {
                ((Callback)this.iterator).succeeded();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            if (this.state == State.CONTENT && this.iterator instanceof Callback) {
                void var1_1;
                ((Callback)this.iterator).failed((Throwable)var1_1);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.iterator instanceof Closeable) {
                ((Closeable)((Object)this.iterator)).close();
            }
        }
    }

    private static class Part {
        private final String name;
        private final String fileName;
        private final String contentType;
        private final ContentProvider content;
        private final HttpFields fields;
        private final ByteBuffer headers;
        private final long length;

        /*
         * WARNING - void declaration
         */
        private Part(String name, String fileName, String contentType, ContentProvider content, HttpFields fields) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.name = var1_1;
            this.fileName = var2_2;
            this.contentType = var3_3;
            this.content = content;
            this.fields = fields;
            this.headers = this.headers();
            this.length = content.getLength() < 0L ? -1L : (long)this.headers.remaining() + content.getLength();
        }

        /*
         * WARNING - void declaration
         */
        private ByteBuffer headers() {
            try {
                void var3_5;
                Object contentDisposition = "Content-Disposition: form-data; name=\"" + this.name + "\"";
                if (this.fileName != null) {
                    contentDisposition = (String)contentDisposition + "; filename=\"" + this.fileName + "\"";
                }
                contentDisposition = (String)contentDisposition + "\r\n";
                String contentType = this.fields == null ? null : this.fields.get(HttpHeader.CONTENT_TYPE);
                if (contentType == null) {
                    contentType = this.content instanceof ContentProvider.Typed ? ((ContentProvider.Typed)this.content).getContentType() : this.contentType;
                }
                contentType = "Content-Type: " + contentType + "\r\n";
                if (this.fields == null || this.fields.size() == 0) {
                    String headers = contentDisposition;
                    headers = headers + contentType;
                    headers = headers + "\r\n";
                    return ByteBuffer.wrap(headers.getBytes(StandardCharsets.UTF_8));
                }
                ByteArrayOutputStream buffer = new ByteArrayOutputStream((this.fields.size() + 1) * ((String)contentDisposition).length());
                buffer.write(((String)contentDisposition).getBytes(StandardCharsets.UTF_8));
                buffer.write(contentType.getBytes(StandardCharsets.UTF_8));
                for (HttpField field : this.fields) {
                    if (HttpHeader.CONTENT_TYPE.equals((Object)field.getHeader())) continue;
                    buffer.write(field.getName().getBytes(StandardCharsets.US_ASCII));
                    buffer.write(COLON_SPACE_BYTES);
                    String value = field.getValue();
                    if (value != null) {
                        void var2_3;
                        buffer.write(var2_3.getBytes(StandardCharsets.UTF_8));
                    }
                    buffer.write(CR_LF_BYTES);
                }
                buffer.write(CR_LF_BYTES);
                return ByteBuffer.wrap(var3_5.toByteArray());
            }
            catch (IOException x) {
                void var1_2;
                throw new RuntimeIOException((Throwable)var1_2);
            }
        }

        public String toString() {
            return String.format("%s@%x[name=%s,fileName=%s,length=%d,headers=%s]", this.getClass().getSimpleName(), this.hashCode(), this.name, this.fileName, this.content.getLength(), this.fields);
        }
    }
}

