/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.DeferredContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamResponseListener
extends Response.Listener.Adapter {
    private static final Logger LOG = Log.getLogger(InputStreamResponseListener.class);
    private static final DeferredContentProvider.Chunk EOF = new DeferredContentProvider.Chunk(BufferUtil.EMPTY_BUFFER, Callback.NOOP);
    private final Object lock = this;
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<InputStream> stream = new AtomicReference();
    private final Queue<DeferredContentProvider.Chunk> chunks = new ArrayDeque<DeferredContentProvider.Chunk>();
    private Response response;
    private Result result;
    private Throwable failure;
    private boolean closed;

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHeaders(Response response) {
        Object object = this.lock;
        synchronized (object) {
            void var1_1;
            this.response = var1_1;
            this.responseLatch.countDown();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onContent(Response response, ByteBuffer content, Callback callback) {
        void var1_2;
        if (content.remaining() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped empty content {}", new Object[]{content});
            }
            callback.succeeded();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean closed = this.closed;
            if (!closed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queueing content {}", new Object[]{content});
                }
                this.chunks.add(new DeferredContentProvider.Chunk(content, callback));
                this.lock.notifyAll();
            }
        }
        if (var1_2 != false) {
            void var3_5;
            if (LOG.isDebugEnabled()) {
                void var2_4;
                LOG.debug("InputStream closed, ignored content {}", new Object[]{var2_4});
            }
            var3_5.failed((Throwable)new AsynchronousCloseException());
        }
    }

    @Override
    public void onSuccess(Response response) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.chunks.add(EOF);
            }
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("End of content", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFailure(Response response, Throwable failure) {
        void var2_3;
        void var1_1;
        Object object = this.lock;
        synchronized (object) {
            if (this.failure != null) {
                return;
            }
            this.failure = failure;
            List<Callback> callbacks = this.drain();
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Content failure", failure);
        }
        var1_1.forEach(arg_0 -> InputStreamResponseListener.lambda$onFailure$0((Throwable)var2_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onComplete(Result result) {
        void var2_3;
        void var3_4;
        Throwable failure = result.getFailure();
        List<Object> callbacks = Collections.emptyList();
        Object object = this.lock;
        synchronized (object) {
            void var1_1;
            this.result = result;
            if (var1_1.isFailed() && this.failure == null) {
                this.failure = failure;
                callbacks = this.drain();
            }
            this.responseLatch.countDown();
            this.resultLatch.countDown();
            this.lock.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            if (failure == null) {
                LOG.debug("Result success", new Object[0]);
            } else {
                LOG.debug("Result failure", failure);
            }
        }
        var3_4.forEach(arg_0 -> InputStreamResponseListener.lambda$onComplete$1((Throwable)var2_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public Response get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        void var3_4;
        void var1_1;
        boolean bl = !this.responseLatch.await((long)var1_1, (TimeUnit)var3_4);
        if (bl) {
            throw new TimeoutException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.response == null) {
                throw new ExecutionException(this.failure);
            }
            return this.response;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Result await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        void var3_4;
        void var1_1;
        boolean bl = !this.resultLatch.await((long)var1_1, (TimeUnit)var3_4);
        if (bl) {
            throw new TimeoutException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - void declaration
     */
    public InputStream getInputStream() {
        Input result = new Input();
        if (this.stream.compareAndSet(null, result)) {
            void var1_1;
            return var1_1;
        }
        return IO.getClosedStream();
    }

    /*
     * WARNING - void declaration
     */
    private List<Callback> drain() {
        void var1_1;
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        Object object = this.lock;
        synchronized (object) {
            DeferredContentProvider.Chunk chunk;
            while ((chunk = this.chunks.peek()) != null && chunk != EOF) {
                void var3_4;
                callbacks.add(var3_4.callback);
                this.chunks.poll();
            }
        }
        return var1_1;
    }

    private static /* synthetic */ void lambda$onComplete$1(Throwable failure, Callback callback) {
        Throwable throwable;
        callback.failed(throwable);
    }

    private static /* synthetic */ void lambda$onFailure$0(Throwable failure, Callback callback) {
        Throwable throwable;
        callback.failed(throwable);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$502(InputStreamResponseListener x0, boolean x1) {
        void var1_1;
        x0.closed = var1_1;
        return x0.closed;
    }

    private class Input
    extends InputStream {
        private Input() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int read() throws IOException {
            void var1_1;
            byte[] tmp = new byte[1];
            int read = this.read(tmp);
            if (read < 0) {
                void var2_2;
                return (int)var2_2;
            }
            return var1_1[0] & 0xFF;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int read(byte[] b, int offset, int length) throws IOException {
            try {
                void var3_4;
                Callback callback = null;
                Object object = InputStreamResponseListener.this.lock;
                synchronized (object) {
                    void var2_3;
                    void var1_1;
                    DeferredContentProvider.Chunk chunk;
                    while (true) {
                        if ((chunk = (DeferredContentProvider.Chunk)InputStreamResponseListener.this.chunks.peek()) == EOF) {
                            return -1;
                        }
                        if (chunk != null) break;
                        if (InputStreamResponseListener.this.failure != null) {
                            Input input = this;
                            throw input.toIOException(input.InputStreamResponseListener.this.failure);
                        }
                        if (InputStreamResponseListener.this.closed) {
                            throw new AsynchronousCloseException();
                        }
                        InputStreamResponseListener.this.lock.wait();
                    }
                    ByteBuffer buffer = chunk.buffer;
                    int result = Math.min(buffer.remaining(), length);
                    buffer.get((byte[])var1_1, (int)var2_3, result);
                    if (!buffer.hasRemaining()) {
                        callback = chunk.callback;
                        InputStreamResponseListener.this.chunks.poll();
                    }
                }
                if (callback != null) {
                    callback.succeeded();
                }
                return (int)var3_4;
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }

        /*
         * WARNING - void declaration
         */
        private IOException toIOException(Throwable failure) {
            void var1_1;
            if (failure instanceof IOException) {
                return (IOException)failure;
            }
            return new IOException((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void close() throws IOException {
            void var1_2;
            Object object = InputStreamResponseListener.this.lock;
            synchronized (object) {
                if (InputStreamResponseListener.this.closed) {
                    return;
                }
                InputStreamResponseListener.access$502(InputStreamResponseListener.this, true);
                List callbacks = InputStreamResponseListener.this.drain();
                InputStreamResponseListener.this.lock.notifyAll();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("InputStream close", new Object[0]);
            }
            AsynchronousCloseException failure = new AsynchronousCloseException();
            var1_2.forEach(arg_0 -> Input.lambda$close$0((Throwable)object, arg_0));
            super.close();
        }

        private static /* synthetic */ void lambda$close$0(Throwable failure, Callback callback) {
            Throwable throwable;
            callback.failed(throwable);
        }
    }
}

