/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamContentProvider
implements Closeable,
ContentProvider,
Callback {
    private static final Logger LOG = Log.getLogger(InputStreamContentProvider.class);
    private final InputStreamContentProviderIterator iterator = new InputStreamContentProviderIterator();
    private final InputStream stream;
    private final int bufferSize;
    private final boolean autoClose;

    /*
     * WARNING - void declaration
     */
    public InputStreamContentProvider(InputStream stream) {
        this((InputStream)var1_1, 4096);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public InputStreamContentProvider(InputStream stream, int bufferSize) {
        this((InputStream)var1_1, (int)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public InputStreamContentProvider(InputStream stream, int bufferSize, boolean autoClose) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.stream = var1_1;
        this.bufferSize = var2_2;
        this.autoClose = var3_3;
    }

    @Override
    public long getLength() {
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuffer onRead(byte[] buffer, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (length <= 0) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return ByteBuffer.wrap((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    protected void onReadFailure(Throwable failure) {
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.iterator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (this.autoClose) {
            try {
                this.stream.close();
                return;
            }
            catch (IOException x) {
                void var1_1;
                LOG.ignore((Throwable)var1_1);
            }
        }
    }

    public void failed(Throwable failure) {
        this.close();
    }

    private class InputStreamContentProviderIterator
    implements Closeable,
    Iterator<ByteBuffer> {
        private Throwable failure;
        private ByteBuffer buffer;
        private Boolean hasNext;

        private InputStreamContentProviderIterator() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasNext() {
            try {
                void var2_3;
                if (this.hasNext != null) {
                    return this.hasNext;
                }
                byte[] bytes = new byte[InputStreamContentProvider.this.bufferSize];
                int read = InputStreamContentProvider.this.stream.read(bytes);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", new Object[]{read, InputStreamContentProvider.this.stream});
                }
                if (read > 0) {
                    this.hasNext = Boolean.TRUE;
                    this.buffer = InputStreamContentProvider.this.onRead(bytes, 0, read);
                    return true;
                }
                if (var2_3 < 0) {
                    this.hasNext = Boolean.FALSE;
                    this.buffer = null;
                    this.close();
                    return false;
                }
                this.hasNext = Boolean.TRUE;
                this.buffer = BufferUtil.EMPTY_BUFFER;
                return true;
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(x);
                }
                if (this.failure == null) {
                    void var1_2;
                    this.failure = x;
                    InputStreamContentProvider.this.onReadFailure((Throwable)var1_2);
                    this.hasNext = Boolean.TRUE;
                    this.buffer = null;
                    this.close();
                    return true;
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteBuffer next() {
            void var1_1;
            if (this.failure != null) {
                this.hasNext = Boolean.FALSE;
                this.buffer = null;
                throw (NoSuchElementException)new NoSuchElementException().initCause(this.failure);
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ByteBuffer result = this.buffer;
            if (result == null) {
                this.hasNext = Boolean.FALSE;
                this.buffer = null;
                throw new NoSuchElementException();
            }
            this.hasNext = null;
            this.buffer = null;
            return var1_1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            InputStreamContentProvider.this.close();
        }
    }
}

