/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;

public class FutureResponseListener
extends BufferingResponseListener
implements Future<ContentResponse> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Request request;
    private ContentResponse response;
    private Throwable failure;
    private volatile boolean cancelled;

    /*
     * WARNING - void declaration
     */
    public FutureResponseListener(Request request) {
        this((Request)var1_1, 0x200000);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public FutureResponseListener(Request request, int maxLength) {
        super((int)var2_2);
        void var1_1;
        void var2_2;
        this.request = var1_1;
    }

    public Request getRequest() {
        return this.request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onComplete(Result result) {
        void var1_1;
        this.response = new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
        this.failure = var1_1.getFailure();
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelled = true;
        return this.request.abort(new CancellationException());
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L || this.isCancelled();
    }

    @Override
    public ContentResponse get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.getResult();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ContentResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var3_3;
        void var1_1;
        boolean bl = !this.latch.await((long)var1_1, (TimeUnit)var3_3);
        if (bl) {
            throw new TimeoutException();
        }
        return this.getResult();
    }

    private ContentResponse getResult() throws ExecutionException {
        if (this.isCancelled()) {
            throw (CancellationException)new CancellationException().initCause(this.failure);
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.response;
    }
}

