/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.AbstractAuthentication;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;

public class DigestAuthentication
extends AbstractAuthentication {
    private final Random random;
    private final String user;
    private final String password;

    /*
     * WARNING - void declaration
     */
    public DigestAuthentication(URI uri, String realm, String user, String password) {
        this((URI)var1_1, (String)var2_2, (String)var3_3, password, new SecureRandom());
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DigestAuthentication(URI uri, String realm, String user, String password, Random random) {
        super((URI)var1_1, (String)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        Objects.requireNonNull(random);
        this.random = random;
        this.user = var3_3;
        this.password = password;
    }

    @Override
    public String getType() {
        return "Digest";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean matches(String type, URI uri, String realm) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (realm == null) {
            return false;
        }
        return super.matches((String)var1_1, (URI)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, Authentication.HeaderInfo headerInfo, Attributes context) {
        void var1_1;
        void var2_2;
        void var3_3;
        String realm;
        MessageDigest messageDigest;
        Map<String, String> params = headerInfo.getParameters();
        String nonce = params.get("nonce");
        if (nonce == null || nonce.length() == 0) {
            return null;
        }
        String opaque = params.get("opaque");
        String algorithm = params.get("algorithm");
        if (algorithm == null) {
            algorithm = "MD5";
        }
        if ((messageDigest = this.getMessageDigest(algorithm)) == null) {
            return null;
        }
        String serverQOP = params.get("qop");
        String clientQOP = null;
        if (serverQOP != null) {
            List serverQOPValues = StringUtil.csvSplit(null, (String)serverQOP, (int)0, (int)serverQOP.length());
            if (serverQOPValues.contains("auth")) {
                clientQOP = "auth";
            } else if (serverQOPValues.contains("auth-int")) {
                clientQOP = "auth-int";
            }
        }
        if ("<<ANY_REALM>>".equals(realm = this.getRealm())) {
            realm = headerInfo.getRealm();
        }
        return new DigestResult(var3_3.getHeader(), var2_2.getContent(), (String)var1_1, this.user, this.password, algorithm, nonce, clientQOP, opaque);
    }

    private MessageDigest getMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ MessageDigest access$000(DigestAuthentication x0, String x1) {
        void var1_1;
        return x0.getMessageDigest((String)var1_1);
    }

    private class DigestResult
    implements Authentication.Result {
        private final AtomicInteger nonceCount = new AtomicInteger();
        private final HttpHeader header;
        private final byte[] content;
        private final String realm;
        private final String user;
        private final String password;
        private final String algorithm;
        private final String nonce;
        private final String qop;
        private final String opaque;

        /*
         * WARNING - void declaration
         */
        public DigestResult(HttpHeader header, byte[] content, String realm, String user, String password, String algorithm, String nonce, String qop, String opaque) {
            void var3_3;
            void var2_2;
            this.header = var2_2;
            this.content = var3_3;
            this.realm = realm;
            this.user = user;
            this.password = password;
            this.algorithm = algorithm;
            this.nonce = nonce;
            this.qop = qop;
            this.opaque = opaque;
        }

        @Override
        public URI getURI() {
            return DigestAuthentication.this.getURI();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void apply(Request request) {
            void var3_3;
            void var1_1;
            void var2_2;
            String a3;
            String clientNonce;
            String nonceCount;
            MessageDigest digester = DigestAuthentication.access$000(DigestAuthentication.this, this.algorithm);
            if (digester == null) {
                return;
            }
            String a1 = this.user + ":" + this.realm + ":" + this.password;
            String hashA1 = this.toHexString(digester.digest(a1.getBytes(StandardCharsets.ISO_8859_1)));
            String query = request.getQuery();
            String path = request.getPath();
            String uri = query == null ? path : path + "?" + query;
            String a2 = request.getMethod() + ":" + uri;
            if ("auth-int".equals(this.qop)) {
                a2 = a2 + ":" + this.toHexString(digester.digest(this.content));
            }
            String hashA2 = this.toHexString(digester.digest(a2.getBytes(StandardCharsets.ISO_8859_1)));
            if (this.qop != null) {
                nonceCount = this.nextNonceCount();
                clientNonce = this.newClientNonce();
                a3 = hashA1 + ":" + this.nonce + ":" + nonceCount + ":" + clientNonce + ":" + this.qop + ":" + hashA2;
            } else {
                nonceCount = null;
                clientNonce = null;
                a3 = a3 + ":" + this.nonce + ":" + hashA2;
            }
            String hashA3 = this.toHexString(digester.digest(a3.getBytes(StandardCharsets.ISO_8859_1)));
            StringBuilder value = new StringBuilder("Digest");
            value.append(" username=\"").append(this.user).append("\"");
            value.append(", realm=\"").append(this.realm).append("\"");
            value.append(", nonce=\"").append(this.nonce).append("\"");
            if (this.opaque != null) {
                value.append(", opaque=\"").append(this.opaque).append("\"");
            }
            value.append(", algorithm=\"").append(this.algorithm).append("\"");
            value.append(", uri=\"").append(uri).append("\"");
            if (this.qop != null) {
                value.append(", qop=\"").append(this.qop).append("\"");
                value.append(", nc=\"").append(nonceCount).append("\"");
                value.append(", cnonce=\"").append(clientNonce).append("\"");
            }
            value.append(", response=\"").append((String)var2_2).append("\"");
            var1_1.header(this.header, var3_3.toString());
        }

        /*
         * WARNING - void declaration
         */
        private String nextNonceCount() {
            void var2_2;
            void var1_1;
            String padding = "00000000";
            String next = Integer.toHexString(this.nonceCount.incrementAndGet()).toLowerCase(Locale.ENGLISH);
            return padding.substring(0, var1_1.length() - next.length()) + (String)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private String newClientNonce() {
            void var1_1;
            byte[] bytes = new byte[8];
            DigestAuthentication.this.random.nextBytes(bytes);
            return this.toHexString((byte[])var1_1);
        }

        private String toHexString(byte[] bytes) {
            return TypeUtil.toHexString((byte[])bytes).toLowerCase(Locale.ENGLISH);
        }
    }
}

