/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.Synchronizable;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class DeferredContentProvider
implements Closeable,
AsyncContentProvider,
Callback {
    private static final Chunk CLOSE = new Chunk(BufferUtil.EMPTY_BUFFER, Callback.NOOP);
    private final Object lock = this;
    private final Deque<Chunk> chunks = new ArrayDeque<Chunk>();
    private final AtomicReference<AsyncContentProvider.Listener> listener = new AtomicReference();
    private final DeferredContentProviderIterator iterator = new DeferredContentProviderIterator();
    private final AtomicBoolean closed = new AtomicBoolean();
    private long length = -1L;
    private int size;
    private Throwable failure;

    /*
     * WARNING - void declaration
     */
    public DeferredContentProvider(ByteBuffer ... buffers) {
        void var1_1;
        for (void buffer : var1_1) {
            this.offer((ByteBuffer)buffer);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        Object object;
        if (!this.listener.compareAndSet(null, (AsyncContentProvider.Listener)object)) {
            throw new IllegalStateException(String.format("The same %s instance cannot be used in multiple requests", AsyncContentProvider.class.getName()));
        }
        if (this.isClosed()) {
            object = this.lock;
            synchronized (object) {
                void var3_2;
                long total = 0L;
                for (Chunk chunk : this.chunks) {
                    total += (long)chunk.buffer.remaining();
                }
                this.length = var3_2;
                return;
            }
        }
    }

    @Override
    public long getLength() {
        return this.length;
    }

    /*
     * WARNING - void declaration
     */
    public boolean offer(ByteBuffer buffer) {
        void var1_1;
        return this.offer((ByteBuffer)var1_1, Callback.NOOP);
    }

    /*
     * WARNING - void declaration
     */
    public boolean offer(ByteBuffer buffer, Callback callback) {
        void var2_2;
        void var1_1;
        return this.offer(new Chunk((ByteBuffer)var1_1, (Callback)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private boolean offer(Chunk chunk) {
        void var3_3;
        Throwable failure;
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            failure = this.failure;
            if (failure == null && (result = this.chunks.offer(chunk)) && chunk != CLOSE) {
                ++this.size;
            }
        }
        if (failure != null) {
            void var2_5;
            void var1_1;
            var1_1.callback.failed((Throwable)var2_5);
        } else if (result) {
            this.notifyListener();
        }
        return (boolean)var3_3;
    }

    private void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.chunks.clear();
            return;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                while (true) {
                    if (this.failure != null) {
                        throw new IOException(this.failure);
                    }
                    if (this.size != 0) {
                        this.lock.wait();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
            return;
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.offer(CLOSE);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - void declaration
     */
    public void failed(Throwable failure) {
        void var1_1;
        this.iterator.failed((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void notifyListener() {
        AsyncContentProvider.Listener listener = this.listener.get();
        if (listener != null) {
            void var1_1;
            var1_1.onContent();
        }
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.iterator;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Throwable access$502(DeferredContentProvider x0, Throwable x1) {
        void var1_1;
        x0.failure = var1_1;
        return x0.failure;
    }

    public static class Chunk {
        public final ByteBuffer buffer;
        public final Callback callback;

        /*
         * WARNING - void declaration
         */
        public Chunk(ByteBuffer buffer, Callback callback) {
            void var2_2;
            void var1_1;
            this.buffer = (ByteBuffer)Objects.requireNonNull(var1_1);
            this.callback = (Callback)Objects.requireNonNull(var2_2);
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }

    private class DeferredContentProviderIterator
    implements Iterator<ByteBuffer>,
    Synchronizable,
    Callback {
        private Chunk current;

        private DeferredContentProviderIterator() {
        }

        @Override
        public boolean hasNext() {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                return DeferredContentProvider.this.chunks.peek() != CLOSE;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteBuffer next() {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                void var2_2;
                Chunk chunk = this.current = (Chunk)DeferredContentProvider.this.chunks.poll();
                if (this.current == CLOSE) {
                    DeferredContentProvider.this.chunks.offerFirst(CLOSE);
                    throw new NoSuchElementException();
                }
                return chunk == null ? null : var2_2.buffer;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        public void succeeded() {
            Chunk chunk;
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                chunk = this.current;
                if (chunk != null) {
                    --DeferredContentProvider.this.size;
                    DeferredContentProvider.this.lock.notify();
                }
            }
            if (chunk != null) {
                void var1_2;
                var1_2.callback.succeeded();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var2_3;
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            Iterator iterator = DeferredContentProvider.this.lock;
            synchronized (iterator) {
                DeferredContentProvider.access$502(DeferredContentProvider.this, x);
                Chunk chunk = this.current;
                this.current = null;
                if (chunk != null) {
                    chunks.add(chunk);
                }
                chunks.addAll(DeferredContentProvider.this.chunks);
                DeferredContentProvider.this.clear();
                DeferredContentProvider.this.lock.notify();
            }
            for (Chunk chunk : var2_3) {
                chunk.callback.failed(x);
            }
        }

        @Override
        public Object getLock() {
            return DeferredContentProvider.this.lock;
        }
    }
}

