/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.BufferUtil;

public abstract class BufferingResponseListener
extends Response.Listener.Adapter {
    private final int maxLength;
    private ByteBuffer buffer;
    private String mediaType;
    private String encoding;

    public BufferingResponseListener() {
        this(0x200000);
    }

    /*
     * WARNING - void declaration
     */
    public BufferingResponseListener(int maxLength) {
        void var1_1;
        if (maxLength < 0) {
            throw new IllegalArgumentException("Invalid max length " + maxLength);
        }
        this.maxLength = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onHeaders(Response response) {
        super.onHeaders(response);
        Request request = response.getRequest();
        HttpFields headers = response.getHeaders();
        long length = headers.getLongField(HttpHeader.CONTENT_LENGTH.asString());
        if (HttpMethod.HEAD.is(request.getMethod())) {
            length = 0L;
        }
        if (length > (long)this.maxLength) {
            response.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            return;
        }
        String contentType = headers.get(HttpHeader.CONTENT_TYPE);
        if (contentType != null) {
            void var2_3;
            int semicolon;
            String media = contentType;
            String charset = "charset=";
            int index = contentType.toLowerCase(Locale.ENGLISH).indexOf(charset);
            if (index > 0) {
                media = contentType.substring(0, index);
                String encoding = contentType.substring(index + charset.length());
                int semicolon2 = encoding.indexOf(59);
                if (semicolon2 > 0) {
                    encoding = encoding.substring(0, semicolon2).trim();
                }
                int lastIndex = encoding.length() - 1;
                if (encoding.charAt(0) == '\"' && encoding.charAt(lastIndex) == '\"') {
                    void var3_5;
                    encoding = encoding.substring(1, (int)var3_5).trim();
                }
                this.encoding = encoding;
            }
            if ((semicolon = media.indexOf(59)) > 0) {
                void var1_2;
                media = media.substring(0, (int)var1_2).trim();
            }
            this.mediaType = var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onContent(Response response2, ByteBuffer content) {
        void var2_3;
        int length = content.remaining();
        if (length > BufferUtil.space((ByteBuffer)this.buffer)) {
            void var1_2;
            void var3_4;
            int n = this.buffer == null ? 0 : this.buffer.remaining();
            if (n + length > this.maxLength) {
                response2.abort(new IllegalArgumentException("Buffering capacity " + this.maxLength + " exceeded"));
            }
            int response2 = this.buffer == null ? length : this.buffer.capacity() + var3_4;
            int newCapacity = Math.min(Integer.highestOneBit(response2) << 1, this.maxLength);
            this.buffer = BufferUtil.ensureCapacity((ByteBuffer)this.buffer, (int)var1_2);
        }
        BufferUtil.append((ByteBuffer)this.buffer, (ByteBuffer)var2_3);
    }

    @Override
    public abstract void onComplete(Result var1);

    public String getMediaType() {
        return this.mediaType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getContent() {
        if (this.buffer == null) {
            return new byte[0];
        }
        return BufferUtil.toArray((ByteBuffer)this.buffer);
    }

    /*
     * WARNING - void declaration
     */
    public String getContentAsString() {
        void var1_1;
        String encoding = this.encoding;
        if (encoding == null) {
            return this.getContentAsString(StandardCharsets.UTF_8);
        }
        return this.getContentAsString((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getContentAsString(String encoding) {
        void var1_1;
        if (this.buffer == null) {
            return null;
        }
        return BufferUtil.toString((ByteBuffer)this.buffer, (Charset)Charset.forName((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public String getContentAsString(Charset encoding) {
        void var1_1;
        if (this.buffer == null) {
            return null;
        }
        return BufferUtil.toString((ByteBuffer)this.buffer, (Charset)var1_1);
    }

    public InputStream getContentAsInputStream() {
        if (this.buffer == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(this.buffer.array(), this.buffer.arrayOffset(), this.buffer.remaining());
    }
}

