/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.AbstractAuthentication;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.Attributes;

public class BasicAuthentication
extends AbstractAuthentication {
    private final String user;
    private final String password;

    /*
     * WARNING - void declaration
     */
    public BasicAuthentication(URI uri, String realm, String user, String password) {
        super((URI)var1_1, (String)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.user = var3_3;
        this.password = password;
    }

    @Override
    public String getType() {
        return "Basic";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication.Result authenticate(Request request, ContentResponse response, Authentication.HeaderInfo headerInfo, Attributes context) {
        void var1_1;
        void var3_3;
        String charsetParam = headerInfo.getParameter("charset");
        Charset charset = charsetParam == null ? null : Charset.forName(charsetParam);
        return new BasicResult(this.getURI(), var3_3.getHeader(), this.user, this.password, (Charset)var1_1);
    }

    public static class BasicResult
    implements Authentication.Result {
        private final URI uri;
        private final HttpHeader header;
        private final String value;

        /*
         * WARNING - void declaration
         */
        public BasicResult(URI uri, String user, String password) {
            this((URI)var1_1, HttpHeader.AUTHORIZATION, (String)var2_2, (String)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public BasicResult(URI uri, HttpHeader header, String user, String password) {
            this((URI)var1_1, (HttpHeader)var2_2, (String)var3_3, password, StandardCharsets.ISO_8859_1);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public BasicResult(URI uri, HttpHeader header, String user, String password, Charset charset) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.uri = uri;
            this.header = var2_2;
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
            byte[] authBytes = ((String)var3_3 + ":" + password).getBytes(charset);
            this.value = "Basic " + Base64.getEncoder().encodeToString((byte[])var1_1);
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void apply(Request request) {
            if (!request.getHeaders().contains(this.header, this.value)) {
                void var1_1;
                var1_1.header(this.header, this.value);
            }
        }

        public String toString() {
            return String.format("Basic authentication result for %s", this.getURI());
        }
    }
}

