/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;

public class HttpSenderOverHTTP
extends HttpSender {
    private final HttpGenerator generator = new HttpGenerator();
    private final HttpClient httpClient;
    private boolean shutdown;

    /*
     * WARNING - void declaration
     */
    public HttpSenderOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
        void var1_1;
        this.httpClient = var1_1.getHttpDestination().getHttpClient();
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            void var2_3;
            new HeadersCallback(exchange, (HttpContent)var2_3, callback).iterate();
            return;
        }
        catch (Throwable x) {
            void var1_2;
            void var3_4;
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            var3_4.failed((Throwable)var1_2);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        try {
            bufferPool = this.httpClient.getByteBufferPool();
            chunk = null;
            block10: while (true) {
                contentBuffer = content.getByteBuffer();
                lastContent = content.isLast();
                result = this.generator.generateRequest(null, null, chunk, contentBuffer, lastContent);
                if (HttpSenderOverHTTP.LOG.isDebugEnabled()) {
                    HttpSenderOverHTTP.LOG.debug("Generated content ({} bytes) - {}/{}", new Object[]{contentBuffer == null ? -1 : contentBuffer.remaining(), result, this.generator});
                }
                switch (1.$SwitchMap$org$eclipse$jetty$http$HttpGenerator$Result[result.ordinal()]) {
                    case 1: {
                        chunk = bufferPool.acquire(12, false);
                        continue block10;
                    }
                    case 2: {
                        chunk = bufferPool.acquire(this.httpClient.getRequestBufferSize(), false);
                        continue block10;
                    }
                    case 3: {
                        endPoint = this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (chunk != null) {
                            endPoint.write((Callback)new ByteBufferRecyclerCallback(callback, bufferPool, new ByteBuffer[]{chunk}), new ByteBuffer[]{chunk, contentBuffer});
                            return;
                        }
                        var2_3.write(callback, new ByteBuffer[]{contentBuffer});
                        return;
                    }
                    case 4: {
                        this.shutdownOutput();
                        continue block10;
                    }
                    case 5: {
                        if (!lastContent) ** break;
                        continue block10;
                        callback.succeeded();
                        return;
                    }
                    case 6: {
                        callback.succeeded();
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException(result.toString());
        }
        catch (Throwable x) {
            if (HttpSenderOverHTTP.LOG.isDebugEnabled()) {
                HttpSenderOverHTTP.LOG.debug(x);
            }
            var3_4.failed((Throwable)var1_2);
            return;
        }
    }

    @Override
    protected void reset() {
        this.generator.reset();
        super.reset();
    }

    @Override
    protected void dispose() {
        this.generator.abort();
        super.dispose();
        this.shutdownOutput();
    }

    private void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request shutdown output {}", new Object[]{this.getHttpExchange().getRequest()});
        }
        this.shutdown = true;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.generator);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$100(HttpSenderOverHTTP x0, Request x1) {
        void var1_1;
        return x0.expects100Continue((Request)var1_1);
    }

    private class ByteBufferRecyclerCallback
    extends Callback.Nested {
        private final ByteBufferPool pool;
        private final ByteBuffer[] buffers;

        /*
         * WARNING - void declaration
         */
        private ByteBufferRecyclerCallback(Callback callback, ByteBufferPool pool, ByteBuffer ... buffers) {
            void var3_3;
            void var2_2;
            super((Callback)var2_2);
            this.pool = var3_3;
            this.buffers = buffers;
        }

        public void succeeded() {
            ByteBuffer[] byteBufferArray = this.buffers;
            int n = this.buffers.length;
            for (int i = 0; i < n; ++i) {
                ByteBuffer buffer = byteBufferArray[i];
                assert (!buffer.hasRemaining());
                this.pool.release(buffer);
            }
            super.succeeded();
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            ByteBuffer[] byteBufferArray = this.buffers;
            int n = this.buffers.length;
            for (int i = 0; i < n; ++i) {
                ByteBuffer buffer = byteBufferArray[i];
                this.pool.release(buffer);
            }
            super.failed((Throwable)var1_1);
        }
    }

    private class HeadersCallback
    extends IteratingCallback {
        private final HttpExchange exchange;
        private final Callback callback;
        private final MetaData.Request metaData;
        private ByteBuffer headerBuffer;
        private ByteBuffer chunkBuffer;
        private ByteBuffer contentBuffer;
        private boolean lastContent;
        private boolean generated;

        /*
         * WARNING - void declaration
         */
        public HeadersCallback(HttpExchange exchange, HttpContent content, Callback callback) {
            void var2_2;
            super(false);
            this.exchange = exchange;
            this.callback = callback;
            HttpRequest request = exchange.getRequest();
            ContentProvider requestContent = request.getContent();
            long contentLength = requestContent == null ? -1L : requestContent.getLength();
            String path = request.getPath();
            String query = request.getQuery();
            if (query != null) {
                path = path + "?" + query;
            }
            this.metaData = new MetaData.Request(request.getMethod(), new HttpURI(path), request.getVersion(), request.getHeaders(), contentLength);
            this.metaData.setTrailerSupplier(request.getTrailers());
            if (!HttpSenderOverHTTP.access$100(HttpSenderOverHTTP.this, (Request)var2_2)) {
                void var3_3;
                content.advance();
                this.contentBuffer = content.getByteBuffer();
                this.lastContent = var3_3.isLast();
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected IteratingCallback.Action process() throws Exception {
            void var1_1;
            block10: while (true) {
                HttpGenerator.Result result = HttpSenderOverHTTP.this.generator.generateRequest(this.metaData, this.headerBuffer, this.chunkBuffer, this.contentBuffer, this.lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Generated headers ({} bytes), chunk ({} bytes), content ({} bytes) - {}/{}", new Object[]{this.headerBuffer == null ? -1 : this.headerBuffer.remaining(), this.chunkBuffer == null ? -1 : this.chunkBuffer.remaining(), this.contentBuffer == null ? -1 : this.contentBuffer.remaining(), result, HttpSenderOverHTTP.this.generator});
                }
                switch (result) {
                    case NEED_HEADER: {
                        this.headerBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(HttpSenderOverHTTP.this.httpClient.getRequestBufferSize(), false);
                        continue block10;
                    }
                    case HEADER_OVERFLOW: {
                        HttpSenderOverHTTP.this.httpClient.getByteBufferPool().release(this.headerBuffer);
                        this.headerBuffer = null;
                        throw new BadMessageException(500, "Request header too large");
                    }
                    case NEED_CHUNK: {
                        this.chunkBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(12, false);
                        continue block10;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.chunkBuffer = HttpSenderOverHTTP.this.httpClient.getByteBufferPool().acquire(HttpSenderOverHTTP.this.httpClient.getRequestBufferSize(), false);
                        continue block10;
                    }
                    case FLUSH: {
                        void var3_2;
                        EndPoint endPoint = HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().getEndPoint();
                        if (this.headerBuffer == null) {
                            this.headerBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (this.chunkBuffer == null) {
                            this.chunkBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        if (this.contentBuffer == null) {
                            this.contentBuffer = BufferUtil.EMPTY_BUFFER;
                        }
                        long bytes = this.headerBuffer.remaining() + this.chunkBuffer.remaining() + this.contentBuffer.remaining();
                        HttpSenderOverHTTP.this.getHttpChannel().getHttpConnection().addBytesOut((long)var3_2);
                        var1_1.write((Callback)this, new ByteBuffer[]{this.headerBuffer, this.chunkBuffer, this.contentBuffer});
                        this.generated = true;
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        HttpSenderOverHTTP.this.shutdownOutput();
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        if (this.generated) return IteratingCallback.Action.SUCCEEDED;
                        continue block10;
                    }
                    case DONE: {
                        if (!this.generated) throw new HttpRequestException("Could not generate headers", this.exchange.getRequest());
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                }
                break;
            }
            throw new IllegalStateException(var1_1.toString());
        }

        public void succeeded() {
            this.release();
            super.succeeded();
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            this.release();
            super.failed((Throwable)var1_1);
        }

        protected void onCompleteSuccess() {
            super.onCompleteSuccess();
            this.callback.succeeded();
        }

        /*
         * WARNING - void declaration
         */
        protected void onCompleteFailure(Throwable cause) {
            void var1_1;
            super.onCompleteFailure(cause);
            this.callback.failed((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void release() {
            ByteBufferPool bufferPool = HttpSenderOverHTTP.this.httpClient.getByteBufferPool();
            if (!BufferUtil.isTheEmptyBuffer((ByteBuffer)this.headerBuffer)) {
                bufferPool.release(this.headerBuffer);
            }
            this.headerBuffer = null;
            if (!BufferUtil.isTheEmptyBuffer((ByteBuffer)this.chunkBuffer)) {
                void var1_1;
                var1_1.release(this.chunkBuffer);
            }
            this.chunkBuffer = null;
            this.contentBuffer = null;
        }
    }
}

