/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler {
    private final LongAdder inMessages = new LongAdder();
    private final HttpParser parser;
    private RetainableByteBuffer networkBuffer;
    private boolean shutdown;
    private boolean complete;
    private boolean unsolicited;
    private String method;
    private int status;

    /*
     * WARNING - void declaration
     */
    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
        void var1_1;
        this.parser = new HttpParser((HttpParser.ResponseHandler)this, -1, var1_1.getHttpDestination().getHttpClient().getHttpCompliance());
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    protected ByteBuffer getResponseBuffer() {
        if (this.networkBuffer == null) {
            return null;
        }
        return this.networkBuffer.getBuffer();
    }

    @Override
    public void receive() {
        if (this.networkBuffer == null) {
            this.acquireNetworkBuffer();
        }
        this.process();
    }

    private void acquireNetworkBuffer() {
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquired {}", new Object[]{this.networkBuffer});
        }
    }

    /*
     * WARNING - void declaration
     */
    private void reacquireNetworkBuffer() {
        RetainableByteBuffer currentBuffer = this.networkBuffer;
        if (currentBuffer == null) {
            throw new IllegalStateException();
        }
        if (currentBuffer.hasRemaining()) {
            throw new IllegalStateException();
        }
        currentBuffer.release();
        this.networkBuffer = this.newNetworkBuffer();
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("Reacquired {} <- {}", new Object[]{var1_1, this.networkBuffer});
        }
    }

    /*
     * WARNING - void declaration
     */
    private RetainableByteBuffer newNetworkBuffer() {
        void var1_1;
        void var2_2;
        HttpClient client = this.getHttpDestination().getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        return new RetainableByteBuffer((ByteBufferPool)var2_2, var1_1.getResponseBufferSize(), true);
    }

    private void releaseNetworkBuffer() {
        if (this.networkBuffer == null) {
            return;
        }
        this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", new Object[]{this.networkBuffer});
        }
        this.networkBuffer = null;
    }

    /*
     * WARNING - void declaration
     */
    protected ByteBuffer onUpgradeFrom() {
        void var2_2;
        RetainableByteBuffer networkBuffer = this.networkBuffer;
        if (networkBuffer == null) {
            return null;
        }
        ByteBuffer upgradeBuffer = null;
        if (networkBuffer.hasRemaining()) {
            void var1_1;
            upgradeBuffer = BufferUtil.allocate((int)networkBuffer.remaining());
            BufferUtil.clearToFill((ByteBuffer)upgradeBuffer);
            BufferUtil.put((ByteBuffer)var1_1.getBuffer(), (ByteBuffer)upgradeBuffer);
            BufferUtil.flipToFlush((ByteBuffer)upgradeBuffer, (int)0);
        }
        this.releaseNetworkBuffer();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void process() {
        try {
            void var3_4;
            HttpConnectionOverHTTP connection = this.getHttpConnection();
            EndPoint endPoint = connection.getEndPoint();
            while (true) {
                if (this.parse()) {
                    return;
                }
                if (connection.isClosed()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Closed {}", new Object[]{connection});
                    }
                    this.releaseNetworkBuffer();
                    return;
                }
                if (this.networkBuffer.getReferences() > 1) {
                    this.reacquireNetworkBuffer();
                }
                int read = endPoint.fill(this.networkBuffer.getBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes in {} from {}", new Object[]{read, this.networkBuffer, endPoint});
                }
                if (read <= 0) break;
                connection.addBytesIn(read);
            }
            if (var3_4 == false) {
                this.releaseNetworkBuffer();
                this.fillInterested();
                return;
            }
            this.releaseNetworkBuffer();
            this.shutdown();
            return;
        }
        catch (Throwable x) {
            void var1_2;
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            this.releaseNetworkBuffer();
            this.failAndClose((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean parse() {
        void var1_1;
        do {
            boolean handle = this.parser.parseNext(this.networkBuffer.getBuffer());
            boolean failed = this.isFailed();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse result={}, failed={}", new Object[]{handle, failed});
            }
            if (failed) {
                this.parser.close();
            }
            if (handle) {
                return !failed;
            }
            boolean complete = this.complete;
            this.complete = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parse complete={}, {} {}", new Object[]{complete, this.networkBuffer, this.parser});
            }
            if (complete) {
                void var2_2;
                void var3_3;
                int status = this.status;
                this.status = 0;
                if (status == 101) {
                    return true;
                }
                String method = this.method;
                this.method = null;
                if (this.getHttpChannel().isTunnel((String)var3_3, (int)var2_2)) {
                    return true;
                }
            }
            if (!this.networkBuffer.isEmpty()) continue;
            return false;
        } while (var1_1 == false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Discarding unexpected content after response: {}", new Object[]{this.networkBuffer});
        }
        this.networkBuffer.clear();
        return false;
    }

    protected void fillInterested() {
        this.getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    public int getHeaderCacheSize() {
        HttpClientTransportOverHTTP httpClientTransportOverHTTP = (HttpClientTransportOverHTTP)this.getHttpDestination().getHttpClient().getTransport();
        return httpClientTransportOverHTTP.getHeaderCacheSize();
    }

    /*
     * WARNING - void declaration
     */
    public boolean startResponse(HttpVersion version, int status, String reason) {
        void var3_3;
        void var2_2;
        void var1_1;
        HttpExchange exchange = this.getHttpExchange();
        boolean bl = this.unsolicited = exchange == null;
        if (exchange == null) {
            return false;
        }
        this.method = exchange.getRequest().getMethod();
        this.status = status;
        this.parser.setHeadResponse(HttpMethod.HEAD.is(this.method) || this.getHttpChannel().isTunnel(this.method, status));
        exchange.getResponse().version((HttpVersion)var1_1).status((int)var2_2).reason((String)var3_3);
        return !this.responseBegin(exchange);
    }

    /*
     * WARNING - void declaration
     */
    public void parsedHeader(HttpField field) {
        void var1_1;
        void var2_2;
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return;
        }
        this.responseHeader((HttpExchange)var2_2, (HttpField)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean headerComplete() {
        void var1_1;
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return false;
        }
        return !this.responseHeaders((HttpExchange)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean content(ByteBuffer buffer) {
        void var3_3;
        void var1_1;
        void var2_2;
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return false;
        }
        RetainableByteBuffer networkBuffer = this.networkBuffer;
        networkBuffer.retain();
        return !this.responseContent((HttpExchange)var2_2, (ByteBuffer)var1_1, Callback.from(() -> ((RetainableByteBuffer)networkBuffer).release(), arg_0 -> this.lambda$content$0((RetainableByteBuffer)var3_3, arg_0)));
    }

    public boolean contentComplete() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void parsedTrailer(HttpField trailer) {
        void var1_1;
        void var2_2;
        HttpExchange exchange = this.getHttpExchange();
        this.unsolicited |= exchange == null;
        if (this.unsolicited) {
            return;
        }
        var2_2.getResponse().trailer((HttpField)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean messageComplete() {
        void var1_1;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null || this.unsolicited) {
            this.getHttpConnection().close();
            return false;
        }
        int n = exchange.getResponse().getStatus();
        if (n != 100) {
            this.inMessages.increment();
            this.complete = true;
        }
        return !this.responseSuccess((HttpExchange)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void earlyEOF() {
        void var2_2;
        void var1_1;
        HttpExchange exchange = this.getHttpExchange();
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        if (var1_1 == null || this.unsolicited) {
            connection.close();
            return;
        }
        this.failAndClose(new EOFException(String.valueOf(var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    public void badMessage(BadMessageException failure) {
        void var1_1;
        void var2_2;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null || this.unsolicited) {
            this.getHttpConnection().close();
            return;
        }
        HttpResponse response = exchange.getResponse();
        response.status(failure.getCode()).reason(failure.getReason());
        this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + this.getHttpConnection(), (Response)var2_2, (Throwable)var1_1));
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    /*
     * WARNING - void declaration
     */
    private void failAndClose(Throwable failure) {
        if (this.responseFailure(failure)) {
            void var1_1;
            this.getHttpConnection().close((Throwable)var1_1);
        }
    }

    long getMessagesIn() {
        return this.inMessages.longValue();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.parser);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$content$0(RetainableByteBuffer networkBuffer, Throwable failure) {
        void var2_2;
        networkBuffer.release();
        this.failAndClose((Throwable)var2_2);
    }
}

