/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

public class HttpConnectionOverHTTP
extends AbstractConnection
implements Connection,
Connection.UpgradeFrom,
Attachable,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverHTTP.class);
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Promise<Connection> promise;
    private final Delegate delegate;
    private final HttpChannelOverHTTP channel;
    private long idleTimeout;
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();

    /*
     * WARNING - void declaration
     */
    public HttpConnectionOverHTTP(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        super((EndPoint)var1_1, destination.getHttpClient().getExecutor());
        void var2_2;
        void var3_3;
        void var1_1;
        this.promise = var3_3;
        this.delegate = new Delegate((HttpDestination)var2_2);
        this.channel = this.newHttpChannel();
    }

    protected HttpChannelOverHTTP newHttpChannel() {
        return new HttpChannelOverHTTP(this);
    }

    public HttpChannelOverHTTP getHttpChannel() {
        return this.channel;
    }

    public HttpDestinationOverHTTP getHttpDestination() {
        return (HttpDestinationOverHTTP)this.delegate.getHttpDestination();
    }

    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    /*
     * WARNING - void declaration
     */
    protected void addBytesIn(long bytesIn) {
        void var1_1;
        this.bytesIn.add((long)var1_1);
    }

    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    /*
     * WARNING - void declaration
     */
    protected void addBytesOut(long bytesOut) {
        void var1_1;
        this.bytesOut.add((long)var1_1);
    }

    public long getMessagesIn() {
        return this.getHttpChannel().getMessagesIn();
    }

    public long getMessagesOut() {
        return this.getHttpChannel().getMessagesOut();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(Request request, Response.CompleteListener listener) {
        void var2_2;
        void var1_1;
        this.delegate.send((Request)var1_1, (Response.CompleteListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SendFailure send(HttpExchange exchange) {
        void var1_1;
        return this.delegate.send((HttpExchange)var1_1);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
        this.promise.succeeded((Object)this);
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - void declaration
     */
    public void setAttachment(Object obj) {
        void var1_1;
        this.delegate.setAttachment(var1_1);
    }

    public Object getAttachment() {
        return this.delegate.getAttachment();
    }

    /*
     * WARNING - void declaration
     */
    public boolean onIdleExpired() {
        long idleTimeout = this.getEndPoint().getIdleTimeout();
        boolean bl = this.onIdleTimeout(idleTimeout);
        if (bl) {
            void var1_1;
            this.close(new TimeoutException("Idle timeout " + (long)var1_1 + " ms"));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean onIdleTimeout(long idleTimeout) {
        void var1_1;
        return this.delegate.onIdleTimeout((long)var1_1);
    }

    public void onFillable() {
        this.channel.receive();
    }

    public ByteBuffer onUpgradeFrom() {
        HttpReceiverOverHTTP httpReceiverOverHTTP = this.channel.getHttpReceiver();
        return httpReceiverOverHTTP.onUpgradeFrom();
    }

    public void release() {
        this.getEndPoint().setIdleTimeout(this.idleTimeout);
        this.getHttpDestination().release(this);
    }

    @Override
    public void close() {
        this.close(new AsynchronousCloseException());
    }

    /*
     * WARNING - void declaration
     */
    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            void var1_1;
            this.getHttpDestination().remove(this);
            this.abort((Throwable)var1_1);
            this.channel.destroy();
            this.getEndPoint().shutdownOutput();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Shutdown {}", new Object[]{this});
            }
            this.getEndPoint().close();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closed {}", new Object[]{this});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean abort(Throwable failure) {
        void var1_1;
        void var2_2;
        HttpExchange exchange = this.channel.getHttpExchange();
        return exchange != null && var2_2.getRequest().abort((Throwable)var1_1);
    }

    public boolean sweep() {
        if (!this.closed.get()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    public void remove() {
        this.getHttpDestination().remove(this);
    }

    public String toConnectionString() {
        return String.format("%s@%x(l:%s <-> r:%s,closed=%b)=>%s", this.getClass().getSimpleName(), this.hashCode(), this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress(), this.closed.get(), this.channel);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$202(HttpConnectionOverHTTP x0, long x1) {
        void var1_1;
        x0.idleTimeout = var1_1;
        return x0.idleTimeout;
    }

    private class Delegate
    extends HttpConnection {
        /*
         * WARNING - void declaration
         */
        private Delegate(HttpDestination destination) {
            void var2_2;
            super((HttpDestination)var2_2);
        }

        @Override
        protected Iterator<HttpChannel> getHttpChannels() {
            return Collections.singleton(HttpConnectionOverHTTP.this.channel).iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected SendFailure send(HttpExchange exchange) {
            void var1_1;
            void var2_2;
            HttpRequest request = exchange.getRequest();
            this.normalizeRequest(request);
            EndPoint endPoint = HttpConnectionOverHTTP.this.getEndPoint();
            HttpConnectionOverHTTP.access$202(HttpConnectionOverHTTP.this, endPoint.getIdleTimeout());
            long requestIdleTimeout = var2_2.getIdleTimeout();
            if (requestIdleTimeout >= 0L) {
                void var3_3;
                var3_3.setIdleTimeout(requestIdleTimeout);
            }
            Delegate delegate = this;
            return delegate.send(delegate.HttpConnectionOverHTTP.this.channel, (HttpExchange)var1_1);
        }

        @Override
        public void close() {
            HttpConnectionOverHTTP.this.close();
            this.destroy();
        }

        @Override
        public boolean isClosed() {
            return HttpConnectionOverHTTP.this.isClosed();
        }

        @Override
        public String toString() {
            return HttpConnectionOverHTTP.this.toString();
        }
    }
}

