/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    private int headerCacheSize = 1024;

    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    /*
     * WARNING - void declaration
     */
    public HttpClientTransportOverHTTP(int selectors) {
        super((int)var1_1);
        void var1_1;
        HttpClientTransportOverHTTP httpClientTransportOverHTTP = this;
        httpClientTransportOverHTTP.setConnectionPoolFactory(destination -> {
            void var1_1;
            return new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), (Callback)var1_1);
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        void var1_1;
        return new HttpDestinationOverHTTP(this.getHttpClient(), (Origin)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        void var2_2;
        void var1_1;
        void var3_3;
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, (HttpDestination)var3_3, (Promise<Connection>)promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", new Object[]{connection});
        }
        return this.customize((org.eclipse.jetty.io.Connection)var1_1, (Map)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<Connection> promise) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new HttpConnectionOverHTTP((EndPoint)var1_1, (HttpDestination)var2_2, (Promise<Connection>)var3_3);
    }

    @ManagedAttribute(value="The maximum allowed size in bytes for an HTTP header field cache")
    public int getHeaderCacheSize() {
        return this.headerCacheSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setHeaderCacheSize(int headerCacheSize) {
        void var1_1;
        this.headerCacheSize = var1_1;
    }
}

