/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.util.Locale;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;
    private final LongAdder outMessages = new LongAdder();

    /*
     * WARNING - void declaration
     */
    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        void var1_1;
        this.connection = var1_1;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSenderOverHTTP getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiverOverHTTP getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(HttpExchange exchange) {
        void var1_1;
        this.outMessages.increment();
        this.sender.send((HttpExchange)var1_1);
    }

    @Override
    public void release() {
        this.connection.release();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Result exchangeTerminating(HttpExchange exchange, Result result) {
        void var2_3;
        if (result.isFailed()) {
            return result;
        }
        HttpResponse response = ((HttpExchange)exchange).getResponse();
        if (response.getVersion() == HttpVersion.HTTP_1_1 && response.getStatus() == 101) {
            String nextConnection = response.getHeaders().get(HttpHeader.CONNECTION);
            if (nextConnection == null || !nextConnection.toLowerCase(Locale.US).contains("upgrade")) {
                return new Result(result, new HttpResponseException("101 Switching Protocols without Connection: Upgrade not supported", response));
            }
            HttpConnectionUpgrader upgrader = (HttpConnectionUpgrader)((HttpRequest)(exchange = ((HttpExchange)exchange).getRequest())).getConversation().getAttribute(HttpConnectionUpgrader.class.getName());
            if (upgrader != null) {
                try {
                    void var3_4;
                    upgrader.upgrade((HttpResponse)var3_4, this.getHttpConnection());
                }
                catch (Throwable x) {
                    void var1_2;
                    return new Result(result, (Throwable)var1_2);
                }
            }
        }
        return var2_3;
    }

    public void receive() {
        this.receiver.receive();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result) {
        void var2_4;
        void var1_1;
        void var3_5;
        super.exchangeTerminated(exchange, result);
        String method = exchange.getRequest().getMethod();
        Response response = result.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        String closeReason = null;
        if (result.isFailed()) {
            closeReason = "failure";
        } else if (this.receiver.isShutdown()) {
            closeReason = "server close";
        } else if (this.sender.isShutdown()) {
            closeReason = "client close";
        }
        if (closeReason == null) {
            void var4_6;
            if (response.getVersion().compareTo((Enum)HttpVersion.HTTP_1_1) < 0) {
                boolean keepAlive = responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                boolean connect = HttpMethod.CONNECT.is(method);
                if (!keepAlive && !connect) {
                    closeReason = "http/1.0";
                }
            } else if (var4_6.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                closeReason = "http/1.1";
            }
        }
        if (closeReason != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing, reason: {} - {}", new Object[]{closeReason, this.connection});
            }
            this.connection.close();
            return;
        }
        int status = var3_5.getStatus();
        if (status == 101 || this.isTunnel((String)var1_1, (int)var2_4)) {
            this.connection.remove();
            return;
        }
        ((HttpChannel)this).release();
    }

    protected long getMessagesIn() {
        return this.receiver.getMessagesIn();
    }

    protected long getMessagesOut() {
        return this.outMessages.longValue();
    }

    /*
     * WARNING - void declaration
     */
    boolean isTunnel(String method, int status) {
        void var2_2;
        void var1_1;
        return HttpMethod.CONNECT.is((String)var1_1) && HttpStatus.isSuccess((int)var2_2);
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

