/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.api;

import java.nio.ByteBuffer;
import java.util.EventListener;
import java.util.List;
import java.util.function.LongConsumer;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Callback;

public interface Response {
    public Request getRequest();

    public <T extends ResponseListener> List<T> getListeners(Class<T> var1);

    public HttpVersion getVersion();

    public int getStatus();

    public String getReason();

    public HttpFields getHeaders();

    public boolean abort(Throwable var1);

    public static interface Listener
    extends BeginListener,
    CompleteListener,
    ContentListener,
    FailureListener,
    HeaderListener,
    HeadersListener,
    SuccessListener {
        @Override
        default public void onBegin(Response response) {
        }

        @Override
        default public boolean onHeader(Response response, HttpField field) {
            return true;
        }

        @Override
        default public void onHeaders(Response response) {
        }

        @Override
        default public void onContent(Response response, ByteBuffer content) {
        }

        @Override
        default public void onSuccess(Response response) {
        }

        @Override
        default public void onFailure(Response response, Throwable failure) {
        }

        @Override
        default public void onComplete(Result result) {
        }

        public static class Adapter
        implements Listener {
        }
    }

    public static interface CompleteListener
    extends ResponseListener {
        public void onComplete(Result var1);
    }

    public static interface FailureListener
    extends ResponseListener {
        public void onFailure(Response var1, Throwable var2);
    }

    public static interface SuccessListener
    extends ResponseListener {
        public void onSuccess(Response var1);
    }

    public static interface DemandedContentListener
    extends ResponseListener {
        default public void onBeforeContent(Response response, LongConsumer demand) {
            demand.accept(1L);
        }

        public void onContent(Response var1, LongConsumer var2, ByteBuffer var3, Callback var4);
    }

    public static interface AsyncContentListener
    extends DemandedContentListener {
        public void onContent(Response var1, ByteBuffer var2, Callback var3);

        /*
         * WARNING - void declaration
         */
        @Override
        default public void onContent(Response response, LongConsumer demand, ByteBuffer content, Callback callback) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.onContent((Response)var1_1, (ByteBuffer)var3_3, Callback.from(() -> AsyncContentListener.lambda$onContent$0(callback, (LongConsumer)var2_2), arg_0 -> ((Callback)callback).failed(arg_0)));
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$onContent$0(Callback callback, LongConsumer demand) {
            void var1_1;
            callback.succeeded();
            var1_1.accept(1L);
        }
    }

    public static interface ContentListener
    extends AsyncContentListener {
        public void onContent(Response var1, ByteBuffer var2);

        /*
         * WARNING - void declaration
         */
        @Override
        default public void onContent(Response response, ByteBuffer content, Callback callback) {
            try {
                void var2_3;
                this.onContent(response, (ByteBuffer)var2_3);
                callback.succeeded();
                return;
            }
            catch (Throwable x) {
                void var1_2;
                void var3_4;
                var3_4.failed((Throwable)var1_2);
                return;
            }
        }
    }

    public static interface HeadersListener
    extends ResponseListener {
        public void onHeaders(Response var1);
    }

    public static interface HeaderListener
    extends ResponseListener {
        public boolean onHeader(Response var1, HttpField var2);
    }

    public static interface BeginListener
    extends ResponseListener {
        public void onBegin(Response var1);
    }

    public static interface ResponseListener
    extends EventListener {
    }
}

