/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class ValidatingConnectionPool
extends DuplexConnectionPool {
    private static final Logger LOG = Log.getLogger(ValidatingConnectionPool.class);
    private final Scheduler scheduler;
    private final long timeout;
    private final Map<Connection, Holder> quarantine;

    /*
     * WARNING - void declaration
     */
    public ValidatingConnectionPool(Destination destination, int maxConnections, Callback requester, Scheduler scheduler, long timeout) {
        super((HttpDestination)var1_1, maxConnections, (Callback)var3_3);
        void var2_2;
        void var3_3;
        void var1_1;
        this.scheduler = scheduler;
        this.timeout = timeout;
        this.quarantine = new ConcurrentHashMap<Connection, Holder>((int)var2_2);
    }

    @ManagedAttribute(value="The number of validating connections", readonly=true)
    public int getValidatingConnectionCount() {
        return this.quarantine.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean release(Connection connection) {
        void var1_1;
        void var2_2;
        Holder holder = new Holder(connection);
        new Holder(connection).task = this.scheduler.schedule((Runnable)holder, this.timeout, TimeUnit.MILLISECONDS);
        this.quarantine.put(connection, (Holder)var2_2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating for {}ms {}", new Object[]{this.timeout, connection});
        }
        this.released((Connection)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Connection connection) {
        void var1_1;
        void var2_2;
        boolean bl;
        Holder holder = this.quarantine.remove(connection);
        if (holder == null) {
            return super.remove(connection);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removed while validating {}", new Object[]{connection});
        }
        if (bl = var2_2.cancel()) {
            return this.remove(connection, true);
        }
        return super.remove((Connection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void dump(Appendable out, String indent) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        DumpableCollection toDump = new DumpableCollection("quarantine", this.quarantine.values());
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, (Object)this, (Object[])new Object[]{var3_3});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var1_1;
        int size = this.quarantine.size();
        return String.format("%s[v=%d]", super.toString(), (int)var1_1);
    }

    private class Holder
    implements Runnable {
        private final long timestamp = System.nanoTime();
        private final AtomicBoolean done = new AtomicBoolean();
        private final Connection connection;
        public Scheduler.Task task;

        /*
         * WARNING - void declaration
         */
        public Holder(Connection connection) {
            void var2_2;
            this.connection = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            if (this.done.compareAndSet(false, true)) {
                void var1_1;
                boolean closed = ValidatingConnectionPool.this.isClosed();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Validated {}", new Object[]{this.connection});
                }
                ValidatingConnectionPool.this.quarantine.remove(this.connection);
                if (!closed) {
                    ValidatingConnectionPool.this.deactivate(this.connection);
                }
                ValidatingConnectionPool.this.idle(this.connection, (boolean)var1_1);
                ValidatingConnectionPool.this.proceed();
            }
        }

        public boolean cancel() {
            if (this.done.compareAndSet(false, true)) {
                this.task.cancel();
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("%s[validationLeft=%dms]", this.connection, ValidatingConnectionPool.this.timeout - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.timestamp));
        }
    }
}

