/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class Socks4Proxy
extends ProxyConfiguration.Proxy {
    /*
     * WARNING - void declaration
     */
    public Socks4Proxy(String host, int port) {
        this(new Origin.Address((String)var1_1, (int)var2_2), false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Socks4Proxy(Origin.Address address, boolean secure) {
        super((Origin.Address)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        void var1_1;
        return new Socks4ProxyClientConnectionFactory((ClientConnectionFactory)var1_1);
    }

    private static class Socks4ProxyConnection
    extends AbstractConnection
    implements Callback {
        private static final Pattern IPv4_PATTERN = Pattern.compile("(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})");
        private static final Logger LOG = Log.getLogger(Socks4ProxyConnection.class);
        private final Socks4Parser parser = new Socks4Parser();
        private final ClientConnectionFactory connectionFactory;
        private final Map<String, Object> context;

        /*
         * WARNING - void declaration
         */
        public Socks4ProxyConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, Map<String, Object> context) {
            super((EndPoint)var1_1, (Executor)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.connectionFactory = var3_3;
            this.context = context;
        }

        public void onOpen() {
            super.onOpen();
            this.writeSocks4Connect();
        }

        /*
         * WARNING - void declaration
         */
        private void writeSocks4Connect() {
            void var2_3;
            void var1_2;
            ByteBuffer buffer;
            HttpDestination destination = (HttpDestination)this.context.get("http.destination");
            String host = destination.getHost();
            short port = (short)destination.getPort();
            Matcher matcher = IPv4_PATTERN.matcher(host);
            if (matcher.matches()) {
                buffer = ByteBuffer.allocate(9);
                buffer.put((byte)4).put((byte)1).putShort(port);
                for (int i = 1; i <= 4; ++i) {
                    buffer.put((byte)Integer.parseInt(matcher.group(i)));
                }
                buffer.put((byte)0);
                buffer.flip();
                this.getEndPoint().write((Callback)this, new ByteBuffer[]{buffer});
                return;
            }
            byte[] hostBytes = ((String)((Object)buffer)).getBytes(StandardCharsets.UTF_8);
            ByteBuffer buffer2 = ByteBuffer.allocate(9 + hostBytes.length + 1);
            buffer2.put((byte)4).put((byte)1).putShort((short)var1_2);
            buffer2.put((byte)0).put((byte)0).put((byte)0).put((byte)1).put((byte)0);
            buffer2.put((byte[])var2_3).put((byte)0);
            buffer2.flip();
            this.getEndPoint().write((Callback)this, new ByteBuffer[]{buffer2});
        }

        public void succeeded() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Written SOCKS4 connect request", new Object[0]);
            }
            this.fillInterested();
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            this.close();
            Promise promise = (Promise)this.context.get("http.connection.promise");
            promise.failed((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void onFillable() {
            try {
                ByteBuffer buffer;
                do {
                    void var2_3;
                    buffer = BufferUtil.allocate((int)this.parser.expected());
                    int filled = this.getEndPoint().fill(buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read SOCKS4 connect response, {} bytes", (long)filled);
                    }
                    if (filled < 0) {
                        throw new IOException("SOCKS4 tunnel failed, connection closed");
                    }
                    if (var2_3 != false) continue;
                    this.fillInterested();
                    return;
                } while (!Socks4Parser.access$200(this.parser, buffer));
                return;
            }
            catch (Throwable x) {
                void var1_2;
                this.failed((Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void onSocks4Response(int responseCode) throws IOException {
            void var1_1;
            if (responseCode == 90) {
                this.tunnel();
                return;
            }
            throw new IOException("SOCKS4 tunnel failed with code " + (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void tunnel() {
            try {
                void var2_3;
                HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                this.context.put("ssl.peer.host", destination.getHost());
                this.context.put("ssl.peer.port", destination.getPort());
                ClientConnectionFactory connectionFactory = this.connectionFactory;
                if (destination.isSecure()) {
                    connectionFactory = destination.newSslClientConnectionFactory(null, connectionFactory);
                }
                Connection newConnection = var2_3.newConnection(this.getEndPoint(), this.context);
                this.getEndPoint().upgrade(newConnection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SOCKS4 tunnel established: {} over {}", new Object[]{this, newConnection});
                }
                return;
            }
            catch (Throwable x) {
                void var1_2;
                this.failed((Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$300(Socks4ProxyConnection x0, int x1) throws IOException {
            void var1_1;
            x0.onSocks4Response((int)var1_1);
        }

        private class Socks4Parser {
            private static final int EXPECTED_LENGTH = 8;
            private int cursor;
            private int response;

            private Socks4Parser() {
            }

            /*
             * WARNING - void declaration
             */
            private boolean parse(ByteBuffer buffer) throws IOException {
                while (buffer.hasRemaining()) {
                    byte current = buffer.get();
                    if (this.cursor == 1) {
                        void var2_2;
                        this.response = var2_2 & 0xFF;
                    }
                    ++this.cursor;
                    if (this.cursor != 8) continue;
                    Socks4ProxyConnection.access$300(Socks4ProxyConnection.this, this.response);
                    return true;
                }
                return false;
            }

            private int expected() {
                return 8 - this.cursor;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ boolean access$200(Socks4Parser x0, ByteBuffer x1) throws IOException {
                void var1_1;
                return x0.parse((ByteBuffer)var1_1);
            }
        }
    }

    public static class Socks4ProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private final ClientConnectionFactory connectionFactory;

        /*
         * WARNING - void declaration
         */
        public Socks4ProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            void var1_1;
            this.connectionFactory = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
            void var2_2;
            void var1_1;
            HttpDestination httpDestination = (HttpDestination)context.get("http.destination");
            Executor executor = httpDestination.getHttpClient().getExecutor();
            Socks4ProxyConnection connection = new Socks4ProxyConnection(endPoint, (Executor)((Object)httpDestination), this.connectionFactory, context);
            return this.customize((Connection)var1_1, (Map)var2_2);
        }
    }
}

