/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongConsumer;
import java.util.function.ObjLongConsumer;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);

    /*
     * WARNING - void declaration
     */
    public void notifyBegin(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            void var3_3;
            if (!(listener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)var3_3, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyBegin(Response.BeginListener listener, Response response) {
        try {
            listener.onBegin(response);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    public boolean notifyHeader(List<Response.ResponseListener> listeners, Response response, HttpField field) {
        Iterator iterator;
        boolean result = true;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Response.ResponseListener listener = (Response.ResponseListener)iterator.next();
            if (!(listener instanceof Response.HeaderListener)) continue;
            result &= this.notifyHeader((Response.HeaderListener)listener, response, field);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private boolean notifyHeader(Response.HeaderListener listener, Response response, HttpField field) {
        try {
            void var3_4;
            return listener.onHeader(response, (HttpField)var3_4);
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyHeaders(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            void var3_3;
            if (!(listener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)var3_3, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyHeaders(Response.HeadersListener listener, Response response) {
        try {
            listener.onHeaders(response);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    public void notifyBeforeContent(Response response, ObjLongConsumer<Object> demand, List<Response.DemandedContentListener> contentListeners) {
        for (Response.DemandedContentListener listener : contentListeners) {
            this.notifyBeforeContent(listener, response, (long d) -> {
                void var2_2;
                void var1_1;
                demand.accept(var1_1, (long)var2_2);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyBeforeContent(Response.DemandedContentListener listener, Response response, LongConsumer demand) {
        try {
            void var3_4;
            listener.onBeforeContent(response, (LongConsumer)var3_4);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    public void notifyContent(Response response, ObjLongConsumer<Object> demand, ByteBuffer buffer, Callback callback, List<Response.DemandedContentListener> contentListeners) {
        Iterator iterator;
        int count = contentListeners.size();
        if (count == 0) {
            callback.succeeded();
            demand.accept(null, 1L);
            return;
        }
        if (count == 1) {
            Response.DemandedContentListener listener = contentListeners.get(0);
            this.notifyContent(listener, response, (long d) -> {
                void var2_2;
                void var1_1;
                demand.accept(var1_1, (long)var2_2);
            }, buffer.slice(), callback);
            return;
        }
        callback = new CountingCallback(callback, count);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Response.DemandedContentListener listener = (Response.DemandedContentListener)iterator.next();
            this.notifyContent(listener, response, (long d) -> {
                void var2_2;
                void var1_1;
                demand.accept(var1_1, (long)var2_2);
            }, buffer.slice(), callback);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyContent(Response.DemandedContentListener listener, Response response, LongConsumer demand, ByteBuffer buffer, Callback callback) {
        try {
            void var3_4;
            listener.onContent(response, (LongConsumer)var3_4, buffer, callback);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifySuccess(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            void var3_3;
            if (!(listener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)var3_3, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifySuccess(Response.SuccessListener listener, Response response) {
        try {
            listener.onSuccess(response);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    public void notifyFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)listener, response, failure);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyFailure(Response.FailureListener listener, Response response, Throwable failure) {
        try {
            void var3_4;
            listener.onFailure(response, (Throwable)var3_4);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyComplete(List<Response.ResponseListener> listeners, Result result) {
        for (Response.ResponseListener listener : listeners) {
            void var3_3;
            if (!(listener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)var3_3, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyComplete(Response.CompleteListener listener, Result result) {
        try {
            listener.onComplete(result);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forwardSuccess(List<Response.ResponseListener> listeners, Response response) {
        void var2_2;
        void var1_1;
        this.forwardEvents(listeners, response);
        this.notifySuccess((List<Response.ResponseListener>)var1_1, (Response)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void forwardSuccessComplete(List<Response.ResponseListener> listeners, Request request, Response response) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.forwardSuccess(listeners, response);
        this.notifyComplete((List<Response.ResponseListener>)var1_1, new Result((Request)var2_2, (Response)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void forwardFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.forwardEvents(listeners, response);
        this.notifyFailure((List<Response.ResponseListener>)var1_1, (Response)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void forwardEvents(List<Response.ResponseListener> listeners, Response response) {
        byte[] content;
        this.notifyBegin(listeners, response);
        Iterator iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = (HttpField)iterator.next();
            if (this.notifyHeader(listeners, response, field)) continue;
            iterator.remove();
        }
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse && (content = ((ContentResponse)response).getContent()) != null && content.length > 0) {
            void var1_1;
            void var3_3;
            void var2_2;
            List<Response.DemandedContentListener> contentListeners = listeners.stream().filter(Response.DemandedContentListener.class::isInstance).map(Response.DemandedContentListener.class::cast).collect(Collectors.toList());
            ObjLongConsumer<Object> demand = (context, value) -> {};
            this.notifyBeforeContent(response, demand, contentListeners);
            this.notifyContent((Response)var2_2, (ObjLongConsumer<Object>)var3_3, ByteBuffer.wrap(content), Callback.NOOP, (List<Response.DemandedContentListener>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void forwardFailureComplete(List<Response.ResponseListener> listeners, Request request, Throwable requestFailure, Response response, Throwable responseFailure) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.forwardFailure(listeners, response, responseFailure);
        this.notifyComplete((List<Response.ResponseListener>)var1_1, new Result((Request)var2_2, (Throwable)var3_3, response, responseFailure));
    }
}

