/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RequestNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);
    private final HttpClient client;

    /*
     * WARNING - void declaration
     */
    public RequestNotifier(HttpClient client) {
        void var1_1;
        this.client = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void notifyQueued(Request request) {
        List requestListeners = request.getRequestListeners(null);
        for (int i = 0; i < requestListeners.size(); ++i) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i);
            if (!(listener instanceof Request.QueuedListener)) continue;
            this.notifyQueued((Request.QueuedListener)listener, request);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            void var2_2;
            Request.Listener listener = listeners.get(i);
            this.notifyQueued((Request.QueuedListener)var2_2, request);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyQueued(Request.QueuedListener listener, Request request) {
        try {
            listener.onQueued(request);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyBegin(Request request) {
        List requestListeners = request.getRequestListeners(null);
        for (int i = 0; i < requestListeners.size(); ++i) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i);
            if (!(listener instanceof Request.BeginListener)) continue;
            this.notifyBegin((Request.BeginListener)listener, request);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            void var2_2;
            Request.Listener listener = listeners.get(i);
            this.notifyBegin((Request.BeginListener)var2_2, request);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyBegin(Request.BeginListener listener, Request request) {
        try {
            listener.onBegin(request);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyHeaders(Request request) {
        List requestListeners = request.getRequestListeners(null);
        for (int i = 0; i < requestListeners.size(); ++i) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i);
            if (!(listener instanceof Request.HeadersListener)) continue;
            this.notifyHeaders((Request.HeadersListener)listener, request);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            void var2_2;
            Request.Listener listener = listeners.get(i);
            this.notifyHeaders((Request.HeadersListener)var2_2, request);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyHeaders(Request.HeadersListener listener, Request request) {
        try {
            listener.onHeaders(request);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyCommit(Request request) {
        List requestListeners = request.getRequestListeners(null);
        for (int i = 0; i < requestListeners.size(); ++i) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i);
            if (!(listener instanceof Request.CommitListener)) continue;
            this.notifyCommit((Request.CommitListener)listener, request);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            void var2_2;
            Request.Listener listener = listeners.get(i);
            this.notifyCommit((Request.CommitListener)var2_2, request);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyCommit(Request.CommitListener listener, Request request) {
        try {
            listener.onCommit(request);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyContent(Request request, ByteBuffer content) {
        if (!(content = content.slice()).hasRemaining()) {
            return;
        }
        List requestListeners = request.getRequestListeners(null);
        for (int i = 0; i < requestListeners.size(); ++i) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i);
            if (!(listener instanceof Request.ContentListener)) continue;
            content.clear();
            this.notifyContent((Request.ContentListener)listener, request, content);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            void var3_3;
            Request.Listener listener = listeners.get(i);
            content.clear();
            this.notifyContent((Request.ContentListener)var3_3, request, content);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyContent(Request.ContentListener listener, Request request, ByteBuffer content) {
        try {
            void var3_4;
            listener.onContent(request, (ByteBuffer)var3_4);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifySuccess(Request request) {
        List requestListeners = request.getRequestListeners(null);
        for (int i = 0; i < requestListeners.size(); ++i) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i);
            if (!(listener instanceof Request.SuccessListener)) continue;
            this.notifySuccess((Request.SuccessListener)listener, request);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            void var2_2;
            Request.Listener listener = listeners.get(i);
            this.notifySuccess((Request.SuccessListener)var2_2, request);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifySuccess(Request.SuccessListener listener, Request request) {
        try {
            listener.onSuccess(request);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyFailure(Request request, Throwable failure) {
        List requestListeners = request.getRequestListeners(null);
        for (int i = 0; i < requestListeners.size(); ++i) {
            Request.RequestListener listener = (Request.RequestListener)requestListeners.get(i);
            if (!(listener instanceof Request.FailureListener)) continue;
            this.notifyFailure((Request.FailureListener)listener, request, failure);
        }
        List<Request.Listener> listeners = this.client.getRequestListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            void var3_3;
            Request.Listener listener = listeners.get(i);
            this.notifyFailure((Request.FailureListener)var3_3, request, failure);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void notifyFailure(Request.FailureListener listener, Request request, Throwable failure) {
        try {
            void var3_4;
            listener.onFailure(request, (Throwable)var3_4);
            return;
        }
        catch (Throwable x) {
            void var2_3;
            void var1_1;
            LOG.info("Exception while notifying listener " + var1_1, (Throwable)var2_3);
            return;
        }
    }
}

