/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class ProxyProtocolClientConnectionFactory
implements ClientConnectionFactory {
    private final ClientConnectionFactory factory;

    /*
     * WARNING - void declaration
     */
    private ProxyProtocolClientConnectionFactory(ClientConnectionFactory factory) {
        void var1_1;
        this.factory = var1_1;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.factory;
    }

    /*
     * WARNING - void declaration
     */
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        void var2_2;
        void var1_1;
        ProxyProtocolConnection connection = this.newProxyProtocolConnection(endPoint, context);
        return this.customize((Connection)var1_1, (Map)var2_2);
    }

    protected abstract ProxyProtocolConnection newProxyProtocolConnection(EndPoint var1, Map<String, Object> var2);

    private static class ProxyProtocolConnectionV2
    extends ProxyProtocolConnection {
        private static final byte[] MAGIC = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
        private final V2.Tag tag;

        /*
         * WARNING - void declaration
         */
        public ProxyProtocolConnectionV2(EndPoint endPoint, Executor executor, ClientConnectionFactory factory, Map<String, Object> context, V2.Tag tag) {
            super((EndPoint)var1_1, (Executor)var2_2, (ClientConnectionFactory)var3_3, context);
            void var3_3;
            void var2_2;
            void var1_1;
            this.tag = tag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void writePROXYBytes(EndPoint endPoint, Callback callback) {
            try {
                void var1_1;
                int dstPort;
                V2.Tag.Protocol protocol;
                int srcPort;
                int capacity = MAGIC.length;
                ++capacity;
                ++capacity;
                capacity += 2;
                capacity += 216;
                List<V2.Tag.TLV> tlvs = this.tag.getTLVs();
                int vectorsLength = tlvs == null ? 0 : tlvs.stream().mapToInt(tlv -> {
                    V2.Tag.TLV tLV;
                    return 3 + tLV.getValue().length;
                }).sum();
                ByteBuffer buffer = ByteBuffer.allocateDirect(capacity += vectorsLength);
                buffer.put(MAGIC);
                V2.Tag.Command command = this.tag.getCommand();
                int versionAndCommand = 0x20 | command.ordinal() & 0xF;
                buffer.put((byte)versionAndCommand);
                V2.Tag.Family family = this.tag.getFamily();
                String srcAddr = this.tag.getSourceAddress();
                if (srcAddr == null) {
                    srcAddr = endPoint.getLocalAddress().getAddress().getHostAddress();
                }
                if ((srcPort = this.tag.getSourcePort()) <= 0) {
                    srcPort = endPoint.getLocalAddress().getPort();
                }
                if (family == null) {
                    V2.Tag.Family family2 = family = InetAddress.getByName(srcAddr) instanceof Inet4Address ? V2.Tag.Family.INET4 : V2.Tag.Family.INET6;
                }
                if ((protocol = this.tag.getProtocol()) == null) {
                    protocol = V2.Tag.Protocol.STREAM;
                }
                int familyAndProtocol = family.ordinal() << 4 | protocol.ordinal();
                buffer.put((byte)familyAndProtocol);
                int length = 0;
                switch (family) {
                    case UNSPEC: {
                        break;
                    }
                    case INET4: {
                        length = 12;
                        break;
                    }
                    case INET6: {
                        length = 36;
                        break;
                    }
                    case UNIX: {
                        length = 216;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                buffer.putShort((short)(length += vectorsLength));
                String dstAddr = this.tag.getDestinationAddress();
                if (dstAddr == null) {
                    dstAddr = endPoint.getRemoteAddress().getAddress().getHostAddress();
                }
                if ((dstPort = this.tag.getDestinationPort()) <= 0) {
                    dstPort = endPoint.getRemoteAddress().getPort();
                }
                switch (family) {
                    case UNSPEC: {
                        break;
                    }
                    case INET4: 
                    case INET6: {
                        buffer.put(InetAddress.getByName(srcAddr).getAddress());
                        buffer.put(InetAddress.getByName(dstAddr).getAddress());
                        buffer.putShort((short)srcPort);
                        buffer.putShort((short)dstPort);
                        break;
                    }
                    case UNIX: {
                        int position = buffer.position();
                        buffer.put(srcAddr.getBytes(StandardCharsets.US_ASCII));
                        buffer.position(position + 108);
                        buffer.put(dstAddr.getBytes(StandardCharsets.US_ASCII));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (tlvs != null) {
                    for (V2.Tag.TLV tlv2 : tlvs) {
                        buffer.put((byte)tlv2.getType());
                        byte[] data = tlv2.getValue();
                        buffer.putShort((short)data.length);
                        buffer.put(data);
                    }
                }
                buffer.flip();
                var1_1.write(callback, new ByteBuffer[]{buffer});
                return;
            }
            catch (Throwable x) {
                void var3_5;
                void var2_2;
                var2_2.failed((Throwable)var3_5);
                return;
            }
        }
    }

    private static class ProxyProtocolConnectionV1
    extends ProxyProtocolConnection {
        private final V1.Tag tag;

        /*
         * WARNING - void declaration
         */
        public ProxyProtocolConnectionV1(EndPoint endPoint, Executor executor, ClientConnectionFactory factory, Map<String, Object> context, V1.Tag tag) {
            super((EndPoint)var1_1, (Executor)var2_2, (ClientConnectionFactory)var3_3, context);
            void var3_3;
            void var2_2;
            void var1_1;
            this.tag = tag;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void writePROXYBytes(EndPoint endPoint, Callback callback) {
            try {
                void var1_1;
                InetSocketAddress localAddress = endPoint.getLocalAddress();
                InetSocketAddress remoteAddress = endPoint.getRemoteAddress();
                String family = this.tag.getFamily();
                String srcIP = this.tag.getSourceAddress();
                int srcPort = this.tag.getSourcePort();
                String dstIP = this.tag.getDestinationAddress();
                int dstPort = this.tag.getDestinationPort();
                if (family == null) {
                    family = localAddress.getAddress() instanceof Inet4Address ? "TCP4" : "TCP6";
                }
                family = family.toUpperCase(Locale.ENGLISH);
                boolean unknown = family.equals("UNKNOWN");
                StringBuilder builder = new StringBuilder(64);
                builder.append("PROXY ").append(family);
                if (!unknown) {
                    if (srcIP == null) {
                        srcIP = localAddress.getAddress().getHostAddress();
                    }
                    builder.append(" ").append(srcIP);
                    if (dstIP == null) {
                        dstIP = remoteAddress.getAddress().getHostAddress();
                    }
                    builder.append(" ").append(dstIP);
                    if (srcPort <= 0) {
                        srcPort = localAddress.getPort();
                    }
                    builder.append(" ").append(srcPort);
                    if (dstPort <= 0) {
                        dstPort = remoteAddress.getPort();
                    }
                    builder.append(" ").append(dstPort);
                }
                builder.append("\r\n");
                String line = builder.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Writing PROXY bytes: {}", new Object[]{line.trim()});
                }
                ByteBuffer buffer = ByteBuffer.wrap(line.getBytes(StandardCharsets.US_ASCII));
                var1_1.write(callback, new ByteBuffer[]{buffer});
                return;
            }
            catch (Throwable x) {
                void var3_4;
                void var2_2;
                var2_2.failed((Throwable)var3_4);
                return;
            }
        }
    }

    protected static abstract class ProxyProtocolConnection
    extends AbstractConnection
    implements Callback {
        protected static final Logger LOG = Log.getLogger(ProxyProtocolConnection.class);
        private final ClientConnectionFactory factory;
        private final Map<String, Object> context;

        /*
         * WARNING - void declaration
         */
        private ProxyProtocolConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory factory, Map<String, Object> context) {
            super((EndPoint)var1_1, (Executor)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.factory = var3_3;
            this.context = context;
        }

        public void onOpen() {
            super.onOpen();
            ProxyProtocolConnection proxyProtocolConnection = this;
            proxyProtocolConnection.writePROXYBytes(proxyProtocolConnection.getEndPoint(), this);
        }

        protected abstract void writePROXYBytes(EndPoint var1, Callback var2);

        /*
         * WARNING - void declaration
         */
        public void succeeded() {
            try {
                void var2_3;
                EndPoint endPoint = this.getEndPoint();
                Connection connection = this.factory.newConnection(endPoint, this.context);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Written PROXY line, upgrading to {}", new Object[]{connection});
                }
                endPoint.upgrade((Connection)var2_3);
                return;
            }
            catch (Throwable x) {
                void var1_2;
                this.failed((Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            this.close();
            Promise promise = (Promise)this.context.get("http.connection.promise");
            promise.failed((Throwable)var1_1);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        public void onFillable() {
        }
    }

    public static class V2
    extends ProxyProtocolClientConnectionFactory {
        /*
         * WARNING - void declaration
         */
        public V2(ClientConnectionFactory factory) {
            super((ClientConnectionFactory)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected ProxyProtocolConnection newProxyProtocolConnection(EndPoint endPoint, Map<String, Object> context) {
            void var2_2;
            void var1_1;
            Tag tag;
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            Executor executor = destination.getHttpClient().getExecutor();
            Tag tag2 = (Tag)destination.getOrigin().getTag();
            if (tag2 == null) {
                InetSocketAddress local = endPoint.getLocalAddress();
                InetSocketAddress remote = endPoint.getRemoteAddress();
                boolean ipv4 = local.getAddress() instanceof Inet4Address;
                tag = new Tag(Tag.Command.PROXY, ipv4 ? Tag.Family.INET4 : Tag.Family.INET6, Tag.Protocol.STREAM, local.getAddress().getHostAddress(), ((InetSocketAddress)((Object)tag)).getPort(), remote.getAddress().getHostAddress(), remote.getPort(), null);
            }
            return new ProxyProtocolConnectionV2((EndPoint)var1_1, executor, this.getClientConnectionFactory(), (Map<String, Object>)var2_2, tag);
        }

        public static class Tag
        implements ClientConnectionFactory.Decorator {
            public static final Tag LOCAL = new Tag(Command.LOCAL, Family.UNSPEC, Protocol.UNSPEC, null, 0, null, 0, null);
            private Command command;
            private Family family;
            private Protocol protocol;
            private String srcIP;
            private int srcPort;
            private String dstIP;
            private int dstPort;
            private List<TLV> tlvs;

            public Tag() {
                this(null, 0);
            }

            /*
             * WARNING - void declaration
             */
            public Tag(String srcIP, int srcPort) {
                this(Command.PROXY, null, Protocol.STREAM, (String)var1_1, (int)var2_2, null, 0, null);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Tag(String srcIP, int srcPort, List<TLV> tlvs) {
                this(Command.PROXY, null, Protocol.STREAM, (String)var1_1, (int)var2_2, null, 0, (List<TLV>)var3_3);
                void var3_3;
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Tag(Command command, Family family, Protocol protocol, String srcIP, int srcPort, String dstIP, int dstPort, List<TLV> tlvs) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.command = var1_1;
                this.family = var2_2;
                this.protocol = var3_3;
                this.srcIP = srcIP;
                this.srcPort = srcPort;
                this.dstIP = dstIP;
                this.dstPort = dstPort;
                this.tlvs = tlvs;
            }

            public Command getCommand() {
                return this.command;
            }

            public Family getFamily() {
                return this.family;
            }

            public Protocol getProtocol() {
                return this.protocol;
            }

            public String getSourceAddress() {
                return this.srcIP;
            }

            public int getSourcePort() {
                return this.srcPort;
            }

            public String getDestinationAddress() {
                return this.dstIP;
            }

            public int getDestinationPort() {
                return this.dstPort;
            }

            public List<TLV> getTLVs() {
                return this.tlvs;
            }

            /*
             * WARNING - void declaration
             */
            public ClientConnectionFactory apply(ClientConnectionFactory factory) {
                void var1_1;
                return new V2((ClientConnectionFactory)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(Object obj) {
                void var1_1;
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Tag that = (Tag)obj;
                return this.command == that.command && this.family == that.family && this.protocol == that.protocol && Objects.equals(this.srcIP, that.srcIP) && this.srcPort == that.srcPort && Objects.equals(this.dstIP, that.dstIP) && this.dstPort == that.dstPort && Objects.equals(this.tlvs, var1_1.tlvs);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.command, this.family, this.protocol, this.srcIP, this.srcPort, this.dstIP, this.dstPort, this.tlvs});
            }

            public static class TLV {
                private final int type;
                private final byte[] value;

                /*
                 * WARNING - void declaration
                 */
                public TLV(int type, byte[] value) {
                    void var2_2;
                    void var1_1;
                    if (type < 0 || type > 255) {
                        throw new IllegalArgumentException("Invalid type: " + type);
                    }
                    if (value != null && value.length > 65535) {
                        throw new IllegalArgumentException("Invalid value length: " + value.length);
                    }
                    this.type = var1_1;
                    this.value = (byte[])Objects.requireNonNull(var2_2);
                }

                public int getType() {
                    return this.type;
                }

                public byte[] getValue() {
                    return this.value;
                }

                /*
                 * WARNING - void declaration
                 */
                public boolean equals(Object obj) {
                    void var1_1;
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null || this.getClass() != obj.getClass()) {
                        return false;
                    }
                    TLV that = (TLV)obj;
                    return this.type == that.type && Arrays.equals(this.value, var1_1.value);
                }

                /*
                 * WARNING - void declaration
                 */
                public int hashCode() {
                    void var1_1;
                    int result = Objects.hash(this.type);
                    var1_1 = var1_1 * 31 + Arrays.hashCode(this.value);
                    return (int)var1_1;
                }
            }

            public static enum Protocol {
                UNSPEC,
                STREAM,
                DGRAM;

            }

            public static enum Family {
                UNSPEC,
                INET4,
                INET6,
                UNIX;

            }

            public static enum Command {
                LOCAL,
                PROXY;

            }
        }
    }

    public static class V1
    extends ProxyProtocolClientConnectionFactory {
        /*
         * WARNING - void declaration
         */
        public V1(ClientConnectionFactory factory) {
            super((ClientConnectionFactory)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected ProxyProtocolConnection newProxyProtocolConnection(EndPoint endPoint, Map<String, Object> context) {
            void var2_2;
            void var1_1;
            Tag tag;
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            Executor executor = destination.getHttpClient().getExecutor();
            Tag tag2 = (Tag)destination.getOrigin().getTag();
            if (tag2 == null) {
                InetSocketAddress local = endPoint.getLocalAddress();
                InetSocketAddress remote = endPoint.getRemoteAddress();
                boolean ipv4 = local.getAddress() instanceof Inet4Address;
                tag = new Tag(ipv4 ? "TCP4" : "TCP6", local.getAddress().getHostAddress(), ((InetSocketAddress)((Object)tag)).getPort(), remote.getAddress().getHostAddress(), remote.getPort());
            }
            return new ProxyProtocolConnectionV1((EndPoint)var1_1, executor, this.getClientConnectionFactory(), (Map<String, Object>)var2_2, tag);
        }

        public static class Tag
        implements ClientConnectionFactory.Decorator {
            public static final Tag UNKNOWN = new Tag("UNKNOWN", null, 0, null, 0);
            private final String family;
            private final String srcIP;
            private final int srcPort;
            private final String dstIP;
            private final int dstPort;

            public Tag() {
                this(null, 0);
            }

            /*
             * WARNING - void declaration
             */
            public Tag(String srcIP, int srcPort) {
                this(null, (String)var1_1, (int)var2_2, null, 0);
                void var2_2;
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Tag(String family, String srcIP, int srcPort, String dstIP, int dstPort) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.family = var1_1;
                this.srcIP = var2_2;
                this.srcPort = var3_3;
                this.dstIP = dstIP;
                this.dstPort = dstPort;
            }

            public String getFamily() {
                return this.family;
            }

            public String getSourceAddress() {
                return this.srcIP;
            }

            public int getSourcePort() {
                return this.srcPort;
            }

            public String getDestinationAddress() {
                return this.dstIP;
            }

            public int getDestinationPort() {
                return this.dstPort;
            }

            /*
             * WARNING - void declaration
             */
            public ClientConnectionFactory apply(ClientConnectionFactory factory) {
                void var1_1;
                return new V1((ClientConnectionFactory)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public boolean equals(Object obj) {
                void var1_1;
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Tag that = (Tag)obj;
                return Objects.equals(this.family, that.family) && Objects.equals(this.srcIP, that.srcIP) && this.srcPort == that.srcPort && Objects.equals(this.dstIP, that.dstIP) && this.dstPort == var1_1.dstPort;
            }

            public int hashCode() {
                return Objects.hash(this.family, this.srcIP, this.srcPort, this.dstIP, this.dstPort);
            }
        }
    }
}

