/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import org.eclipse.jetty.client.AuthenticationProtocolHandler;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpHeader;

public class ProxyAuthenticationProtocolHandler
extends AuthenticationProtocolHandler {
    public static final String NAME = "proxy-authenticate";
    private static final String ATTRIBUTE = ProxyAuthenticationProtocolHandler.class.getName() + ".attribute";

    /*
     * WARNING - void declaration
     */
    public ProxyAuthenticationProtocolHandler(HttpClient client) {
        this((HttpClient)var1_1, 16384);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ProxyAuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        super((HttpClient)var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.getStatus() == 407;
    }

    @Override
    protected HttpHeader getAuthenticateHeader() {
        return HttpHeader.PROXY_AUTHENTICATE;
    }

    @Override
    protected HttpHeader getAuthorizationHeader() {
        return HttpHeader.PROXY_AUTHORIZATION;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected URI getAuthenticationURI(Request request) {
        void var1_1;
        HttpDestination httpDestination = this.getHttpClient().destinationFor(request.getScheme(), request.getHost(), request.getPort());
        ProxyConfiguration.Proxy proxy = httpDestination.getProxy();
        if (proxy != null) {
            return ((ProxyConfiguration.Proxy)((Object)httpDestination)).getURI();
        }
        return var1_1.getURI();
    }

    @Override
    protected String getAuthenticationAttribute() {
        return ATTRIBUTE;
    }
}

