/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.Objects;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.URIUtil;

public class Origin {
    private final String scheme;
    private final Address address;
    private final Object tag;

    /*
     * WARNING - void declaration
     */
    public Origin(String scheme, String host, int port) {
        this((String)var1_1, (String)var2_2, (int)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Origin(String scheme, String host, int port, Object tag) {
        this((String)var1_1, new Address((String)var2_2, (int)var3_3), tag);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Origin(String scheme, Address address) {
        this((String)var1_1, (Address)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Origin(String scheme, Address address, Object tag) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.scheme = (String)Objects.requireNonNull(var1_1);
        this.address = var2_2;
        this.tag = var3_3;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Address getAddress() {
        return this.address;
    }

    public Object getTag() {
        return this.tag;
    }

    /*
     * WARNING - void declaration
     */
    public String asString() {
        void var1_1;
        StringBuilder result = new StringBuilder();
        URIUtil.appendSchemeHostPort((StringBuilder)result, (String)this.scheme, (String)this.address.host, (int)this.address.port);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void var1_1;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Origin that = (Origin)obj;
        return this.scheme.equals(that.scheme) && this.address.equals(that.address) && Objects.equals(this.tag, var1_1.tag);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.address, this.tag);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        String result = this.asString();
        if (this.tag != null) {
            result = result + "[tag=" + this.tag + "]";
        }
        return var1_1;
    }

    public static class Address {
        private final String host;
        private final int port;

        /*
         * WARNING - void declaration
         */
        public Address(String host, int port) {
            void var2_2;
            void var1_1;
            this.host = HostPort.normalizeHost((String)((String)Objects.requireNonNull(var1_1)));
            this.port = var2_2;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void var1_1;
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Address that = (Address)obj;
            return this.host.equals(that.host) && this.port == var1_1.port;
        }

        /*
         * WARNING - void declaration
         */
        public int hashCode() {
            void var1_1;
            int result = this.host.hashCode();
            var1_1 = var1_1 * 31 + this.port;
            return (int)var1_1;
        }

        public String asString() {
            return String.format("%s:%d", this.host, this.port);
        }

        public String toString() {
            return this.asString();
        }
    }
}

