/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpSender
implements AsyncContentProvider.Listener {
    protected static final Logger LOG = Log.getLogger(HttpSender.class);
    private final AtomicReference<RequestState> requestState = new AtomicReference<RequestState>(RequestState.QUEUED);
    private final AtomicReference<SenderState> senderState = new AtomicReference<SenderState>(SenderState.IDLE);
    private final Callback commitCallback = new CommitCallback();
    private final IteratingCallback contentCallback = new ContentCallback();
    private final Callback lastCallback = new LastCallback();
    private final HttpChannel channel;
    private HttpContent content;
    private Throwable failure;

    /*
     * WARNING - void declaration
     */
    protected HttpSender(HttpChannel channel) {
        void var1_1;
        this.channel = var1_1;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    public boolean isFailed() {
        return this.requestState.get() == RequestState.FAILURE;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onContent() {
        var1_1 = this.getHttpExchange();
        if (var1_1 == null) {
            return;
        }
        block7: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 1: {
                    newSenderState = SenderState.SENDING;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 2: {
                    newSenderState = SenderState.SENDING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 3: {
                    newSenderState = SenderState.EXPECTING_WITH_CONTENT;
                    if (!this.updateSenderState(current, newSenderState)) continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, newSenderState});
                    }
                    return;
                }
                case 4: {
                    newSenderState = SenderState.PROCEEDING_WITH_CONTENT;
                    if (this.updateSenderState(current, newSenderState)) ** break;
                    continue block7;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {} -> {}", new Object[]{current, var2_2});
                    }
                    return;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Deferred content available, {}", new Object[]{current});
                    }
                    return;
                }
            }
            break;
        }
        this.illegalSenderState((SenderState)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void send(HttpExchange exchange) {
        void var1_1;
        if (!this.queuedToBegin(exchange)) {
            return;
        }
        HttpRequest request = exchange.getRequest();
        ContentProvider contentProvider = request.getContent();
        HttpContent content = this.content = new HttpContent(contentProvider);
        SenderState newSenderState = SenderState.SENDING;
        if (this.expects100Continue(request)) {
            newSenderState = content.hasContent() ? SenderState.EXPECTING_WITH_CONTENT : SenderState.EXPECTING;
        }
        block3: while (true) {
            SenderState current = this.senderState.get();
            switch (current) {
                case IDLE: 
                case COMPLETED: {
                    if (!this.updateSenderState(current, newSenderState)) continue block3;
                    break block3;
                }
                default: {
                    void var2_2;
                    this.illegalSenderState((SenderState)var2_2);
                    return;
                }
            }
            break;
        }
        if (contentProvider instanceof AsyncContentProvider) {
            void var3_3;
            ((AsyncContentProvider)var3_3).setListener(this);
        }
        if (!this.beginToHeaders(exchange)) {
            return;
        }
        this.sendHeaders((HttpExchange)var1_1, content, this.commitCallback);
    }

    protected boolean expects100Continue(Request request) {
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean queuedToBegin(HttpExchange exchange) {
        void var1_1;
        void var2_2;
        if (!this.updateRequestState(RequestState.QUEUED, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request begin {}", new Object[]{request});
        }
        RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        requestNotifier.notifyBegin((Request)var2_2);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.BEGIN)) {
            return true;
        }
        this.terminateRequest((HttpExchange)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean beginToHeaders(HttpExchange exchange) {
        void var1_1;
        void var2_2;
        if (!this.updateRequestState(RequestState.BEGIN, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request headers {}{}{}", new Object[]{request, System.lineSeparator(), request.getHeaders().toString().trim()});
        }
        RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        requestNotifier.notifyHeaders((Request)var2_2);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.HEADERS)) {
            return true;
        }
        this.terminateRequest((HttpExchange)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean headersToCommit(HttpExchange exchange) {
        void var1_1;
        void var2_2;
        if (!this.updateRequestState(RequestState.HEADERS, RequestState.TRANSIENT)) {
            return false;
        }
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request committed {}", new Object[]{request});
        }
        RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
        requestNotifier.notifyCommit((Request)var2_2);
        if (this.updateRequestState(RequestState.TRANSIENT, RequestState.COMMIT)) {
            return true;
        }
        this.terminateRequest((HttpExchange)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean someToContent(HttpExchange exchange, ByteBuffer content) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                void var1_1;
                void var2_2;
                void var3_3;
                if (!this.updateRequestState(current, RequestState.TRANSIENT)) {
                    return false;
                }
                HttpRequest request = exchange.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content {}{}{}", new Object[]{request, System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)content)});
                }
                RequestNotifier requestNotifier = this.getHttpChannel().getHttpDestination().getRequestNotifier();
                requestNotifier.notifyContent((Request)var3_3, (ByteBuffer)var2_2);
                if (this.updateRequestState(RequestState.TRANSIENT, RequestState.CONTENT)) {
                    return true;
                }
                this.terminateRequest((HttpExchange)var1_1);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean someToSuccess(HttpExchange exchange) {
        RequestState current = this.requestState.get();
        switch (current) {
            case COMMIT: 
            case CONTENT: {
                void var2_2;
                void var1_1;
                if (!exchange.requestComplete(null)) {
                    return false;
                }
                this.requestState.set(RequestState.QUEUED);
                this.reset();
                Object request = exchange.getRequest();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request success {}", new Object[]{request});
                }
                request = this.getHttpChannel().getHttpDestination();
                ((HttpDestination)request).getRequestNotifier().notifySuccess(exchange.getRequest());
                Result result = exchange.terminateRequest();
                this.terminateRequest((HttpExchange)var1_1, null, (Result)var2_2);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void anyToFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request failure " + exchange.getRequest(), failure);
        }
        if (exchange.requestComplete(failure)) {
            void var1_1;
            void var2_2;
            this.executeAbort((HttpExchange)var2_2, (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void executeAbort(HttpExchange exchange, Throwable failure) {
        try {
            Executor executor = this.getHttpChannel().getHttpDestination().getHttpClient().getExecutor();
            executor.execute(() -> {
                void var2_2;
                void var1_1;
                this.abort((HttpExchange)var1_1, (Throwable)var2_2);
            });
            return;
        }
        catch (RejectedExecutionException x) {
            void var2_2;
            void var1_1;
            if (LOG.isDebugEnabled()) {
                void var3_4;
                LOG.debug((Throwable)var3_4);
            }
            this.abort((HttpExchange)var1_1, (Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void terminateRequest(HttpExchange exchange) {
        void var3_3;
        void var2_2;
        void var1_1;
        Throwable failure = this.failure;
        if (failure == null) {
            failure = new HttpRequestException("Concurrent failure", exchange.getRequest());
        }
        Result result = exchange.terminateRequest();
        this.terminateRequest((HttpExchange)var1_1, (Throwable)var2_2, (Result)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private void terminateRequest(HttpExchange exchange, Throwable failure, Result result) {
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminating request {}", new Object[]{request});
        }
        if (result == null) {
            if (failure != null && exchange.responseComplete(failure)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response failure from request {} {}", new Object[]{request, exchange});
                }
                this.getHttpChannel().abortResponse(exchange, failure);
                return;
            }
        } else {
            void var2_2;
            result = this.channel.exchangeTerminating(exchange, result);
            HttpDestination destination = this.getHttpChannel().getHttpDestination();
            boolean ordered = destination.getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", new Object[]{failure == null ? "succeeded" : "failed", result});
            }
            HttpConversation conversation = exchange.getConversation();
            destination.getResponseNotifier().notifyComplete(var2_2.getResponseListeners(), result);
            if (ordered) {
                void var3_3;
                void var1_1;
                this.channel.exchangeTerminated((HttpExchange)var1_1, (Result)var3_3);
            }
        }
    }

    protected abstract void sendHeaders(HttpExchange var1, HttpContent var2, Callback var3);

    protected abstract void sendContent(HttpExchange var1, HttpContent var2, Callback var3);

    /*
     * WARNING - void declaration
     */
    protected void reset() {
        void var1_1;
        HttpContent content = this.content;
        this.content = null;
        var1_1.close();
        this.senderState.set(SenderState.COMPLETED);
    }

    /*
     * WARNING - void declaration
     */
    protected void dispose() {
        HttpContent content = this.content;
        this.content = null;
        if (content != null) {
            void var1_1;
            var1_1.close();
        }
        this.senderState.set(SenderState.FAILED);
    }

    /*
     * Unable to fully structure code
     */
    public void proceed(HttpExchange exchange, Throwable failure) {
        if (!this.expects100Continue(exchange.getRequest())) {
            return;
        }
        if (failure != null) {
            this.anyToFailure((Throwable)var2_2);
            return;
        }
        block6: while (true) {
            current = this.senderState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$client$HttpSender$SenderState[current.ordinal()]) {
                case 3: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while expecting", new Object[0]);
                    }
                    return;
                }
                case 6: {
                    if (!this.updateSenderState(current, SenderState.PROCEEDING_WITH_CONTENT)) continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while scheduled", new Object[0]);
                    }
                    return;
                }
                case 8: {
                    if (this.updateSenderState(current, SenderState.SENDING)) ** break;
                    continue block6;
                    if (HttpSender.LOG.isDebugEnabled()) {
                        HttpSender.LOG.debug("Proceeding while waiting", new Object[0]);
                    }
                    this.contentCallback.iterate();
                    return;
                }
                case 10: {
                    return;
                }
            }
            break;
        }
        this.illegalSenderState((SenderState)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean abort(HttpExchange exchange, Throwable failure) {
        RequestState current;
        do {
            current = this.requestState.get();
            switch (current) {
                case FAILURE: {
                    return false;
                }
            }
        } while (!this.updateRequestState(current, RequestState.FAILURE));
        boolean terminate = current != RequestState.TRANSIENT;
        this.failure = failure;
        this.dispose();
        HttpRequest request = exchange.getRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request abort {} {} on {}: {}", new Object[]{request, exchange, this.getHttpChannel(), failure});
        }
        HttpDestination httpDestination = this.getHttpChannel().getHttpDestination();
        httpDestination.getRequestNotifier().notifyFailure(request, failure);
        if (terminate) {
            void var3_5;
            void var2_2;
            void var1_1;
            Result result = exchange.terminateRequest();
            this.terminateRequest((HttpExchange)var1_1, (Throwable)var2_2, (Result)var3_5);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: request termination skipped, performed by helpers", new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateRequestState(RequestState from, RequestState to) {
        void var3_3;
        boolean updated = this.requestState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            void var2_2;
            void var1_1;
            LOG.debug("RequestState update failed: {} -> {}: {}", new Object[]{var1_1, var2_2, this.requestState.get()});
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateSenderState(SenderState from, SenderState to) {
        void var3_3;
        boolean updated = this.senderState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            void var2_2;
            void var1_1;
            LOG.debug("SenderState update failed: {} -> {}: {}", new Object[]{var1_1, var2_2, this.senderState.get()});
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private void illegalSenderState(SenderState current) {
        void var1_1;
        this.anyToFailure(new IllegalStateException("Expected " + var1_1 + " found " + (Object)((Object)this.senderState.get()) + " instead"));
    }

    public String toString() {
        return String.format("%s@%x(req=%s,snd=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.requestState, this.senderState, this.failure);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(HttpSender x0, Throwable x1) {
        void var1_1;
        x0.anyToFailure((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$700(HttpSender x0, SenderState x1, SenderState x2) {
        void var2_2;
        void var1_1;
        return x0.updateSenderState((SenderState)var1_1, (SenderState)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$800(HttpSender x0, SenderState x1) {
        void var1_1;
        x0.illegalSenderState((SenderState)var1_1);
    }

    private class LastCallback
    implements Callback {
        private LastCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public void succeeded() {
            void var1_1;
            void var2_2;
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            var2_2.succeeded();
            HttpSender.this.someToSuccess((HttpExchange)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable failure) {
            void var1_1;
            void var2_2;
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            var2_2.failed(failure);
            HttpSender.access$400(HttpSender.this, (Throwable)var1_1);
        }
    }

    private class ContentCallback
    extends IteratingCallback {
        private ContentCallback() {
        }

        /*
         * WARNING - void declaration
         */
        protected IteratingCallback.Action process() throws Exception {
            void var3_3;
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return IteratingCallback.Action.IDLE;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return IteratingCallback.Action.IDLE;
            }
            block4: while (true) {
                boolean advanced = content.advance();
                boolean lastContent = content.isLast();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content present {}, last {}, consumed {} for {}", new Object[]{advanced, lastContent, content.isConsumed(), exchange.getRequest()});
                }
                if (advanced) {
                    HttpSender.this.sendContent(exchange, content, (Callback)this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (lastContent) {
                    HttpSender.this.sendContent(exchange, content, HttpSender.this.lastCallback);
                    return IteratingCallback.Action.IDLE;
                }
                SenderState current = (SenderState)((Object)HttpSender.this.senderState.get());
                switch (current) {
                    case SENDING: {
                        if (!HttpSender.access$700(HttpSender.this, current, SenderState.IDLE)) continue block4;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Content is deferred for {}", new Object[]{exchange.getRequest()});
                        }
                        return IteratingCallback.Action.IDLE;
                    }
                    case SENDING_WITH_CONTENT: {
                        HttpSender.access$700(HttpSender.this, current, SenderState.SENDING);
                        continue block4;
                    }
                }
                break;
            }
            HttpSender.access$800(HttpSender.this, (SenderState)var3_3);
            return IteratingCallback.Action.IDLE;
        }

        /*
         * WARNING - void declaration
         */
        public void succeeded() {
            void var2_2;
            void var1_1;
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            content.succeeded();
            ByteBuffer buffer = content.getContent();
            HttpSender.this.someToContent((HttpExchange)var1_1, (ByteBuffer)var2_2);
            super.succeeded();
        }

        /*
         * WARNING - void declaration
         */
        public void onCompleteFailure(Throwable failure) {
            void var1_1;
            void var2_2;
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            var2_2.failed(failure);
            HttpSender.access$400(HttpSender.this, (Throwable)var1_1);
        }

        protected void onCompleteSuccess() {
        }
    }

    private class CommitCallback
    implements Callback {
        private CommitCallback() {
        }

        /*
         * WARNING - void declaration
         */
        public void succeeded() {
            try {
                HttpContent content = HttpSender.this.content;
                if (content == null) {
                    return;
                }
                content.succeeded();
                this.process();
                return;
            }
            catch (Throwable x) {
                void var1_2;
                HttpSender.access$400(HttpSender.this, (Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable failure) {
            void var1_1;
            void var2_2;
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            var2_2.failed(failure);
            HttpSender.access$400(HttpSender.this, (Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void process() throws Exception {
            void var1_1;
            void var2_2;
            HttpExchange exchange = HttpSender.this.getHttpExchange();
            if (exchange == null) {
                return;
            }
            if (!HttpSender.this.headersToCommit(exchange)) {
                return;
            }
            HttpContent content = HttpSender.this.content;
            if (content == null) {
                return;
            }
            if (!content.hasContent()) {
                HttpSender.this.someToSuccess(exchange);
                return;
            }
            ByteBuffer contentBuffer = content.getContent();
            if (contentBuffer != null && !HttpSender.this.someToContent(exchange, (ByteBuffer)var2_2)) {
                return;
            }
            block9: while (true) {
                SenderState current = (SenderState)((Object)HttpSender.this.senderState.get());
                switch (current) {
                    case SENDING: {
                        HttpSender.this.contentCallback.iterate();
                        return;
                    }
                    case SENDING_WITH_CONTENT: {
                        HttpSender.access$700(HttpSender.this, current, SenderState.SENDING);
                        continue block9;
                    }
                    case EXPECTING: {
                        if (!HttpSender.access$700(HttpSender.this, current, SenderState.WAITING)) continue block9;
                        return;
                    }
                    case EXPECTING_WITH_CONTENT: {
                        if (!HttpSender.access$700(HttpSender.this, current, SenderState.WAITING)) continue block9;
                        return;
                    }
                    case PROCEEDING: {
                        if (!HttpSender.access$700(HttpSender.this, current, SenderState.IDLE)) continue block9;
                        return;
                    }
                    case PROCEEDING_WITH_CONTENT: {
                        HttpSender.access$700(HttpSender.this, current, SenderState.SENDING);
                        continue block9;
                    }
                    case FAILED: {
                        return;
                    }
                }
                break;
            }
            HttpSender.access$800(HttpSender.this, (SenderState)var1_1);
        }
    }

    private static enum SenderState {
        IDLE,
        SENDING,
        SENDING_WITH_CONTENT,
        EXPECTING,
        EXPECTING_WITH_CONTENT,
        WAITING,
        PROCEEDING,
        PROCEEDING_WITH_CONTENT,
        COMPLETED,
        FAILED;

    }

    private static enum RequestState {
        TRANSIENT,
        QUEUED,
        BEGIN,
        HEADERS,
        COMMIT,
        CONTENT,
        FAILURE;

    }
}

