/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public class HttpResponse
implements Response {
    private final HttpFields headers = new HttpFields();
    private final Request request;
    private final List<Response.ResponseListener> listeners;
    private HttpVersion version;
    private int status;
    private String reason;
    private HttpFields trailers;

    /*
     * WARNING - void declaration
     */
    public HttpResponse(Request request, List<Response.ResponseListener> listeners) {
        void var2_2;
        void var1_1;
        this.request = var1_1;
        this.listeners = var2_2;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse version(HttpVersion version) {
        void var1_1;
        this.version = var1_1;
        return this;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse status(int status) {
        void var1_1;
        this.status = var1_1;
        return this;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse reason(String reason) {
        void var1_1;
        this.reason = var1_1;
        return this;
    }

    @Override
    public HttpFields getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Response.ResponseListener> List<T> getListeners(Class<T> type) {
        void var2_2;
        ArrayList<Response.ResponseListener> result = new ArrayList<Response.ResponseListener>();
        for (Response.ResponseListener listener : this.listeners) {
            if (type != null && !type.isInstance(listener)) continue;
            result.add(listener);
        }
        return var2_2;
    }

    public HttpFields getTrailers() {
        return this.trailers;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse trailer(HttpField trailer) {
        void var1_1;
        if (this.trailers == null) {
            this.trailers = new HttpFields();
        }
        this.trailers.add((HttpField)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean abort(Throwable cause) {
        void var1_1;
        return this.request.abort((Throwable)var1_1);
    }

    public String toString() {
        return String.format("%s[%s %d %s]@%x", HttpResponse.class.getSimpleName(), this.getVersion(), this.getStatus(), this.getReason(), this.hashCode());
    }
}

