/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.PathContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

public class HttpRequest
implements Request {
    private static final URI NULL_URI = URI.create("null:0");
    private final HttpFields headers = new HttpFields();
    private final Fields params = new Fields(true);
    private final List<Response.ResponseListener> responseListeners = new ArrayList<Response.ResponseListener>();
    private final AtomicReference<Throwable> aborted = new AtomicReference();
    private final HttpClient client;
    private final HttpConversation conversation;
    private String scheme;
    private String host;
    private int port;
    private String path;
    private String query;
    private URI uri;
    private String method = HttpMethod.GET.asString();
    private HttpVersion version = HttpVersion.HTTP_1_1;
    private long idleTimeout = -1L;
    private long timeout;
    private long timeoutAt = Long.MAX_VALUE;
    private ContentProvider content;
    private boolean followRedirects;
    private List<HttpCookie> cookies;
    private Map<String, Object> attributes;
    private List<Request.RequestListener> requestListeners;
    private BiFunction<Request, Request, Response.CompleteListener> pushListener;
    private Supplier<HttpFields> trailers;
    private Object tag;
    private boolean normalized;

    /*
     * WARNING - void declaration
     */
    protected HttpRequest(HttpClient client, HttpConversation conversation, URI uri) {
        HttpField userAgentField;
        void var3_3;
        this.client = client;
        this.conversation = conversation;
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = HttpClient.normalizePort(this.scheme, uri.getPort());
        this.path = uri.getRawPath();
        this.query = var3_3.getRawQuery();
        HttpRequest httpRequest = this;
        httpRequest.extractParams(httpRequest.query);
        this.followRedirects(client.isFollowRedirects());
        HttpField acceptEncodingField = client.getAcceptEncodingField();
        if (acceptEncodingField != null) {
            void var2_2;
            this.headers.put((HttpField)var2_2);
        }
        if ((userAgentField = client.getUserAgentField()) != null) {
            void var1_1;
            this.headers.put((HttpField)var1_1);
        }
    }

    public HttpConversation getConversation() {
        return this.conversation;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request scheme(String scheme) {
        void var1_1;
        this.scheme = var1_1;
        this.uri = null;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request host(String host) {
        void var1_1;
        this.host = var1_1;
        this.uri = null;
        return this;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request port(int port) {
        void var1_1;
        this.port = var1_1;
        this.uri = null;
        return this;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request method(HttpMethod method) {
        void var1_1;
        return this.method(var1_1.asString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request method(String method) {
        void var1_1;
        this.method = ((String)Objects.requireNonNull(var1_1)).toUpperCase(Locale.ENGLISH);
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request path(String path) {
        URI uri = this.newURI(path);
        if (uri == null) {
            this.path = path;
            this.query = null;
        } else {
            void var2_2;
            String rawPath = uri.getRawPath();
            if (rawPath == null) {
                rawPath = "";
            }
            if (!rawPath.startsWith("/")) {
                rawPath = "/" + rawPath;
            }
            this.path = rawPath;
            String query = uri.getRawQuery();
            if (query != null) {
                void var1_1;
                this.query = query;
                this.params.clear();
                this.extractParams((String)var1_1);
            }
            if (var2_2.isAbsolute()) {
                this.path = this.buildURI(false).toString();
            }
        }
        this.uri = null;
        return this;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public URI getURI() {
        boolean bl;
        if (this.uri == null) {
            this.uri = this.buildURI(true);
        }
        if (bl = this.uri == NULL_URI) {
            return null;
        }
        return this.uri;
    }

    @Override
    public HttpVersion getVersion() {
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request version(HttpVersion version) {
        void var1_1;
        this.version = (HttpVersion)Objects.requireNonNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request param(String name, String value) {
        void var2_2;
        void var1_1;
        return this.param((String)var1_1, (String)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    private Request param(String name, String value, boolean fromQuery) {
        void var3_3;
        this.params.add(name, value);
        if (var3_3 == false) {
            void var2_2;
            void var1_1;
            this.query = this.query != null ? this.query + "&" + this.urlEncode((String)var1_1) + "=" + this.urlEncode((String)var2_2) : this.buildQuery();
            this.uri = null;
        }
        return this;
    }

    @Override
    public Fields getParams() {
        return new Fields(this.params, true);
    }

    @Override
    public String getAgent() {
        return this.headers.get(HttpHeader.USER_AGENT);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request agent(String agent) {
        void var1_1;
        this.headers.put(HttpHeader.USER_AGENT, (String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request accept(String ... accepts) {
        void var1_1;
        StringBuilder result = new StringBuilder();
        for (void accept : var1_1) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append((String)accept);
        }
        if (result.length() > 0) {
            void var2_2;
            this.headers.put(HttpHeader.ACCEPT, var2_2.toString());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request header(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            void var2_2;
            void var1_1;
            this.headers.add((String)var1_1, (String)var2_2);
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request header(HttpHeader header, String value) {
        if (value == null) {
            this.headers.remove(header);
        } else {
            void var2_2;
            void var1_1;
            this.headers.add((HttpHeader)var1_1, (String)var2_2);
        }
        return this;
    }

    @Override
    public List<HttpCookie> getCookies() {
        if (this.cookies != null) {
            return this.cookies;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request cookie(HttpCookie cookie) {
        void var1_1;
        if (this.cookies == null) {
            this.cookies = new ArrayList<HttpCookie>();
        }
        this.cookies.add((HttpCookie)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request tag(Object tag) {
        void var1_1;
        this.tag = var1_1;
        return this;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request attribute(String name, Object value) {
        void var2_2;
        void var1_1;
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(4);
        }
        this.attributes.put((String)var1_1, var2_2);
        return this;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes != null) {
            return this.attributes;
        }
        return Collections.emptyMap();
    }

    @Override
    public HttpFields getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Request.RequestListener> List<T> getRequestListeners(Class<T> type) {
        void var2_2;
        if (type == null || this.requestListeners == null) {
            if (this.requestListeners != null) {
                return this.requestListeners;
            }
            return Collections.emptyList();
        }
        ArrayList<Request.RequestListener> result = new ArrayList<Request.RequestListener>();
        for (Request.RequestListener listener : this.requestListeners) {
            if (!type.isInstance(listener)) continue;
            result.add(listener);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request listener(Request.Listener listener) {
        void var1_1;
        return this.requestListener((Request.RequestListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onRequestQueued(Request.QueuedListener listener) {
        void var1_1;
        return this.requestListener(new Request.QueuedListener(this, (Request.QueuedListener)var1_1){
            final /* synthetic */ Request.QueuedListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = queuedListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onQueued(Request request) {
                void var1_1;
                this.val$listener.onQueued((Request)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onRequestBegin(Request.BeginListener listener) {
        void var1_1;
        return this.requestListener(new Request.BeginListener(this, (Request.BeginListener)var1_1){
            final /* synthetic */ Request.BeginListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = beginListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onBegin(Request request) {
                void var1_1;
                this.val$listener.onBegin((Request)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onRequestHeaders(Request.HeadersListener listener) {
        void var1_1;
        return this.requestListener(new Request.HeadersListener(this, (Request.HeadersListener)var1_1){
            final /* synthetic */ Request.HeadersListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = headersListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onHeaders(Request request) {
                void var1_1;
                this.val$listener.onHeaders((Request)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onRequestCommit(Request.CommitListener listener) {
        void var1_1;
        return this.requestListener(new Request.CommitListener(this, (Request.CommitListener)var1_1){
            final /* synthetic */ Request.CommitListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = commitListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onCommit(Request request) {
                void var1_1;
                this.val$listener.onCommit((Request)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onRequestContent(Request.ContentListener listener) {
        void var1_1;
        return this.requestListener(new Request.ContentListener(this, (Request.ContentListener)var1_1){
            final /* synthetic */ Request.ContentListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = contentListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onContent(Request request, ByteBuffer content) {
                void var2_2;
                void var1_1;
                this.val$listener.onContent((Request)var1_1, (ByteBuffer)var2_2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onRequestSuccess(Request.SuccessListener listener) {
        void var1_1;
        return this.requestListener(new Request.SuccessListener(this, (Request.SuccessListener)var1_1){
            final /* synthetic */ Request.SuccessListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = successListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onSuccess(Request request) {
                void var1_1;
                this.val$listener.onSuccess((Request)var1_1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onRequestFailure(Request.FailureListener listener) {
        void var1_1;
        return this.requestListener(new Request.FailureListener(this, (Request.FailureListener)var1_1){
            final /* synthetic */ Request.FailureListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = failureListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onFailure(Request request, Throwable failure) {
                void var2_2;
                void var1_1;
                this.val$listener.onFailure((Request)var1_1, (Throwable)var2_2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private Request requestListener(Request.RequestListener listener) {
        void var1_1;
        if (this.requestListeners == null) {
            this.requestListeners = new ArrayList<Request.RequestListener>();
        }
        this.requestListeners.add((Request.RequestListener)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseBegin(Response.BeginListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.BeginListener(this, (Response.BeginListener)var1_1){
            final /* synthetic */ Response.BeginListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = beginListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onBegin(Response response) {
                void var1_1;
                this.val$listener.onBegin((Response)var1_1);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseHeader(Response.HeaderListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.HeaderListener(this, (Response.HeaderListener)var1_1){
            final /* synthetic */ Response.HeaderListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = headerListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean onHeader(Response response, HttpField field) {
                void var2_2;
                void var1_1;
                return this.val$listener.onHeader((Response)var1_1, (HttpField)var2_2);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseHeaders(Response.HeadersListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.HeadersListener(this, (Response.HeadersListener)var1_1){
            final /* synthetic */ Response.HeadersListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = headersListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onHeaders(Response response) {
                void var1_1;
                this.val$listener.onHeaders((Response)var1_1);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseContent(Response.ContentListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.ContentListener(this, (Response.ContentListener)var1_1){
            final /* synthetic */ Response.ContentListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = contentListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onContent(Response response, ByteBuffer content) {
                void var2_2;
                void var1_1;
                this.val$listener.onContent((Response)var1_1, (ByteBuffer)var2_2);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseContentAsync(Response.AsyncContentListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.AsyncContentListener(this, (Response.AsyncContentListener)var1_1){
            final /* synthetic */ Response.AsyncContentListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = asyncContentListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onContent(Response response, ByteBuffer content, Callback callback) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.val$listener.onContent((Response)var1_1, (ByteBuffer)var2_2, (Callback)var3_3);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseContentDemanded(Response.DemandedContentListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.DemandedContentListener(this, (Response.DemandedContentListener)var1_1){
            final /* synthetic */ Response.DemandedContentListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = demandedContentListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onBeforeContent(Response response, LongConsumer demand) {
                void var2_2;
                void var1_1;
                this.val$listener.onBeforeContent((Response)var1_1, (LongConsumer)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onContent(Response response, LongConsumer demand, ByteBuffer content, Callback callback) {
                void var3_3;
                void var2_2;
                void var1_1;
                this.val$listener.onContent((Response)var1_1, (LongConsumer)var2_2, (ByteBuffer)var3_3, callback);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseSuccess(Response.SuccessListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.SuccessListener(this, (Response.SuccessListener)var1_1){
            final /* synthetic */ Response.SuccessListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = successListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onSuccess(Response response) {
                void var1_1;
                this.val$listener.onSuccess((Response)var1_1);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onResponseFailure(Response.FailureListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.FailureListener(this, (Response.FailureListener)var1_1){
            final /* synthetic */ Response.FailureListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = failureListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onFailure(Response response, Throwable failure) {
                void var2_2;
                void var1_1;
                this.val$listener.onFailure((Response)var1_1, (Throwable)var2_2);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request onComplete(Response.CompleteListener listener) {
        void var1_1;
        this.responseListeners.add(new Response.CompleteListener(this, (Response.CompleteListener)var1_1){
            final /* synthetic */ Response.CompleteListener val$listener;
            final /* synthetic */ HttpRequest this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$listener = completeListener;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onComplete(Result result) {
                void var1_1;
                this.val$listener.onComplete((Result)var1_1);
            }
        });
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Request pushListener(BiFunction<Request, Request, Response.CompleteListener> listener) {
        void var1_1;
        this.pushListener = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpRequest trailers(Supplier<HttpFields> trailers) {
        void var1_1;
        this.trailers = var1_1;
        return this;
    }

    @Override
    public ContentProvider getContent() {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request content(ContentProvider content) {
        void var1_1;
        return this.content((ContentProvider)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request content(ContentProvider content, String contentType) {
        void var1_1;
        if (contentType != null) {
            void var2_2;
            this.header(HttpHeader.CONTENT_TYPE, (String)var2_2);
        }
        this.content = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request file(Path file) throws IOException {
        void var1_1;
        return this.file((Path)var1_1, "application/octet-stream");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request file(Path file, String contentType) throws IOException {
        void var1_1;
        void var2_2;
        return this.content(new PathContentProvider((String)var2_2, (Path)var1_1));
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request followRedirects(boolean follow) {
        void var1_1;
        this.followRedirects = var1_1;
        return this;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request idleTimeout(long timeout, TimeUnit unit) {
        void var1_1;
        void var3_2;
        this.idleTimeout = var3_2.toMillis((long)var1_1);
        return this;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Request timeout(long timeout, TimeUnit unit) {
        void var1_1;
        void var3_2;
        this.timeout = var3_2.toMillis((long)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        FutureResponseListener listener = new FutureResponseListener(this);
        this.send(listener);
        try {
            return listener.get();
        }
        catch (ExecutionException executionException) {
            TimeoutException t;
            ExecutionException x = executionException;
            if (executionException.getCause() instanceof TimeoutException) {
                t = (TimeoutException)x.getCause();
                this.abort(t);
                throw t;
            }
            this.abort(t);
            throw t;
        }
        catch (Throwable x) {
            void var1_2;
            this.abort(x);
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(Response.CompleteListener listener) {
        void var1_1;
        HttpRequest httpRequest = this;
        httpRequest.sendAsync(httpRequest.client::send, (Response.CompleteListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void sendAsync(HttpDestination destination, Response.CompleteListener listener) {
        void var2_2;
        void var1_1;
        this.sendAsync(((HttpDestination)var1_1)::send, (Response.CompleteListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void sendAsync(BiConsumer<HttpRequest, List<Response.ResponseListener>> sender, Response.CompleteListener listener) {
        void var1_1;
        if (listener != null) {
            void var2_2;
            this.responseListeners.add((Response.ResponseListener)var2_2);
        }
        this.sent();
        HttpRequest httpRequest = this;
        var1_1.accept(httpRequest, httpRequest.responseListeners);
    }

    /*
     * WARNING - void declaration
     */
    void sent() {
        long timeout = this.getTimeout();
        if (timeout > 0L) {
            void var1_1;
            this.timeoutAt = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos((long)var1_1);
        }
    }

    long getTimeoutAt() {
        return this.timeoutAt;
    }

    protected List<Response.ResponseListener> getResponseListeners() {
        return this.responseListeners;
    }

    public BiFunction<Request, Request, Response.CompleteListener> getPushListener() {
        return this.pushListener;
    }

    public Supplier<HttpFields> getTrailers() {
        return this.trailers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean abort(Throwable cause) {
        if (this.aborted.compareAndSet(null, Objects.requireNonNull(cause))) {
            void var1_1;
            if (this.content instanceof Callback) {
                ((Callback)this.content).failed(cause);
            }
            return this.conversation.abort((Throwable)var1_1);
        }
        return false;
    }

    @Override
    public Throwable getAbortCause() {
        return this.aborted.get();
    }

    /*
     * WARNING - void declaration
     */
    boolean normalized() {
        void var1_1;
        boolean result = this.normalized;
        this.normalized = true;
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String buildQuery() {
        void var1_1;
        StringBuilder result = new StringBuilder();
        Iterator iterator = this.params.iterator();
        while (iterator.hasNext()) {
            Fields.Field field = (Fields.Field)iterator.next();
            List values = field.getValues();
            for (int i = 0; i < values.size(); ++i) {
                if (i > 0) {
                    result.append("&");
                }
                result.append(field.getName()).append("=");
                result.append(this.urlEncode((String)values.get(i)));
            }
            if (!iterator.hasNext()) continue;
            result.append("&");
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        String encoding = "utf-8";
        try {
            void var1_1;
            return URLEncoder.encode((String)var1_1, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var2_2;
            throw new UnsupportedCharsetException((String)var2_2);
        }
    }

    private void extractParams(String query) {
        if (query != null) {
            String[] stringArray;
            for (String string : stringArray.split("&")) {
                String name;
                String[] parts = string.split("=");
                if (parts.length <= 0 || (name = this.urlDecode(parts[0])).trim().length() == 0) continue;
                this.param(name, parts.length < 2 ? "" : this.urlDecode(parts[1]), true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private String urlDecode(String value) {
        String charset = "utf-8";
        try {
            void var1_1;
            return URLDecoder.decode((String)var1_1, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var2_2;
            throw new UnsupportedCharsetException((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private URI buildURI(boolean withQuery) {
        void var1_2;
        URI result;
        String path = this.getPath();
        String query = this.getQuery();
        if (query != null && withQuery) {
            void var3_4;
            path = path + "?" + (String)var3_4;
        }
        if ((result = this.newURI(path)) == null) {
            return NULL_URI;
        }
        if (!result.isAbsolute()) {
            void var2_3;
            result = URI.create(new Origin(this.getScheme(), this.getHost(), this.getPort()).asString() + (String)var2_3);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private URI newURI(String path) {
        try {
            void var1_1;
            if ("*".equals(path)) {
                return null;
            }
            URI result = new URI(path);
            if (result.isOpaque()) {
                return null;
            }
            return var1_1;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String toString() {
        return String.format("%s[%s %s %s]@%x", this.getClass().getSimpleName(), this.getMethod(), this.getPath(), this.getVersion(), this.hashCode());
    }
}

