/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpRedirector {
    private static final Logger LOG = Log.getLogger(HttpRedirector.class);
    private static final String SCHEME_REGEXP = "(^https?)";
    private static final String AUTHORITY_REGEXP = "([^/?#]+)";
    private static final String DESTINATION_REGEXP = "((^https?)://([^/?#]+))?";
    private static final String PATH_REGEXP = "([^?#]*)";
    private static final String QUERY_REGEXP = "([^#]*)";
    private static final String FRAGMENT_REGEXP = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("((^https?)://([^/?#]+))?([^?#]*)([^#]*)(.*)");
    private static final String ATTRIBUTE = HttpRedirector.class.getName() + ".redirects";
    private final HttpClient client;
    private final ResponseNotifier notifier;

    /*
     * WARNING - void declaration
     */
    public HttpRedirector(HttpClient client) {
        void var1_1;
        this.client = var1_1;
        this.notifier = new ResponseNotifier();
    }

    public boolean isRedirect(Response response) {
        switch (response.getStatus()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Result redirect(Request request, Response response) throws InterruptedException, ExecutionException {
        AtomicReference resultRef = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        Request redirect = this.redirect(request, response, new BufferingResponseListener(this, resultRef, latch){
            final /* synthetic */ AtomicReference val$resultRef;
            final /* synthetic */ CountDownLatch val$latch;
            final /* synthetic */ HttpRedirector this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$resultRef = atomicReference;
                this.val$latch = countDownLatch;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onComplete(Result result) {
                void var1_1;
                this.val$resultRef.set(new Result(result.getRequest(), result.getRequestFailure(), new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding()), var1_1.getResponseFailure()));
                this.val$latch.countDown();
            }
        });
        try {
            void var3_4;
            latch.await();
            Result result = (Result)var3_4.get();
            if (result.isFailed()) {
                throw new ExecutionException(result.getFailure());
            }
            return result;
        }
        catch (InterruptedException x) {
            void var2_3;
            void var1_1;
            var1_1.abort(x);
            throw var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Request redirect(Request request, Response response, Response.CompleteListener listener) {
        void var2_2;
        void var1_1;
        if (this.isRedirect(response)) {
            String location = response.getHeaders().get("Location");
            URI newURI = this.extractRedirectURI(response);
            if (newURI != null) {
                void var3_3;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Redirecting to {} (Location: {})", new Object[]{newURI, location});
                }
                return this.redirect(request, response, (Response.CompleteListener)var3_3, newURI);
            }
            this.fail(request, response, new HttpResponseException("Invalid 'Location' header: " + location, response));
            return null;
        }
        this.fail((Request)var1_1, response, new HttpResponseException("Cannot redirect: " + response, (Response)var2_2));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public URI extractRedirectURI(Response response) {
        String location = response.getHeaders().get("location");
        if (location != null) {
            void var1_1;
            return this.sanitize((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private URI sanitize(String location) {
        try {
            return new URI(location);
        }
        catch (URISyntaxException uRISyntaxException) {
            Matcher matcher = URI_PATTERN.matcher(location);
            if (matcher.matches()) {
                String fragment;
                String scheme = matcher.group(2);
                String authority = matcher.group(3);
                String path = matcher.group(4);
                String query = matcher.group(5);
                if (query.length() == 0) {
                    query = null;
                }
                if ((fragment = matcher.group(6)).length() == 0) {
                    fragment = null;
                }
                try {
                    void var1_1;
                    void var3_3;
                    void var2_2;
                    return new URI((String)var2_2, (String)var3_3, path, query, (String)var1_1);
                }
                catch (URISyntaxException uRISyntaxException2) {}
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Request redirect(Request request, Response response, Response.CompleteListener listener, URI newURI) {
        void var2_2;
        void var5_6;
        void var1_1;
        if (!newURI.isAbsolute()) {
            Object uri;
            URI requestURI = request.getURI();
            if (requestURI == null) {
                uri = request.getScheme() + "://" + request.getHost();
                int port = request.getPort();
                if (port > 0) {
                    uri = (String)uri + ":" + port;
                }
                uri = URI.create((String)uri);
            }
            newURI = ((URI)uri).resolve(newURI);
        }
        int status = response.getStatus();
        switch (status) {
            case 301: {
                String method = request.getMethod();
                if (HttpMethod.GET.is(method) || HttpMethod.HEAD.is(method) || HttpMethod.PUT.is(method)) {
                    return this.redirect(request, response, listener, newURI, method);
                }
                if (HttpMethod.POST.is(method)) {
                    return this.redirect(request, response, listener, newURI, HttpMethod.GET.asString());
                }
                this.fail(request, response, new HttpResponseException("HTTP protocol violation: received 301 for non GET/HEAD/POST/PUT request", response));
                return null;
            }
            case 302: {
                String method = request.getMethod();
                if (HttpMethod.HEAD.is(method) || HttpMethod.PUT.is(method)) {
                    return this.redirect(request, response, listener, newURI, method);
                }
                return this.redirect(request, response, listener, newURI, HttpMethod.GET.asString());
            }
            case 303: {
                String method = request.getMethod();
                if (HttpMethod.HEAD.is(method)) {
                    return this.redirect(request, response, listener, newURI, method);
                }
                return this.redirect(request, response, listener, newURI, HttpMethod.GET.asString());
            }
            case 307: 
            case 308: {
                void var3_3;
                return this.redirect(request, response, (Response.CompleteListener)var3_3, newURI, request.getMethod());
            }
        }
        this.fail((Request)var1_1, response, new HttpResponseException("Unhandled HTTP status code " + (int)var5_6, (Response)var2_2));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Request redirect(Request request, Response response, Response.CompleteListener listener, URI location, String method) {
        void var2_2;
        void var1_1;
        int maxRedirects;
        HttpRequest httpRequest = (HttpRequest)request;
        HttpConversation conversation = httpRequest.getConversation();
        Integer redirects = (Integer)conversation.getAttribute(ATTRIBUTE);
        if (redirects == null) {
            redirects = 0;
        }
        if ((maxRedirects = this.client.getMaxRedirects()) < 0 || redirects < maxRedirects) {
            void var3_3;
            redirects = redirects + 1;
            conversation.setAttribute(ATTRIBUTE, redirects);
            return this.sendRedirect(httpRequest, response, (Response.CompleteListener)var3_3, location, method);
        }
        this.fail((Request)var1_1, response, new HttpResponseException("Max redirects exceeded " + redirects, (Response)var2_2));
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Request sendRedirect(HttpRequest httpRequest, Response response, Response.CompleteListener listener, URI location, String method) {
        try {
            void var3_3;
            Request redirect = this.client.copyRequest(httpRequest, location);
            long timeoutAt = httpRequest.getTimeoutAt();
            if (timeoutAt < Long.MAX_VALUE) {
                long newTimeout = timeoutAt - System.nanoTime();
                if (newTimeout > 0L) {
                    redirect.timeout(newTimeout, TimeUnit.NANOSECONDS);
                } else {
                    TimeoutException failure = new TimeoutException("Total timeout " + httpRequest.getConversation().getTimeout() + " ms elapsed");
                    this.fail((Request)httpRequest, (Throwable)var3_3, response);
                    return null;
                }
            }
            redirect.method(method);
            redirect.onRequestBegin(request -> {
                Throwable cause = httpRequest.getAbortCause();
                if (cause != null) {
                    Throwable throwable;
                    void var1_1;
                    var1_1.abort(throwable);
                }
            });
            redirect.send((Response.CompleteListener)var3_3);
            return redirect;
        }
        catch (Throwable x) {
            void var2_2;
            void var1_1;
            this.fail((Request)var1_1, x, (Response)var2_2);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void fail(Request request, Response response, Throwable failure) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.fail((Request)var1_1, null, (Response)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void fail(Request request, Throwable failure, Response response) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.fail((Request)var1_1, failure, (Response)var3_3, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void fail(Request request, Throwable requestFailure, Response response, Throwable responseFailure) {
        void var3_3;
        void var2_2;
        void var1_1;
        HttpConversation conversation = ((HttpRequest)request).getConversation();
        conversation.updateResponseListeners(null);
        List<Response.ResponseListener> listeners = conversation.getResponseListeners();
        this.notifier.notifyFailure(listeners, response, responseFailure);
        this.notifier.notifyComplete(listeners, new Result((Request)var1_1, (Throwable)var2_2, (Response)var3_3, responseFailure));
    }
}

