/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.function.LongUnaryOperator;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpReceiver {
    protected static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final AtomicReference<ResponseState> responseState = new AtomicReference<ResponseState>(ResponseState.IDLE);
    private final HttpChannel channel;
    private ContentListeners contentListeners;
    private Decoder decoder;
    private Throwable failure;
    private long demand;
    private boolean stalled;

    /*
     * WARNING - void declaration
     */
    protected HttpReceiver(HttpChannel channel) {
        void var1_1;
        this.channel = var1_1;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    /*
     * WARNING - void declaration
     */
    void demand(long n) {
        void var3_3;
        if (n <= 0L) {
            throw new IllegalArgumentException("Invalid demand " + n);
        }
        boolean resume = false;
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.demand = MathUtils.cappedAdd((long)this.demand, (long)n);
            if (this.stalled) {
                this.stalled = false;
                resume = true;
            }
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("Response demand={}/{}, resume={}", new Object[]{(long)var1_1, this.demand, resume});
            }
        }
        if (var3_3 != false) {
            if (this.decoder != null) {
                this.decoder.resume();
                return;
            }
            this.receive();
        }
    }

    protected long demand() {
        return this.demand(LongUnaryOperator.identity());
    }

    /*
     * WARNING - void declaration
     */
    private long demand(LongUnaryOperator operator) {
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            void var1_1;
            this.demand = var1_1.applyAsLong(this.demand);
            return this.demand;
        }
    }

    protected boolean hasDemandOrStall() {
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.stalled = this.demand <= 0L;
            return !this.stalled;
        }
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    public boolean isFailed() {
        return this.responseState.get() == ResponseState.FAILURE;
    }

    protected void receive() {
    }

    /*
     * WARNING - void declaration
     */
    protected boolean responseBegin(HttpExchange exchange) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (!this.updateResponseState(ResponseState.IDLE, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpConversation conversation = exchange.getConversation();
        HttpResponse response = exchange.getResponse();
        HttpDestination destination = this.getHttpDestination();
        HttpClient httpClient = destination.getHttpClient();
        ProtocolHandler protocolHandler = httpClient.findProtocolHandler(exchange.getRequest(), response);
        Response.Listener handlerListener = null;
        if (protocolHandler != null) {
            handlerListener = protocolHandler.getResponseListener();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response {} found protocol handler {}", new Object[]{response, protocolHandler});
            }
        }
        exchange.getConversation().updateResponseListeners(handlerListener);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response begin {}", new Object[]{response});
        }
        ResponseNotifier responseNotifier = destination.getResponseNotifier();
        responseNotifier.notifyBegin(var2_2.getResponseListeners(), (Response)var3_3);
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.BEGIN)) {
            return true;
        }
        this.dispose();
        this.terminateResponse((HttpExchange)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean responseHeader(HttpExchange exchange, HttpField field) {
        void var1_1;
        if (!this.updateResponseState(ResponseState.BEGIN, ResponseState.HEADER, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpResponse response = exchange.getResponse();
        ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
        boolean bl = responseNotifier.notifyHeader(exchange.getConversation().getResponseListeners(), (Response)response, field);
        if (bl) {
            response.getHeaders().add(field);
            HttpHeader fieldHeader = field.getHeader();
            if (fieldHeader != null) {
                switch (fieldHeader) {
                    case SET_COOKIE: 
                    case SET_COOKIE2: {
                        void var2_2;
                        void var3_3;
                        URI uri = exchange.getRequest().getURI();
                        if (uri == null) break;
                        this.storeCookie((URI)var3_3, (HttpField)var2_2);
                    }
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADER)) {
            return true;
        }
        this.dispose();
        this.terminateResponse((HttpExchange)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void storeCookie(URI uri, HttpField field) {
        try {
            String value = field.getValue();
            if (value != null) {
                void var1_1;
                void var2_2;
                HashMap<String, List<String>> header = new HashMap<String, List<String>>(1);
                header.put(var2_2.getHeader().asString(), Collections.singletonList(value));
                this.getHttpDestination().getHttpClient().getCookieManager().put((URI)var1_1, header);
            }
            return;
        }
        catch (IOException x) {
            if (LOG.isDebugEnabled()) {
                void var3_4;
                LOG.debug((Throwable)var3_4);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean responseHeaders(HttpExchange exchange) {
        void var1_1;
        List contentEncodings;
        if (!this.updateResponseState(ResponseState.BEGIN, ResponseState.HEADER, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response headers {}{}{}", new Object[]{response, System.lineSeparator(), response.getHeaders().toString().trim()});
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        List<Response.ResponseListener> responseListeners = exchange.getConversation().getResponseListeners();
        notifier.notifyHeaders(responseListeners, (Response)response);
        this.contentListeners = new ContentListeners(responseListeners);
        ContentListeners.access$200(this.contentListeners, response);
        if (!this.contentListeners.isEmpty() && (contentEncodings = response.getHeaders().getCSV(HttpHeader.CONTENT_ENCODING.asString(), false)) != null && !contentEncodings.isEmpty()) {
            block0: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                for (String encoding : contentEncodings) {
                    if (!factory.getEncoding().equalsIgnoreCase(encoding)) continue;
                    this.decoder = new Decoder(exchange, factory.newContentDecoder());
                    continue block0;
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADERS)) {
            void var3_4;
            boolean hasDemand = this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                void var2_2;
                LOG.debug("Response headers hasDemand={} {}", new Object[]{hasDemand, var2_2});
            }
            return (boolean)var3_4;
        }
        this.dispose();
        this.terminateResponse((HttpExchange)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean responseContent(HttpExchange exchange, ByteBuffer buffer, Callback callback) {
        void var3_3;
        void var2_2;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content {}{}{}", new Object[]{exchange.getResponse(), System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)buffer)});
        }
        if (this.demand() <= 0L) {
            callback.failed((Throwable)new IllegalStateException("No demand for response content"));
            return false;
        }
        if (this.decoder == null) {
            void var1_1;
            return this.plainResponseContent((HttpExchange)var1_1, buffer, callback);
        }
        return this.decodeResponseContent((ByteBuffer)var2_2, (Callback)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private boolean plainResponseContent(HttpExchange exchange, ByteBuffer buffer, Callback callback) {
        void var1_1;
        if (!this.updateResponseState(ResponseState.HEADERS, ResponseState.CONTENT, ResponseState.TRANSIENT)) {
            callback.failed((Throwable)new IllegalStateException("Invalid response state " + this.responseState));
            return false;
        }
        HttpResponse response = exchange.getResponse();
        if (this.contentListeners.isEmpty()) {
            callback.succeeded();
        } else {
            void var3_4;
            void var2_3;
            ContentListeners.access$500(this.contentListeners, response, (ByteBuffer)var2_3, (Callback)var3_4);
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.CONTENT)) {
            void var1_2;
            boolean hasDemand = this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content {}, hasDemand={}", new Object[]{response, hasDemand});
            }
            return (boolean)var1_2;
        }
        this.dispose();
        this.terminateResponse((HttpExchange)var1_1);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean decodeResponseContent(ByteBuffer buffer, Callback callback) {
        void var2_2;
        void var1_1;
        return Decoder.access$600(this.decoder, (ByteBuffer)var1_1, (Callback)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean responseSuccess(HttpExchange exchange) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (!exchange.responseComplete(null)) {
            return false;
        }
        this.responseState.set(ResponseState.IDLE);
        this.reset();
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response success {}", new Object[]{response});
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
        responseNotifier.notifySuccess((List<Response.ResponseListener>)var3_3, (Response)var2_2);
        if (exchange.getResponse().getStatus() == 100) {
            return true;
        }
        this.terminateResponse((HttpExchange)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean responseFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response failure " + exchange.getResponse(), failure);
        }
        if (exchange.responseComplete(failure)) {
            void var1_1;
            void var2_2;
            return this.abort((HttpExchange)var2_2, (Throwable)var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void terminateResponse(HttpExchange exchange) {
        void var2_2;
        void var1_1;
        Result result = exchange.terminateResponse();
        this.terminateResponse((HttpExchange)var1_1, (Result)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void terminateResponse(HttpExchange exchange, Result result) {
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}", new Object[]{response});
        }
        if (result != null) {
            void var3_4;
            result = this.channel.exchangeTerminating(exchange, result);
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}, notifying {}", new Object[]{this.failure == null ? "succeeded" : "failed", result, listeners});
            }
            ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
            responseNotifier.notifyComplete(listeners, result);
            if (var3_4 != false) {
                void var2_2;
                void var1_1;
                this.channel.exchangeTerminated((HttpExchange)var1_1, (Result)var2_2);
            }
        }
    }

    protected void reset() {
        this.cleanup();
    }

    protected void dispose() {
        assert (this.responseState.get() != ResponseState.TRANSIENT);
        this.cleanup();
    }

    private void cleanup() {
        this.contentListeners = null;
        if (this.decoder != null) {
            this.decoder.destroy();
        }
        this.decoder = null;
        this.demand = 0L;
        this.stalled = false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean abort(HttpExchange exchange, Throwable failure) {
        void var3_4;
        void var2_2;
        ResponseState current;
        do {
            if ((current = this.responseState.get()) != ResponseState.FAILURE) continue;
            return false;
        } while (!this.updateResponseState(current, ResponseState.FAILURE));
        boolean terminate = current != ResponseState.TRANSIENT;
        this.failure = failure;
        if (terminate) {
            this.dispose();
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response abort {} {} on {}: {}", new Object[]{response, exchange, this.getHttpChannel(), failure});
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier responseNotifier = this.getHttpDestination().getResponseNotifier();
        responseNotifier.notifyFailure(listeners, (Response)response, (Throwable)var2_2);
        if (var3_4 != false) {
            void var1_1;
            this.terminateResponse((HttpExchange)var1_1);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: response termination skipped, performed by helpers", new Object[0]);
        }
        return false;
    }

    private boolean updateResponseState(ResponseState from1, ResponseState from2, ResponseState to) {
        ResponseState current;
        while ((current = this.responseState.get()) == from1 || current == from2) {
            if (!this.updateResponseState(current, to)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("State update failed: [{},{}] -> {}: {}", new Object[]{from1, from2, to, current});
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean updateResponseState(ResponseState from, ResponseState to) {
        ResponseState current;
        while ((current = this.responseState.get()) == from) {
            if (!this.responseState.compareAndSet(current, to)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            void var3_3;
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, var3_3});
        }
        return false;
    }

    public String toString() {
        return String.format("%s@%x(rsp=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.responseState, this.failure);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ long access$700(HttpReceiver x0, LongUnaryOperator x1) {
        void var1_1;
        return x0.demand((LongUnaryOperator)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$800(HttpReceiver x0, ResponseState x1, ResponseState x2, ResponseState x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.updateResponseState((ResponseState)var1_1, (ResponseState)var2_2, (ResponseState)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1000(HttpReceiver x0, ResponseState x1, ResponseState x2) {
        void var2_2;
        void var1_1;
        return x0.updateResponseState((ResponseState)var1_1, (ResponseState)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(HttpReceiver x0, HttpExchange x1) {
        void var1_1;
        x0.terminateResponse((HttpExchange)var1_1);
    }

    private static enum DecodeResult {
        DECODE,
        NEED_INPUT,
        ABORT;

    }

    private class Decoder
    implements Destroyable {
        private final HttpExchange exchange;
        private final ContentDecoder decoder;
        private ByteBuffer encoded;
        private Callback callback;

        /*
         * WARNING - void declaration
         */
        private Decoder(HttpExchange exchange, ContentDecoder decoder) {
            void var3_3;
            void var2_2;
            this.exchange = var2_2;
            this.decoder = (ContentDecoder)Objects.requireNonNull(var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private boolean decode(ByteBuffer encoded, Callback callback) {
            void var1_2;
            this.encoded = encoded;
            this.callback = callback;
            HttpResponse response = this.exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content decoding {} with {}{}{}", new Object[]{response, this.decoder, System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)encoded)});
            }
            if (!(encoded = this.decode())) {
                return false;
            }
            boolean hasDemand = HttpReceiver.this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                void var2_3;
                LOG.debug("Response content decoded, hasDemand={} {}", new Object[]{hasDemand, var2_3});
            }
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        private boolean decode() {
            block4: {
                void var1_1;
                do {
                    if (!HttpReceiver.access$800(HttpReceiver.this, ResponseState.HEADERS, ResponseState.CONTENT, ResponseState.TRANSIENT)) {
                        this.callback.failed((Throwable)new IllegalStateException("Invalid response state " + HttpReceiver.this.responseState));
                        return false;
                    }
                    DecodeResult result = this.decodeChunk();
                    if (!HttpReceiver.access$1000(HttpReceiver.this, ResponseState.TRANSIENT, ResponseState.CONTENT)) break block4;
                    if (result == DecodeResult.NEED_INPUT) {
                        return true;
                    }
                    if (result == DecodeResult.ABORT) {
                        return false;
                    }
                    boolean hasDemand = HttpReceiver.this.hasDemandOrStall();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Response content decoded chunk, hasDemand={} {}", new Object[]{hasDemand, this.exchange.getResponse()});
                } while (var1_1 != false);
                return false;
            }
            HttpReceiver.this.dispose();
            HttpReceiver.access$1100(HttpReceiver.this, this.exchange);
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private DecodeResult decodeChunk() {
            try {
                void var2_3;
                void decoded;
                ByteBuffer buffer;
                while (!(buffer = this.decoder.decode(this.encoded)).hasRemaining()) {
                    if (this.encoded.hasRemaining()) continue;
                    this.callback.succeeded();
                    this.encoded = null;
                    this.callback = null;
                    return DecodeResult.NEED_INPUT;
                }
                HttpResponse response = this.exchange.getResponse();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response content decoded chunk {}{}{}", new Object[]{response, System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)decoded)});
                }
                ContentListeners.access$500(HttpReceiver.this.contentListeners, (HttpResponse)var2_3, (ByteBuffer)decoded, Callback.from(() -> this.lambda$decodeChunk$0((ByteBuffer)decoded), arg_0 -> ((Callback)this.callback).failed(arg_0)));
                return DecodeResult.DECODE;
            }
            catch (Throwable x) {
                void var1_2;
                this.callback.failed((Throwable)var1_2);
                return DecodeResult.ABORT;
            }
        }

        private void resume() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content resume decoding {} with {}", new Object[]{this.exchange.getResponse(), this.decoder});
            }
            if (this.callback == null) {
                HttpReceiver.this.receive();
                return;
            }
            boolean bl = this.decode();
            if (bl) {
                HttpReceiver.this.receive();
            }
        }

        public void destroy() {
            if (this.decoder instanceof Destroyable) {
                ((Destroyable)this.decoder).destroy();
            }
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$decodeChunk$0(ByteBuffer decoded) {
            void var1_1;
            this.decoder.release((ByteBuffer)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$600(Decoder x0, ByteBuffer x1, Callback x2) {
            void var2_2;
            void var1_1;
            return x0.decode((ByteBuffer)var1_1, (Callback)var2_2);
        }
    }

    private class ContentListeners {
        private final Map<Object, Long> demands = new ConcurrentHashMap<Object, Long>();
        private final LongConsumer demand = HttpReceiver.this::demand;
        private final List<Response.DemandedContentListener> listeners;

        /*
         * WARNING - void declaration
         */
        private ContentListeners(List<Response.ResponseListener> responseListeners) {
            void var2_2;
            this.listeners = new ArrayList<Response.DemandedContentListener>(responseListeners.size());
            var2_2.stream().filter(Response.DemandedContentListener.class::isInstance).map(Response.DemandedContentListener.class::cast).forEach(this.listeners::add);
        }

        private boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        private void notifyBeforeContent(HttpResponse response) {
            void var1_1;
            if (this.isEmpty()) {
                this.demand.accept(1L);
                return;
            }
            ResponseNotifier responseNotifier = HttpReceiver.this.getHttpDestination().getResponseNotifier();
            responseNotifier.notifyBeforeContent((Response)var1_1, this::demand, this.listeners);
        }

        /*
         * WARNING - void declaration
         */
        private void notifyContent(HttpResponse response, ByteBuffer buffer, Callback callback) {
            void var3_3;
            void var2_2;
            void var1_1;
            HttpReceiver.access$700(HttpReceiver.this, d -> d - 1L);
            ResponseNotifier responseNotifier = HttpReceiver.this.getHttpDestination().getResponseNotifier();
            responseNotifier.notifyContent((Response)var1_1, this::demand, (ByteBuffer)var2_2, (Callback)var3_3, this.listeners);
        }

        /*
         * WARNING - void declaration
         */
        private void demand(Object context, long value) {
            void var2_2;
            if (this.listeners.size() > 1) {
                void var1_1;
                this.accept(var1_1, value);
                return;
            }
            this.demand.accept((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void accept(Object context, long value) {
            this.demands.merge(context, value, MathUtils::cappedAdd);
            if (this.demands.size() == this.listeners.size()) {
                long minDemand = Long.MAX_VALUE;
                for (Long demand : this.demands.values()) {
                    if (demand >= minDemand) continue;
                    minDemand = demand;
                }
                if (minDemand > 0L) {
                    Iterator<Map.Entry<Object, Long>> iterator = this.demands.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void var2_4;
                        Map.Entry<Object, Long> entry = iterator.next();
                        long newValue = entry.getValue() - minDemand;
                        if (newValue == 0L) {
                            iterator.remove();
                            continue;
                        }
                        var2_4.setValue(newValue);
                    }
                    this.demand.accept(minDemand);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$200(ContentListeners x0, HttpResponse x1) {
            void var1_1;
            x0.notifyBeforeContent((HttpResponse)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$500(ContentListeners x0, HttpResponse x1, ByteBuffer x2, Callback x3) {
            void var3_3;
            void var2_2;
            void var1_1;
            x0.notifyContent((HttpResponse)var1_1, (ByteBuffer)var2_2, (Callback)var3_3);
        }
    }

    private static enum ResponseState {
        TRANSIENT,
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }
}

