/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpProxy
extends ProxyConfiguration.Proxy {
    private static final Logger LOG = Log.getLogger(HttpProxy.class);

    /*
     * WARNING - void declaration
     */
    public HttpProxy(String host, int port) {
        this(new Origin.Address((String)var1_1, (int)var2_2), false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpProxy(Origin.Address address, boolean secure) {
        super((Origin.Address)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpProxy(Origin.Address address, SslContextFactory.Client sslContextFactory) {
        super((Origin.Address)var1_1, (SslContextFactory.Client)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClientConnectionFactory newClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        void var1_1;
        return new HttpProxyClientConnectionFactory((ClientConnectionFactory)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URI getURI() {
        void var1_1;
        String scheme = this.isSecure() ? HttpScheme.HTTPS.asString() : HttpScheme.HTTP.asString();
        return URI.create(new Origin((String)var1_1, this.getAddress()).asString());
    }

    private static class TunnelPromise
    implements Promise<Connection> {
        private final Request request;
        private final Response.CompleteListener listener;
        private final Promise<Connection> promise;

        /*
         * WARNING - void declaration
         */
        private TunnelPromise(Request request, Response.CompleteListener listener, Promise<Connection> promise) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.request = var1_1;
            this.listener = var2_2;
            this.promise = var3_3;
        }

        public void succeeded(Connection connection) {
            connection.send(this.request, this.listener);
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            this.promise.failed((Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void setEndPoint(EndPoint endPoint) {
            void var1_1;
            HttpConversation httpConversation = ((HttpRequest)this.request).getConversation();
            httpConversation.setAttribute(EndPoint.class.getName(), var1_1);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$100(TunnelPromise x0, EndPoint x1) {
            void var1_1;
            x0.setEndPoint((EndPoint)var1_1);
        }
    }

    private static class ProxyConnection
    implements Connection,
    Attachable {
        private final Destination destination;
        private final Connection connection;
        private final Promise<Connection> promise;
        private Object attachment;

        /*
         * WARNING - void declaration
         */
        private ProxyConnection(Destination destination, Connection connection, Promise<Connection> promise) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.destination = var1_1;
            this.connection = var2_2;
            this.promise = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void send(Request request, Response.CompleteListener listener) {
            void var2_2;
            void var1_1;
            if (this.connection.isClosed()) {
                this.destination.newConnection(new TunnelPromise(request, listener, this.promise));
                return;
            }
            this.connection.send((Request)var1_1, (Response.CompleteListener)var2_2);
        }

        @Override
        public void close() {
            this.connection.close();
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        /*
         * WARNING - void declaration
         */
        public void setAttachment(Object obj) {
            void var1_1;
            this.attachment = var1_1;
        }

        public Object getAttachment() {
            return this.attachment;
        }
    }

    private static class CreateTunnelPromise
    implements Promise<Connection> {
        private final ClientConnectionFactory connectionFactory;
        private final EndPoint endPoint;
        private final Promise<Connection> promise;
        private final Map<String, Object> context;

        /*
         * WARNING - void declaration
         */
        private CreateTunnelPromise(ClientConnectionFactory connectionFactory, EndPoint endPoint, Promise<Connection> promise, Map<String, Object> context) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.connectionFactory = var1_1;
            this.endPoint = var2_2;
            this.promise = var3_3;
            this.context = context;
        }

        /*
         * WARNING - void declaration
         */
        public void succeeded(Connection connection) {
            void var1_1;
            void var2_2;
            HttpDestination destination = (HttpDestination)this.context.get("http.destination");
            this.tunnel((HttpDestination)var2_2, (Connection)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            CreateTunnelPromise createTunnelPromise = this;
            createTunnelPromise.tunnelFailed(createTunnelPromise.endPoint, (Throwable)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void tunnel(HttpDestination destination, Connection connection) {
            void var3_3;
            void var2_2;
            void var1_1;
            String target = destination.getOrigin().getAddress().asString();
            Origin.Address proxyAddress = destination.getConnectAddress();
            HttpClient httpClient = destination.getHttpClient();
            long connectTimeout = httpClient.getConnectTimeout();
            Request connect = httpClient.newRequest(proxyAddress.getHost(), proxyAddress.getPort()).method(HttpMethod.CONNECT).path(target).header(HttpHeader.HOST, target).idleTimeout(2L * connectTimeout, TimeUnit.MILLISECONDS).timeout(connectTimeout, TimeUnit.MILLISECONDS);
            ProxyConfiguration.Proxy proxy = destination.getProxy();
            if (proxy != null && proxy.isSecure()) {
                connect.scheme(HttpScheme.HTTPS.asString());
            }
            HttpConversation conversation = ((HttpRequest)connect).getConversation();
            conversation.setAttribute(EndPoint.class.getName(), this.endPoint);
            connect.attribute(Connection.class.getName(), new ProxyConnection((Destination)var1_1, connection, this.promise));
            var2_2.send((Request)var3_3, result -> {
                void var3_3;
                void var2_2;
                EndPoint endPoint = (EndPoint)conversation.getAttribute(EndPoint.class.getName());
                if (!result.isSucceeded()) {
                    void var1_1;
                    this.tunnelFailed((EndPoint)var1_1, var2_2.getFailure());
                    return;
                }
                Response response = result.getResponse();
                if (response.getStatus() == 200) {
                    this.tunnelSucceeded(endPoint);
                    return;
                }
                HttpResponseException failure = new HttpResponseException("Unexpected " + response + " for " + result.getRequest(), (Response)var3_3);
                this.tunnelFailed(endPoint, (Throwable)var2_2);
            });
        }

        /*
         * WARNING - void declaration
         */
        private void tunnelSucceeded(EndPoint endPoint) {
            try {
                void var3_4;
                this.context.put("http.connection.promise", this.promise);
                HttpDestination destination = (HttpDestination)this.context.get("http.destination");
                ClientConnectionFactory sslConnectionFactory = destination.newSslClientConnectionFactory(null, this.connectionFactory);
                HttpConnectionOverHTTP oldConnection = (HttpConnectionOverHTTP)endPoint.getConnection();
                this.context.put("ssl.peer.host", destination.getHost());
                this.context.put("ssl.peer.port", destination.getPort());
                org.eclipse.jetty.io.Connection newConnection = var3_4.newConnection(endPoint, this.context);
                endPoint.setConnection((org.eclipse.jetty.io.Connection)oldConnection);
                endPoint.upgrade(newConnection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP tunnel established: {} over {}", new Object[]{oldConnection, newConnection});
                }
                return;
            }
            catch (Throwable x) {
                void var2_3;
                void var1_1;
                this.tunnelFailed((EndPoint)var1_1, (Throwable)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void tunnelFailed(EndPoint endPoint, Throwable failure) {
            void var2_2;
            endPoint.close();
            this.promise.failed((Throwable)var2_2);
        }
    }

    private static class HttpProxyClientConnectionFactory
    implements ClientConnectionFactory {
        private final ClientConnectionFactory connectionFactory;

        /*
         * WARNING - void declaration
         */
        private HttpProxyClientConnectionFactory(ClientConnectionFactory connectionFactory) {
            void var1_1;
            this.connectionFactory = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public org.eclipse.jetty.io.Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
            void var2_2;
            void var1_1;
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            SslContextFactory sslContextFactory = destination.getHttpClient().getSslContextFactory();
            if (destination.isSecure()) {
                if (sslContextFactory != null) {
                    void var3_3;
                    Promise promise;
                    Promise wrapped = promise = (Promise)context.get("http.connection.promise");
                    if (promise instanceof Promise.Wrapper) {
                        wrapped = ((Promise.Wrapper)promise).unwrap();
                    }
                    if (wrapped instanceof TunnelPromise) {
                        TunnelPromise.access$100((TunnelPromise)wrapped, endPoint);
                        return this.connectionFactory.newConnection(endPoint, context);
                    }
                    CreateTunnelPromise tunnelPromise = new CreateTunnelPromise(this.connectionFactory, endPoint, promise, context);
                    context.put("http.connection.promise", var3_3);
                    return this.connectionFactory.newConnection(endPoint, context);
                }
                throw new IOException("Cannot tunnel request, missing " + SslContextFactory.class.getName() + " in " + HttpClient.class.getName());
            }
            return this.connectionFactory.newConnection((EndPoint)var1_1, (Map)var2_2);
        }
    }
}

