/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpExchange
implements CyclicTimeouts.Expirable {
    private static final Logger LOG = Log.getLogger(HttpExchange.class);
    private final HttpDestination destination;
    private final HttpRequest request;
    private final List<Response.ResponseListener> listeners;
    private final HttpResponse response;
    private State requestState = State.PENDING;
    private State responseState = State.PENDING;
    private HttpChannel _channel;
    private Throwable requestFailure;
    private Throwable responseFailure;

    /*
     * WARNING - void declaration
     */
    public HttpExchange(HttpDestination destination, HttpRequest request, List<Response.ResponseListener> listeners) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.destination = destination;
        this.request = request;
        this.listeners = listeners;
        this.response = new HttpResponse(request, (List<Response.ResponseListener>)var3_3);
        HttpConversation conversation = var2_2.getConversation();
        conversation.getExchanges().offer(this);
        var1_1.updateResponseListeners(null);
    }

    public HttpConversation getConversation() {
        return this.request.getConversation();
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public Throwable getRequestFailure() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.requestFailure;
        }
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public Throwable getResponseFailure() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this.responseFailure;
        }
    }

    public long getExpireNanoTime() {
        return this.request.getTimeoutAt();
    }

    /*
     * WARNING - void declaration
     */
    boolean associate(HttpChannel channel) {
        void var2_3;
        void var3_4;
        boolean result = false;
        boolean abort = false;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.requestState == State.PENDING && this.responseState == State.PENDING && !(abort = this._channel != null)) {
                void var1_1;
                this._channel = var1_1;
                result = true;
            }
        }
        if (var3_4 != false) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    void disassociate(HttpChannel channel) {
        void var2_3;
        boolean abort = false;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            void var1_1;
            if (this._channel != var1_1 || this.requestState != State.TERMINATED || this.responseState != State.TERMINATED) {
                abort = true;
            }
            this._channel = null;
        }
        if (var2_3 != false) {
            this.request.abort(new IllegalStateException(this.toString()));
        }
    }

    private HttpChannel getHttpChannel() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return this._channel;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean requestComplete(Throwable failure) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            void var1_1;
            return this.completeRequest((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean completeRequest(Throwable failure) {
        if (this.requestState == State.PENDING) {
            void var1_1;
            this.requestState = State.COMPLETED;
            this.requestFailure = var1_1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean responseComplete(Throwable failure) {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            void var1_1;
            return this.completeResponse((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean completeResponse(Throwable failure) {
        if (this.responseState == State.PENDING) {
            void var1_1;
            this.responseState = State.COMPLETED;
            this.responseFailure = var1_1;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Result terminateRequest() {
        void var1_1;
        Result result = null;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.requestState == State.COMPLETED) {
                this.requestState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated request for {}, result: {}", new Object[]{this, result});
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Result terminateResponse() {
        void var1_1;
        Result result = null;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            if (this.responseState == State.COMPLETED) {
                this.responseState = State.TERMINATED;
            }
            if (this.requestState == State.TERMINATED && this.responseState == State.TERMINATED) {
                result = new Result(this.getRequest(), this.requestFailure, this.getResponse(), this.responseFailure);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Terminated response for {}, result: {}", new Object[]{this, result});
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean abort(Throwable failure) {
        void var2_3;
        void var3_5;
        boolean abortResponse;
        boolean abortRequest;
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            abortRequest = this.completeRequest(failure);
            abortResponse = this.completeResponse(failure);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failed {}: req={}/rsp={} {}", new Object[]{this, abortRequest, abortResponse, failure});
        }
        if (!abortRequest && !abortResponse) {
            return false;
        }
        if (this.destination.remove(this)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborting while queued {}: {}", new Object[]{this, failure});
            }
            this.notifyFailureComplete(failure);
            return true;
        }
        HttpChannel channel = this.getHttpChannel();
        if (channel == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before association {}: {}", new Object[]{this, failure});
            }
            this.notifyFailureComplete(failure);
            return true;
        }
        boolean aborted = channel.abort(this, abortRequest ? failure : null, var3_5 != false ? failure : null);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("Aborted ({}) while active {}: {}", new Object[]{aborted, this, var1_1});
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private void notifyFailureComplete(Throwable failure) {
        void var1_1;
        void var2_2;
        void var3_3;
        this.destination.getRequestNotifier().notifyFailure(this.request, failure);
        List<Response.ResponseListener> listeners = this.getConversation().getResponseListeners();
        ResponseNotifier responseNotifier = this.destination.getResponseNotifier();
        responseNotifier.notifyFailure(listeners, (Response)this.response, failure);
        var3_3.notifyComplete((List<Response.ResponseListener>)var2_2, new Result(this.request, failure, this.response, (Throwable)var1_1));
    }

    public void resetResponse() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            this.responseState = State.PENDING;
            this.responseFailure = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void proceed(Throwable failure) {
        HttpChannel channel = this.getHttpChannel();
        if (channel != null) {
            void var1_1;
            void var2_2;
            var2_2.proceed(this, (Throwable)var1_1);
        }
    }

    public String toString() {
        HttpExchange httpExchange = this;
        synchronized (httpExchange) {
            return String.format("%s@%x{req=%s[%s/%s] res=%s[%s/%s]}", new Object[]{HttpExchange.class.getSimpleName(), this.hashCode(), this.request, this.requestState, this.requestFailure, this.response, this.responseState, this.responseFailure});
        }
    }

    private static enum State {
        PENDING,
        COMPLETED,
        TERMINATED;

    }
}

