/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.RequestNotifier;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class HttpDestination
extends ContainerLifeCycle
implements Closeable,
Destination,
Callback,
Dumpable,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final Origin origin;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final ProxyConfiguration.Proxy proxy;
    private final ClientConnectionFactory connectionFactory;
    private final HttpField hostField;
    private final RequestTimeouts requestTimeouts;
    private final Locker staleLock = new Locker();
    private ConnectionPool connectionPool;
    private boolean stale;
    private long activeNanos;

    /*
     * WARNING - void declaration
     */
    public HttpDestination(HttpClient client, Origin origin) {
        void var2_2;
        void var1_1;
        void var3_3;
        Object tag;
        this.client = client;
        this.origin = origin;
        this.exchanges = this.newExchangeQueue(client);
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier();
        this.requestTimeouts = new RequestTimeouts(client.getScheduler());
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        this.proxy = proxyConfig.match(origin);
        HttpClientTransport connectionFactory = client.getTransport();
        if (this.proxy != null) {
            connectionFactory = this.proxy.newClientConnectionFactory(connectionFactory);
            if (this.proxy.isSecure()) {
                HttpDestination httpDestination = this;
                connectionFactory = httpDestination.newSslClientConnectionFactory((SslContextFactory)httpDestination.proxy.getSslContextFactory(), connectionFactory);
            }
        } else if (this.isSecure()) {
            connectionFactory = this.newSslClientConnectionFactory(null, connectionFactory);
        }
        if ((tag = origin.getTag()) instanceof ClientConnectionFactory.Decorator) {
            connectionFactory = ((ClientConnectionFactory.Decorator)tag).apply((ClientConnectionFactory)connectionFactory);
        }
        this.connectionFactory = var3_3;
        String host = HostPort.normalizeHost((String)this.getHost());
        if (!var1_1.isDefaultPort(this.getScheme(), this.getPort())) {
            host = host + ":" + this.getPort();
        }
        this.hostField = new HttpField(HttpHeader.HOST, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean stale() {
        void var3_4;
        block7: {
            Locker.Lock l = this.staleLock.lock();
            try {
                void var2_2;
                boolean stale = this.stale;
                if (!stale) {
                    this.activeNanos = System.nanoTime();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stale check done with result {} on {}", new Object[]{stale, this});
                }
                var3_4 = var2_2;
                if (l == null) break block7;
            }
            catch (Throwable throwable) {
                if (l != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            l.close();
        }
        return (boolean)var3_4;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sweep() {
        void var1_1;
        boolean remove2;
        block9: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sweep check in progress on {}", new Object[]{this});
            }
            remove2 = false;
            Locker.Lock l = this.staleLock.lock();
            try {
                boolean bl = this.exchanges.isEmpty() && this.connectionPool.isEmpty();
                if (!bl) {
                    this.activeNanos = System.nanoTime();
                } else if (this.isStaleDelayExpired()) {
                    this.stale = true;
                    remove2 = true;
                }
                if (l == null) break block9;
            }
            catch (Throwable throwable) {
                if (l == null) throw throwable;
                try {
                    void var2_3;
                    var2_3.close();
                    throw throwable;
                }
                catch (Throwable remove2) {
                    throwable.addSuppressed(remove2);
                }
                throw throwable;
            }
            l.close();
        }
        if (remove2) {
            this.getHttpClient().removeDestination(this);
            LifeCycle.stop((Object)this);
        }
        if (!LOG.isDebugEnabled()) return (boolean)var1_1;
        LOG.debug("Sweep check done with result {} on {}", new Object[]{remove2, this});
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isStaleDelayExpired() {
        void var1_1;
        assert (this.staleLock.isLocked());
        long destinationIdleTimeout = TimeUnit.MILLISECONDS.toNanos(this.getHttpClient().getDestinationIdleTimeout());
        return System.nanoTime() - this.activeNanos >= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        Sweeper destinationSweeper;
        this.connectionPool = this.newConnectionPool(this.client);
        HttpDestination httpDestination = this;
        httpDestination.addBean(httpDestination.connectionPool, true);
        super.doStart();
        Sweeper connectionPoolSweeper = (Sweeper)this.client.getBean(Sweeper.class);
        if (connectionPoolSweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            connectionPoolSweeper.offer((Sweeper.Sweepable)this.connectionPool);
        }
        if ((destinationSweeper = this.getHttpClient().getDestinationSweeper()) != null) {
            void var1_1;
            var1_1.offer((Sweeper.Sweepable)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doStop() throws Exception {
        Sweeper connectionPoolSweeper;
        Sweeper destinationSweeper = this.getHttpClient().getDestinationSweeper();
        if (destinationSweeper != null) {
            destinationSweeper.remove((Sweeper.Sweepable)this);
        }
        if ((connectionPoolSweeper = (Sweeper)this.client.getBean(Sweeper.class)) != null && this.connectionPool instanceof Sweeper.Sweepable) {
            void var1_1;
            var1_1.remove((Sweeper.Sweepable)this.connectionPool);
        }
        super.doStop();
        HttpDestination httpDestination = this;
        httpDestination.removeBean(httpDestination.connectionPool);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return client.getTransport().getConnectionPoolFactory().newConnectionPool(this);
    }

    /*
     * WARNING - void declaration
     */
    protected Queue<HttpExchange> newExchangeQueue(HttpClient client) {
        void var1_1;
        return new BlockingArrayQueue(var1_1.getMaxRequestsQueuedPerDestination());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        void var1_1;
        return this.client.newSslClientConnectionFactory(null, (ClientConnectionFactory)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory connectionFactory) {
        void var2_2;
        void var1_1;
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(connectionFactory);
        }
        return this.client.newSslClientConnectionFactory((SslContextFactory)var1_1, (ClientConnectionFactory)var2_2);
    }

    public boolean isSecure() {
        return HttpClient.isSchemeSecure(this.getScheme());
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    public ProxyConfiguration.Proxy getProxy() {
        return this.proxy;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    @ManagedAttribute(value="The destination scheme", readonly=true)
    public String getScheme() {
        return this.origin.getScheme();
    }

    @Override
    @ManagedAttribute(value="The destination host", readonly=true)
    public String getHost() {
        return this.origin.getAddress().getHost();
    }

    @Override
    @ManagedAttribute(value="The destination port", readonly=true)
    public int getPort() {
        return this.origin.getAddress().getPort();
    }

    @ManagedAttribute(value="The number of queued requests", readonly=true)
    public int getQueuedRequestCount() {
        return this.exchanges.size();
    }

    public Origin.Address getConnectAddress() {
        if (this.proxy == null) {
            return this.origin.getAddress();
        }
        return this.proxy.getAddress();
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    @ManagedAttribute(value="The connection pool", readonly=true)
    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public void succeeded() {
        this.send(false);
    }

    /*
     * WARNING - void declaration
     */
    public void failed(Throwable x) {
        void var1_1;
        this.abort((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void send(Request request, Response.CompleteListener listener) {
        void var2_2;
        ((HttpRequest)request).sendAsync(this, (Response.CompleteListener)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        void var2_2;
        void var1_1;
        this.send(new HttpExchange(this, (HttpRequest)var1_1, (List<Response.ResponseListener>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void send(HttpExchange exchange) {
        void var2_2;
        HttpRequest request = exchange.getRequest();
        if (this.client.isRunning()) {
            HttpDestination httpDestination = this;
            if (httpDestination.enqueue(httpDestination.exchanges, exchange)) {
                void var1_1;
                this.requestTimeouts.schedule(exchange);
                if (!this.client.isRunning() && this.exchanges.remove(var1_1)) {
                    request.abort(new RejectedExecutionException((Object)((Object)this.client) + " is stopping"));
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Queued {} for {}", new Object[]{request, this});
                }
                this.requestNotifier.notifyQueued(request);
                this.send();
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Max queue size {} exceeded by {} for {}", new Object[]{this.client.getMaxRequestsQueuedPerDestination(), request, this});
            }
            request.abort(new RejectedExecutionException("Max requests queued per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            return;
        }
        var2_2.abort(new RejectedExecutionException((Object)((Object)this.client) + " is stopped"));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean enqueue(Queue<HttpExchange> queue, HttpExchange exchange) {
        void var2_2;
        return queue.offer((HttpExchange)var2_2);
    }

    public void send() {
        this.send(true);
    }

    /*
     * WARNING - void declaration
     */
    private void send(boolean create) {
        if (!this.getHttpExchanges().isEmpty()) {
            void var1_1;
            this.process((boolean)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void process(boolean create) {
        void var1_2;
        boolean bl;
        Connection connection;
        while ((connection = this.connectionPool instanceof AbstractConnectionPool ? ((AbstractConnectionPool)this.connectionPool).acquire(create) : this.connectionPool.acquire()) != null && (bl = this.process((Connection)var1_2))) {
            bl = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean process(Connection connection) {
        void var2_2;
        void var1_1;
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", new Object[]{exchange, connection, this});
        }
        if (exchange == null) {
            if (!this.connectionPool.release(connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", new Object[]{client});
                }
                connection.close();
            }
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            boolean bl;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", new Object[]{exchange, cause});
            }
            if (!(bl = this.connectionPool.release(connection))) {
                connection.close();
            }
            exchange.abort(cause);
            return this.getQueuedRequestCount() > 0;
        }
        SendFailure failure = this.send((Connection)var1_1, exchange);
        if (failure == null) {
            return this.getQueuedRequestCount() > 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send failed {} for {}", new Object[]{failure, exchange});
        }
        if (failure.retry) {
            void var3_3;
            this.send((HttpExchange)var3_3);
            return false;
        }
        var2_2.abort(failure.failure);
        return this.getQueuedRequestCount() > 0;
    }

    protected abstract SendFailure send(Connection var1, HttpExchange var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public void newConnection(Promise<Connection> promise) {
        void var1_1;
        this.createConnection((Promise<Connection>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void createConnection(Promise<Connection> promise) {
        void var1_1;
        this.client.newConnection(this, (Promise<Connection>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(HttpExchange exchange) {
        void var1_1;
        return this.exchanges.remove(var1_1);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed {}", new Object[]{this});
        }
        this.connectionPool.close();
        this.requestTimeouts.destroy();
    }

    /*
     * WARNING - void declaration
     */
    public void release(Connection connection) {
        HttpClient client;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", new Object[]{connection});
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send(false);
                    return;
                }
                connection.close();
                this.send(true);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", new Object[]{connection});
                return;
            }
        } else {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                void var2_2;
                LOG.debug("{} is stopped", new Object[]{var2_2});
            }
            var1_1.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(Connection connection) {
        void var1_2;
        boolean removed = this.connectionPool.remove(connection);
        if (removed) {
            this.send(true);
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void close(Connection connection) {
        void var1_1;
        this.remove((Connection)var1_1);
    }

    public void abort(Throwable cause) {
        for (HttpExchange httpExchange : new ArrayList<HttpExchange>(this.exchanges)) {
            httpExchange.getRequest().abort(cause);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{new DumpableCollection("exchanges", this.exchanges)});
    }

    public String asString() {
        return this.origin.asString();
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="For how long this destination has been idle in ms")
    public long getIdle() {
        long l;
        block6: {
            if (this.getHttpClient().getDestinationIdleTimeout() <= 0L) {
                return -1L;
            }
            Locker.Lock l2 = this.staleLock.lock();
            try {
                l = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.activeNanos);
                if (l2 == null) break block6;
            }
            catch (Throwable throwable) {
                if (l2 != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            l2.close();
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @ManagedAttribute(value="Whether this destinations is stale")
    public boolean isStale() {
        boolean bl;
        block5: {
            Locker.Lock l = this.staleLock.lock();
            try {
                bl = this.stale;
                if (l == null) break block5;
            }
            catch (Throwable throwable) {
                if (l != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            l.close();
        }
        return bl;
    }

    public String toString() {
        return String.format("%s[%s]@%x%s,state=%s,queue=%d,pool=%s,stale=%b,idle=%d", HttpDestination.class.getSimpleName(), this.asString(), this.hashCode(), this.proxy == null ? "" : "(via " + this.proxy + ")", this.getState(), this.getQueuedRequestCount(), this.getConnectionPool(), this.isStale(), this.getIdle());
    }

    private class RequestTimeouts
    extends CyclicTimeouts<HttpExchange> {
        /*
         * WARNING - void declaration
         */
        private RequestTimeouts(Scheduler scheduler) {
            void var2_2;
            super((Scheduler)var2_2);
        }

        protected Iterator<HttpExchange> iterator() {
            return HttpDestination.this.exchanges.iterator();
        }

        /*
         * WARNING - void declaration
         */
        protected boolean onExpired(HttpExchange exchange) {
            void var1_1;
            HttpRequest request = exchange.getRequest();
            request.abort(new TimeoutException("Total timeout " + var1_1.getConversation().getTimeout() + " ms elapsed"));
            return false;
        }
    }
}

