/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.util.AttributesMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConversation
extends AttributesMap {
    private static final Logger LOG = Log.getLogger(HttpConversation.class);
    private final Deque<HttpExchange> exchanges = new ConcurrentLinkedDeque<HttpExchange>();
    private volatile List<Response.ResponseListener> listeners;

    public Deque<HttpExchange> getExchanges() {
        return this.exchanges;
    }

    public List<Response.ResponseListener> getResponseListeners() {
        return this.listeners;
    }

    /*
     * WARNING - void declaration
     */
    public void updateResponseListeners(Response.ResponseListener overrideListener) {
        HttpExchange firstExchange = this.exchanges.peekFirst();
        HttpExchange lastExchange = this.exchanges.peekLast();
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(firstExchange.getResponseListeners().size() + lastExchange.getResponseListeners().size());
        if (firstExchange == lastExchange) {
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                listeners.addAll(firstExchange.getResponseListeners());
            }
        } else {
            void var3_3;
            listeners.addAll(var3_3.getResponseListeners());
            if (overrideListener != null) {
                listeners.add(overrideListener);
            } else {
                void var2_2;
                listeners.addAll(var2_2.getResponseListeners());
            }
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("Exchanges in conversation {}, override={}, listeners={}", new Object[]{this.exchanges.size(), var1_1, listeners});
        }
        this.listeners = listeners;
    }

    /*
     * WARNING - void declaration
     */
    public long getTimeout() {
        void var1_1;
        HttpExchange firstExchange = this.exchanges.peekFirst();
        if (firstExchange == null) {
            return 0L;
        }
        return var1_1.getRequest().getTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public boolean abort(Throwable cause) {
        void var1_1;
        void var2_2;
        HttpExchange exchange = this.exchanges.peekLast();
        return exchange != null && var2_2.abort((Throwable)var1_1);
    }

    public String toString() {
        return String.format("%s[%x]", HttpConversation.class.getSimpleName(), ((Object)((Object)this)).hashCode());
    }
}

