/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;

public class HttpContentResponse
implements ContentResponse {
    private final Response response;
    private final byte[] content;
    private final String mediaType;
    private final String encoding;

    /*
     * WARNING - void declaration
     */
    public HttpContentResponse(Response response, byte[] content, String mediaType, String encoding) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.response = var1_1;
        this.content = var2_2;
        this.mediaType = var3_3;
        this.encoding = encoding;
    }

    @Override
    public Request getRequest() {
        return this.response.getRequest();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Response.ResponseListener> List<T> getListeners(Class<T> listenerClass) {
        void var1_1;
        return this.response.getListeners(var1_1);
    }

    @Override
    public HttpVersion getVersion() {
        return this.response.getVersion();
    }

    @Override
    public int getStatus() {
        return this.response.getStatus();
    }

    @Override
    public String getReason() {
        return this.response.getReason();
    }

    @Override
    public HttpFields getHeaders() {
        return this.response.getHeaders();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean abort(Throwable cause) {
        void var1_1;
        return this.response.abort((Throwable)var1_1);
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public byte[] getContent() {
        return this.content;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getContentAsString() {
        String encoding = this.encoding;
        if (encoding == null) {
            return new String(this.getContent(), StandardCharsets.UTF_8);
        }
        try {
            return new String(this.getContent(), encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void var1_1;
            throw new UnsupportedCharsetException((String)var1_1);
        }
    }

    public String toString() {
        return String.format("%s[%s %d %s - %d bytes]", HttpContentResponse.class.getSimpleName(), this.getVersion(), this.getStatus(), this.getReason(), this.getContent().length);
    }
}

