/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jetty.client.Synchronizable;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpContent
implements Closeable,
Callback {
    private static final Logger LOG = Log.getLogger(HttpContent.class);
    private static final ByteBuffer AFTER = ByteBuffer.allocate(0);
    private static final ByteBuffer CLOSE = ByteBuffer.allocate(0);
    private final ContentProvider provider;
    private final Iterator<ByteBuffer> iterator;
    private ByteBuffer buffer;
    private ByteBuffer content;
    private boolean last;

    /*
     * WARNING - void declaration
     */
    public HttpContent(ContentProvider provider) {
        void var1_1;
        this.provider = provider;
        this.iterator = provider == null ? Collections.emptyIterator() : var1_1.iterator();
    }

    private static boolean isTheCloseBuffer(ByteBuffer buffer) {
        boolean bl = buffer == CLOSE;
        return bl;
    }

    public boolean hasContent() {
        return this.provider != null;
    }

    public boolean isLast() {
        return this.last;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public boolean advance() {
        if (this.iterator instanceof Synchronizable) {
            Object object = ((Synchronizable)((Object)this.iterator)).getLock();
            synchronized (object) {
                HttpContent httpContent = this;
                return httpContent.advance(httpContent.iterator);
            }
        }
        HttpContent httpContent = this;
        return httpContent.advance(httpContent.iterator);
    }

    /*
     * WARNING - void declaration
     */
    private boolean advance(Iterator<ByteBuffer> iterator) {
        void var2_3;
        boolean hasNext = iterator.hasNext();
        ByteBuffer bytes = hasNext ? iterator.next() : null;
        boolean hasMore = hasNext && iterator.hasNext();
        boolean wasLast = this.last;
        boolean bl = this.last = !hasMore;
        if (var2_3 != false) {
            void var3_4;
            this.buffer = bytes;
            ByteBuffer byteBuffer = this.content = bytes == null ? null : bytes.slice();
            if (LOG.isDebugEnabled()) {
                void var1_2;
                LOG.debug("Advanced content to {} chunk {}", new Object[]{var1_2 != false ? "next" : "last", String.valueOf(bytes)});
            }
            return var3_4 != null;
        }
        if (wasLast) {
            HttpContent httpContent = this;
            httpContent.buffer = httpContent.content = AFTER;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content past last chunk", new Object[0]);
            }
        } else {
            HttpContent httpContent = this;
            httpContent.buffer = httpContent.content = CLOSE;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Advanced content to last chunk", new Object[0]);
            }
        }
        return false;
    }

    public boolean isConsumed() {
        return this.buffer == AFTER;
    }

    public void succeeded() {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            ((Callback)this.iterator).succeeded();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void failed(Throwable x) {
        if (this.isConsumed()) {
            return;
        }
        if (HttpContent.isTheCloseBuffer(this.buffer)) {
            return;
        }
        if (this.iterator instanceof Callback) {
            void var1_1;
            ((Callback)this.iterator).failed((Throwable)var1_1);
        }
    }

    @Override
    public void close() {
        if (this.iterator instanceof Closeable) {
            IO.close((Closeable)((Closeable)((Object)this.iterator)));
        }
    }

    public String toString() {
        return String.format("%s@%x - has=%b,last=%b,consumed=%b,buffer=%s", this.getClass().getSimpleName(), this.hashCode(), this.hasContent(), this.isLast(), this.isConsumed(), BufferUtil.toDetailString((ByteBuffer)this.getContent()));
    }
}

