/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class HttpConnection
implements Connection,
Attachable {
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private final HttpDestination destination;
    private final RequestTimeouts requestTimeouts;
    private Object attachment;
    private int idleTimeoutGuard;
    private long idleTimeoutStamp;

    /*
     * WARNING - void declaration
     */
    protected HttpConnection(HttpDestination destination) {
        void var1_1;
        this.destination = destination;
        this.requestTimeouts = new RequestTimeouts(var1_1.getHttpClient().getScheduler());
        this.idleTimeoutStamp = System.nanoTime();
    }

    public HttpClient getHttpClient() {
        return this.destination.getHttpClient();
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    protected abstract Iterator<HttpChannel> getHttpChannels();

    /*
     * WARNING - void declaration
     */
    @Override
    public void send(Request request, Response.CompleteListener listener) {
        void var3_3;
        HttpExchange exchange;
        SendFailure result;
        HttpRequest httpRequest = (HttpRequest)request;
        ArrayList<Response.ResponseListener> listeners = new ArrayList<Response.ResponseListener>(httpRequest.getResponseListeners());
        httpRequest.sent();
        if (listener != null) {
            listeners.add(listener);
        }
        if ((result = this.send(exchange = new HttpExchange(this.getHttpDestination(), httpRequest, (List<Response.ResponseListener>)var3_3))) != null) {
            void var2_2;
            void var1_1;
            var1_1.abort(var2_2.failure);
        }
    }

    protected abstract SendFailure send(HttpExchange var1);

    /*
     * WARNING - void declaration
     */
    protected void normalizeRequest(Request request) {
        void var1_1;
        URI uri;
        URI uri2;
        String path;
        boolean normalized = ((HttpRequest)request).normalized();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Normalizing {} {}", new Object[]{!normalized, request});
        }
        if (normalized) {
            return;
        }
        HttpVersion version = request.getVersion();
        HttpFields headers = request.getHeaders();
        ContentProvider content = request.getContent();
        ProxyConfiguration.Proxy proxy = this.destination.getProxy();
        String string = request.getPath();
        if (string.trim().length() == 0) {
            path = "/";
            request.path(path);
        }
        if (proxy instanceof HttpProxy && !HttpClient.isSchemeSecure(request.getScheme()) && (uri2 = request.getURI()) != null) {
            path = uri2.toString();
            request.path(path);
        }
        if (version.getVersion() <= 11 && !headers.containsKey(HttpHeader.HOST.asString())) {
            uri2 = request.getURI();
            if (uri2 != null) {
                headers.put(HttpHeader.HOST, uri2.getAuthority());
            } else {
                headers.put(this.getHttpDestination().getHostField());
            }
        }
        if (content != null) {
            long contentLength;
            if (!headers.containsKey(HttpHeader.CONTENT_TYPE.asString())) {
                String contentType = null;
                if (content instanceof ContentProvider.Typed) {
                    contentType = ((ContentProvider.Typed)content).getContentType();
                }
                if (contentType != null) {
                    headers.put(HttpHeader.CONTENT_TYPE, contentType);
                } else {
                    contentType = this.getHttpClient().getDefaultRequestContentType();
                    if (contentType != null) {
                        headers.put(HttpHeader.CONTENT_TYPE, contentType);
                    }
                }
            }
            if ((contentLength = content.getLength()) >= 0L && !headers.containsKey(HttpHeader.CONTENT_LENGTH.asString())) {
                void var3_4;
                var3_4.put(HttpHeader.CONTENT_LENGTH, String.valueOf(contentLength));
            }
        }
        StringBuilder cookies = this.convertCookies(request.getCookies(), null);
        CookieStore cookieStore = this.getHttpClient().getCookieStore();
        if (cookieStore != null && cookieStore.getClass() != HttpCookieStore.Empty.class && (uri = request.getURI()) != null) {
            void var2_3;
            cookies = this.convertCookies(HttpCookieStore.matchPath((URI)uri, cookieStore.get((URI)var2_3)), cookies);
        }
        if (cookies != null) {
            request.header(HttpHeader.COOKIE.asString(), cookies.toString());
        }
        this.applyProxyAuthentication(request, proxy);
        this.applyRequestAuthentication((Request)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder convertCookies(List<HttpCookie> cookies, StringBuilder builder) {
        void var2_2;
        for (HttpCookie cookie : cookies) {
            void var3_3;
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (builder.length() > 0) {
                builder.append("; ");
            }
            builder.append(cookie.getName()).append("=").append(var3_3.getValue());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void applyRequestAuthentication(Request request) {
        void var3_3;
        Authentication.Result result;
        URI uri;
        AuthenticationStore authenticationStore = this.getHttpClient().getAuthenticationStore();
        if (authenticationStore.hasAuthenticationResults() && (uri = request.getURI()) != null && (result = authenticationStore.findAuthenticationResult((URI)var3_3)) != null) {
            void var1_1;
            void var2_2;
            var2_2.apply((Request)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void applyProxyAuthentication(Request request, ProxyConfiguration.Proxy proxy) {
        Authentication.Result result;
        if (proxy != null && (result = this.getHttpClient().getAuthenticationStore().findAuthenticationResult(proxy.getURI())) != null) {
            void var1_1;
            void var2_2;
            var2_2.apply((Request)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected SendFailure send(HttpChannel channel, HttpExchange exchange) {
        void var3_6;
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            boolean send = this.idleTimeoutGuard >= 0;
            if (send) {
                ++this.idleTimeoutGuard;
            }
        }
        if (var3_6 != false) {
            void var1_1;
            SendFailure result;
            HttpConnection httpConnection2;
            HttpRequest request = exchange.getRequest();
            if (channel.associate((HttpExchange)((Object)httpConnection2))) {
                this.requestTimeouts.schedule(channel);
                channel.send();
                result = null;
            } else {
                ((HttpChannel)((Object)result)).release();
                result = new SendFailure(new HttpRequestException("Could not associate request to connection", request), false);
            }
            httpConnection2 = this;
            synchronized (httpConnection2) {
                --this.idleTimeoutGuard;
                this.idleTimeoutStamp = System.nanoTime();
            }
            return var1_1;
        }
        return new SendFailure(new TimeoutException(), true);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onIdleTimeout(long idleTimeout) {
        HttpConnection httpConnection = this;
        synchronized (httpConnection) {
            if (this.idleTimeoutGuard == 0) {
                long elapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.idleTimeoutStamp);
                boolean idle = elapsed > idleTimeout / 2L;
                if (idle) {
                    this.idleTimeoutGuard = -1;
                }
                if (LOG.isDebugEnabled()) {
                    void var1_1;
                    LOG.debug("Idle timeout {}/{}ms - {}", new Object[]{elapsed, (long)var1_1, this});
                }
                return idle;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Idle timeout skipped - {}", new Object[]{this});
            }
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttachment(Object obj) {
        void var1_1;
        this.attachment = var1_1;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    protected void destroy() {
        this.requestTimeouts.destroy();
    }

    public String toString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }

    private class RequestTimeouts
    extends CyclicTimeouts<HttpChannel> {
        /*
         * WARNING - void declaration
         */
        private RequestTimeouts(Scheduler scheduler) {
            void var2_2;
            super((Scheduler)var2_2);
        }

        protected Iterator<HttpChannel> iterator() {
            return HttpConnection.this.getHttpChannels();
        }

        /*
         * WARNING - void declaration
         */
        protected boolean onExpired(HttpChannel channel) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange != null) {
                void var1_1;
                HttpRequest request = exchange.getRequest();
                request.abort(new TimeoutException("Total timeout " + var1_1.getConversation().getTimeout() + " ms elapsed"));
            }
            return false;
        }
    }
}

