/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.ContinueProtocolHandler;
import org.eclipse.jetty.client.GZIPContentDecoder;
import org.eclipse.jetty.client.HttpAuthenticationStore;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.ProxyAuthenticationProtocolHandler;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.RedirectProtocolHandler;
import org.eclipse.jetty.client.WWWAuthenticationProtocolHandler;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.Sweeper;
import org.eclipse.jetty.util.thread.ThreadPool;

@ManagedObject(value="The HTTP client")
public class HttpClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(HttpClient.class);
    private final ConcurrentMap<Origin, HttpDestination> destinations = new ConcurrentHashMap<Origin, HttpDestination>();
    private final ProtocolHandlers handlers = new ProtocolHandlers();
    private final List<Request.Listener> requestListeners = new ArrayList<Request.Listener>();
    private final Set<ContentDecoder.Factory> decoderFactories = new ContentDecoderFactorySet();
    private final ProxyConfiguration proxyConfig = new ProxyConfiguration();
    private final HttpClientTransport transport;
    private final SslContextFactory sslContextFactory;
    private AuthenticationStore authenticationStore = new HttpAuthenticationStore();
    private CookieManager cookieManager;
    private CookieStore cookieStore;
    private Executor executor;
    private ByteBufferPool byteBufferPool;
    private Scheduler scheduler;
    private SocketAddressResolver resolver;
    private HttpField agentField = new HttpField(HttpHeader.USER_AGENT, "Jetty/" + Jetty.VERSION);
    private boolean followRedirects = true;
    private int maxConnectionsPerDestination = 64;
    private int maxRequestsQueuedPerDestination = 1024;
    private int requestBufferSize = 4096;
    private int responseBufferSize = 16384;
    private int maxRedirects = 8;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;
    private long addressResolutionTimeout = 15000L;
    private long idleTimeout;
    private boolean tcpNoDelay = true;
    private boolean strictEventOrdering = false;
    private HttpField encodingField;
    private long destinationIdleTimeout;
    private boolean connectBlocking = false;
    private String name = ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
    private HttpCompliance httpCompliance = HttpCompliance.RFC7230;
    private String defaultRequestContentType = "application/octet-stream";
    private Sweeper destinationSweeper;

    public HttpClient() {
        this(new HttpClientTransportOverHTTP(), null);
    }

    /*
     * WARNING - void declaration
     */
    public HttpClient(SslContextFactory sslContextFactory) {
        this(new HttpClientTransportOverHTTP(), (SslContextFactory)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpClient(HttpClientTransport transport) {
        this((HttpClientTransport)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public HttpClient(HttpClientTransport transport, SslContextFactory sslContextFactory) {
        void var2_2;
        void var1_1;
        this.transport = transport;
        this.addBean(var1_1);
        this.sslContextFactory = sslContextFactory;
        this.addBean(var2_2);
        HttpClient httpClient = this;
        httpClient.addBean(httpClient.handlers);
        HttpClient httpClient2 = this;
        httpClient2.addBean(httpClient2.decoderFactories);
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{new DumpableCollection("requestListeners", this.requestListeners)});
    }

    public HttpClientTransport getTransport() {
        return this.transport;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        if (this.executor == null) {
            void var1_1;
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName(this.name);
            this.setExecutor((Executor)var1_1);
        }
        if (this.byteBufferPool == null) {
            this.setByteBufferPool((ByteBufferPool)new MappedByteBufferPool(2048, this.executor instanceof ThreadPool.SizedThreadPool ? ((ThreadPool.SizedThreadPool)this.executor).getMaxThreads() / 2 : ProcessorUtils.availableProcessors() << 1));
        }
        if (this.scheduler == null) {
            this.setScheduler((Scheduler)new ScheduledExecutorScheduler(this.name + "-scheduler", false));
        }
        if (this.resolver == null) {
            this.setSocketAddressResolver((SocketAddressResolver)new SocketAddressResolver.Async(this.executor, this.scheduler, this.getAddressResolutionTimeout()));
        }
        this.handlers.put(new ContinueProtocolHandler());
        this.handlers.put(new RedirectProtocolHandler(this));
        this.handlers.put(new WWWAuthenticationProtocolHandler(this));
        this.handlers.put(new ProxyAuthenticationProtocolHandler(this));
        this.decoderFactories.add(new GZIPContentDecoder.Factory(this.byteBufferPool));
        this.cookieManager = this.newCookieManager();
        this.cookieStore = this.cookieManager.getCookieStore();
        this.transport.setHttpClient(this);
        super.doStart();
        if (this.getDestinationIdleTimeout() > 0L) {
            this.destinationSweeper = new Sweeper(this.scheduler, 1000L);
            this.destinationSweeper.start();
        }
    }

    private CookieManager newCookieManager() {
        return new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
    }

    protected void doStop() throws Exception {
        if (this.destinationSweeper != null) {
            this.destinationSweeper.stop();
            this.destinationSweeper = null;
        }
        this.decoderFactories.clear();
        this.handlers.clear();
        for (HttpDestination httpDestination : this.destinations.values()) {
            httpDestination.close();
        }
        this.destinations.clear();
        this.requestListeners.clear();
        this.authenticationStore.clearAuthentications();
        this.authenticationStore.clearAuthenticationResults();
        super.doStop();
    }

    public List<Request.Listener> getRequestListeners() {
        return this.requestListeners;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    /*
     * WARNING - void declaration
     */
    public void setCookieStore(CookieStore cookieStore) {
        void var1_1;
        this.cookieStore = (CookieStore)Objects.requireNonNull(var1_1);
        this.cookieManager = this.newCookieManager();
    }

    CookieManager getCookieManager() {
        return this.cookieManager;
    }

    Sweeper getDestinationSweeper() {
        return this.destinationSweeper;
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthenticationStore(AuthenticationStore authenticationStore) {
        void var1_1;
        this.authenticationStore = var1_1;
    }

    public Set<ContentDecoder.Factory> getContentDecoderFactories() {
        return this.decoderFactories;
    }

    /*
     * WARNING - void declaration
     */
    public ContentResponse GET(String uri) throws InterruptedException, ExecutionException, TimeoutException {
        void var1_1;
        return this.GET(URI.create((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public ContentResponse GET(URI uri) throws InterruptedException, ExecutionException, TimeoutException {
        void var1_1;
        return this.newRequest((URI)var1_1).send();
    }

    /*
     * WARNING - void declaration
     */
    public ContentResponse FORM(String uri, Fields fields) throws InterruptedException, ExecutionException, TimeoutException {
        void var2_2;
        void var1_1;
        return this.FORM(URI.create((String)var1_1), (Fields)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ContentResponse FORM(URI uri, Fields fields) throws InterruptedException, ExecutionException, TimeoutException {
        void var2_2;
        void var1_1;
        return this.POST((URI)var1_1).content(new FormContentProvider((Fields)var2_2)).send();
    }

    /*
     * WARNING - void declaration
     */
    public Request POST(String uri) {
        void var1_1;
        return this.POST(URI.create((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Request POST(URI uri) {
        void var1_1;
        return this.newRequest((URI)var1_1).method(HttpMethod.POST);
    }

    /*
     * WARNING - void declaration
     */
    public Request newRequest(String host, int port) {
        void var2_2;
        void var1_1;
        return this.newRequest(new Origin("http", (String)var1_1, (int)var2_2).asString());
    }

    /*
     * WARNING - void declaration
     */
    public Request newRequest(String uri) {
        void var1_1;
        return this.newRequest(URI.create((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public Request newRequest(URI uri) {
        void var1_1;
        HttpClient httpClient = this;
        return httpClient.newHttpRequest(httpClient.newConversation(), (URI)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Request copyRequest(HttpRequest oldRequest, URI newURI) {
        void var2_2;
        Iterator iterator;
        HttpRequest newRequest = this.newHttpRequest(oldRequest.getConversation(), newURI);
        newRequest.method(oldRequest.getMethod()).version(oldRequest.getVersion()).content(oldRequest.getContent()).idleTimeout(oldRequest.getIdleTimeout(), TimeUnit.MILLISECONDS).timeout(oldRequest.getTimeout(), TimeUnit.MILLISECONDS).followRedirects(oldRequest.isFollowRedirects());
        for (HttpField field : ((HttpRequest)((Object)iterator)).getHeaders()) {
            void var3_3;
            HttpHeader header = field.getHeader();
            if (HttpHeader.HOST == header || HttpHeader.EXPECT == header || HttpHeader.COOKIE == header || HttpHeader.AUTHORIZATION == header || HttpHeader.PROXY_AUTHORIZATION == header) continue;
            String name = field.getName();
            String value = field.getValue();
            if (newRequest.getHeaders().contains(name, value)) continue;
            newRequest.header(name, (String)var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpRequest newHttpRequest(HttpConversation conversation, URI uri) {
        void var2_2;
        void var1_1;
        return new HttpRequest(this, (HttpConversation)var1_1, this.checkHost((URI)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private URI checkHost(URI uri) {
        void var1_1;
        if (uri.getHost() == null) {
            throw new IllegalArgumentException(String.format("Invalid URI host: null (authority: %s)", uri.getRawAuthority()));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Destination getDestination(String scheme, String host, int port) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.destinationFor((String)var1_1, (String)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpDestination destinationFor(String scheme, String host, int port) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.resolveDestination((String)var1_1, (String)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpDestination resolveDestination(String scheme, String host, int port, Object tag) {
        void var1_1;
        void var3_3;
        void var2_2;
        Origin origin = this.createOrigin(scheme, (String)var2_2, (int)var3_3, tag);
        return this.resolveDestination((Origin)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Origin createOrigin(String scheme, String host, int port, Object tag) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!(HttpScheme.HTTP.is(scheme) || HttpScheme.HTTPS.is(scheme) || HttpScheme.WS.is(scheme) || HttpScheme.WSS.is(scheme))) {
            throw new IllegalArgumentException("Invalid protocol " + scheme);
        }
        scheme = scheme.toLowerCase(Locale.ENGLISH);
        host = host.toLowerCase(Locale.ENGLISH);
        port = HttpClient.normalizePort(scheme, port);
        return new Origin((String)var1_1, (String)var2_2, (int)var3_3, tag);
    }

    /*
     * WARNING - void declaration
     */
    public HttpDestination resolveDestination(Origin origin) {
        void var1_1;
        return this.destinations.compute((Origin)var1_1, (k, v) -> {
            void var2_2;
            if (v == null || v.stale()) {
                void var1_1;
                HttpDestination newDestination = this.getTransport().newHttpDestination((Origin)k);
                this.addManaged((LifeCycle)newDestination);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created {}; existing: '{}'", new Object[]{newDestination, v});
                }
                return var1_1;
            }
            return var2_2;
        });
    }

    /*
     * WARNING - void declaration
     */
    protected boolean removeDestination(HttpDestination destination) {
        void var2_2;
        boolean removed = this.destinations.remove(destination.getOrigin(), destination);
        this.removeBean(destination);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("Removed {}; result: {}", new Object[]{var1_1, removed});
        }
        return (boolean)var2_2;
    }

    public List<Destination> getDestinations() {
        return new ArrayList<Destination>(this.destinations.values());
    }

    /*
     * WARNING - void declaration
     */
    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        void var2_2;
        void var1_1;
        HttpDestination httpDestination = this.resolveDestination(request.getScheme(), request.getHost(), request.getPort(), request.getTag());
        httpDestination.send((HttpRequest)var1_1, (List<Response.ResponseListener>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void newConnection(HttpDestination destination, Promise<Connection> promise) {
        void var2_2;
        void var1_1;
        void var3_3;
        Origin.Address address = destination.getConnectAddress();
        this.resolver.resolve(address.getHost(), var3_3.getPort(), (Promise)new Promise<List<InetSocketAddress>>(this, (HttpDestination)var1_1, (Promise)var2_2){
            final /* synthetic */ HttpDestination val$destination;
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ HttpClient this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$destination = httpDestination;
                this.val$promise = promise;
            }

            /*
             * WARNING - void declaration
             */
            public void succeeded(List<InetSocketAddress> socketAddresses) {
                void var2_2;
                void var1_1;
                ConcurrentHashMap<String, ContainerLifeCycle> context = new ConcurrentHashMap<String, ContainerLifeCycle>();
                context.put("client.connector", this.this$0);
                context.put("http.destination", this.val$destination);
                this.connect((List<InetSocketAddress>)var1_1, 0, (Map<String, Object>)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public void failed(Throwable x) {
                void var1_1;
                this.val$promise.failed((Throwable)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            private void connect(List<InetSocketAddress> socketAddresses, int index, Map<String, Object> context) {
                void var3_3;
                void var2_2;
                void var1_1;
                1 v0 = this;
                context.put("http.connection.promise", new Promise.Wrapper<Connection>(v0, v0.val$promise, index, socketAddresses, context){
                    final /* synthetic */ int val$index;
                    final /* synthetic */ List val$socketAddresses;
                    final /* synthetic */ Map val$context;
                    final /* synthetic */ 1 this$1;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$1 = var1_1;
                        this.val$index = n;
                        this.val$socketAddresses = list;
                        this.val$context = map;
                        super((Promise)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void failed(Throwable x) {
                        void var2_2;
                        int nextIndex = this.val$index + 1;
                        if (nextIndex == this.val$socketAddresses.size()) {
                            void var1_1;
                            super.failed((Throwable)var1_1);
                            return;
                        }
                        1.access$100(this.this$1, this.val$socketAddresses, (int)var2_2, this.val$context);
                    }
                });
                this.this$0.transport.connect((InetSocketAddress)var1_1.get((int)var2_2), (Map<String, Object>)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ void access$100(1 x0, List x1, int x2, Map x3) {
                void var3_3;
                void var2_2;
                void var1_1;
                x0.connect((List<InetSocketAddress>)var1_1, (int)var2_2, (Map<String, Object>)var3_3);
            }
        });
    }

    private HttpConversation newConversation() {
        return new HttpConversation();
    }

    public ProtocolHandlers getProtocolHandlers() {
        return this.handlers;
    }

    /*
     * WARNING - void declaration
     */
    protected ProtocolHandler findProtocolHandler(Request request, Response response) {
        void var2_2;
        void var1_1;
        return this.handlers.find((Request)var1_1, (Response)var2_2);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    /*
     * WARNING - void declaration
     */
    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        void var1_1;
        if (this.isStarted()) {
            LOG.warn("Calling setByteBufferPool() while started is deprecated", new Object[0]);
        }
        HttpClient httpClient = this;
        httpClient.updateBean(httpClient.byteBufferPool, byteBufferPool);
        this.byteBufferPool = var1_1;
    }

    @ManagedAttribute(value="The name of this HttpClient")
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    @ManagedAttribute(value="The timeout, in milliseconds, for connect() operations")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectTimeout(long connectTimeout) {
        void var1_1;
        this.connectTimeout = var1_1;
    }

    public long getAddressResolutionTimeout() {
        return this.addressResolutionTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setAddressResolutionTimeout(long addressResolutionTimeout) {
        void var1_1;
        this.addressResolutionTimeout = var1_1;
    }

    @ManagedAttribute(value="The timeout, in milliseconds, to close idle connections")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(long idleTimeout) {
        void var1_1;
        this.idleTimeout = var1_1;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    /*
     * WARNING - void declaration
     */
    public void setBindAddress(SocketAddress bindAddress) {
        void var1_1;
        this.bindAddress = var1_1;
    }

    public HttpField getUserAgentField() {
        return this.agentField;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserAgentField(HttpField agent) {
        void var1_1;
        if (agent != null && agent.getHeader() != HttpHeader.USER_AGENT) {
            throw new IllegalArgumentException();
        }
        this.agentField = var1_1;
    }

    @ManagedAttribute(value="Whether HTTP redirects are followed")
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    /*
     * WARNING - void declaration
     */
    public void setFollowRedirects(boolean follow) {
        void var1_1;
        this.followRedirects = var1_1;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - void declaration
     */
    public void setExecutor(Executor executor) {
        void var1_1;
        if (this.isStarted()) {
            LOG.warn("Calling setExecutor() while started is deprecated", new Object[0]);
        }
        HttpClient httpClient = this;
        httpClient.updateBean(httpClient.executor, executor);
        this.executor = var1_1;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - void declaration
     */
    public void setScheduler(Scheduler scheduler) {
        void var1_1;
        if (this.isStarted()) {
            LOG.warn("Calling setScheduler() while started is deprecated", new Object[0]);
        }
        HttpClient httpClient = this;
        httpClient.updateBean(httpClient.scheduler, scheduler);
        this.scheduler = var1_1;
    }

    public SocketAddressResolver getSocketAddressResolver() {
        return this.resolver;
    }

    /*
     * WARNING - void declaration
     */
    public void setSocketAddressResolver(SocketAddressResolver resolver) {
        void var1_1;
        if (this.isStarted()) {
            LOG.warn("Calling setSocketAddressResolver() while started is deprecated", new Object[0]);
        }
        HttpClient httpClient = this;
        httpClient.updateBean(httpClient.resolver, resolver);
        this.resolver = var1_1;
    }

    @ManagedAttribute(value="The max number of connections per each destination")
    public int getMaxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxConnectionsPerDestination(int maxConnectionsPerDestination) {
        void var1_1;
        this.maxConnectionsPerDestination = var1_1;
    }

    @ManagedAttribute(value="The max number of requests queued per each destination")
    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        void var1_1;
        this.maxRequestsQueuedPerDestination = var1_1;
    }

    @ManagedAttribute(value="The request buffer size")
    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setRequestBufferSize(int requestBufferSize) {
        void var1_1;
        this.requestBufferSize = var1_1;
    }

    @ManagedAttribute(value="The response buffer size")
    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setResponseBufferSize(int responseBufferSize) {
        void var1_1;
        this.responseBufferSize = var1_1;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxRedirects(int maxRedirects) {
        void var1_1;
        this.maxRedirects = var1_1;
    }

    @ManagedAttribute(value="Whether the TCP_NODELAY option is enabled", name="tcpNoDelay")
    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    /*
     * WARNING - void declaration
     */
    public void setTCPNoDelay(boolean tcpNoDelay) {
        void var1_1;
        this.tcpNoDelay = var1_1;
    }

    @Deprecated
    public boolean isDispatchIO() {
        return false;
    }

    @Deprecated
    public void setDispatchIO(boolean dispatchIO) {
    }

    public HttpCompliance getHttpCompliance() {
        return this.httpCompliance;
    }

    /*
     * WARNING - void declaration
     */
    public void setHttpCompliance(HttpCompliance httpCompliance) {
        void var1_1;
        this.httpCompliance = var1_1;
    }

    @ManagedAttribute(value="Whether request/response events must be strictly ordered")
    public boolean isStrictEventOrdering() {
        return this.strictEventOrdering;
    }

    /*
     * WARNING - void declaration
     */
    public void setStrictEventOrdering(boolean strictEventOrdering) {
        void var1_1;
        this.strictEventOrdering = var1_1;
    }

    @ManagedAttribute(value="The time in ms after which idle destinations are removed, disabled when zero or negative")
    public long getDestinationIdleTimeout() {
        return this.destinationIdleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setDestinationIdleTimeout(long destinationIdleTimeout) {
        void var1_1;
        if (this.isStarted()) {
            LOG.warn("Calling setDestinationIdleTimeout() while started has no effect", new Object[0]);
        }
        this.destinationIdleTimeout = var1_1;
    }

    @Deprecated
    @ManagedAttribute(value="Whether idle destinations are removed")
    public boolean isRemoveIdleDestinations() {
        return this.destinationIdleTimeout > 0L;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setRemoveIdleDestinations(boolean removeIdleDestinations) {
        void var1_1;
        this.setDestinationIdleTimeout(var1_1 != false ? 10000L : 0L);
    }

    @ManagedAttribute(value="Whether the connect() operation is blocking")
    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectBlocking(boolean connectBlocking) {
        void var1_1;
        this.connectBlocking = var1_1;
    }

    @ManagedAttribute(value="The default content type for request content")
    public String getDefaultRequestContentType() {
        return this.defaultRequestContentType;
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultRequestContentType(String contentType) {
        void var1_1;
        this.defaultRequestContentType = var1_1;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfig;
    }

    protected HttpField getAcceptEncodingField() {
        return this.encodingField;
    }

    @Deprecated
    protected String normalizeHost(String host) {
        return host;
    }

    /*
     * WARNING - void declaration
     */
    public static int normalizePort(String scheme, int port) {
        String string;
        if (port > 0) {
            void var1_1;
            return (int)var1_1;
        }
        if (HttpClient.isSchemeSecure(string)) {
            return 443;
        }
        return 80;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDefaultPort(String scheme, int port) {
        void var2_2;
        if (HttpClient.isSchemeSecure(scheme)) {
            return port == 443;
        }
        return var2_2 == 80;
    }

    static boolean isSchemeSecure(String scheme) {
        String string;
        return HttpScheme.HTTPS.is(scheme) || HttpScheme.WSS.is(string);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        void var1_1;
        return new SslClientConnectionFactory(this.getSslContextFactory(), this.getByteBufferPool(), this.getExecutor(), (ClientConnectionFactory)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory connectionFactory) {
        void var2_2;
        void var1_1;
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(connectionFactory);
        }
        return new SslClientConnectionFactory((SslContextFactory)var1_1, this.getByteBufferPool(), this.getExecutor(), (ClientConnectionFactory)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ HttpField access$402(HttpClient x0, HttpField x1) {
        void var1_1;
        x0.encodingField = var1_1;
        return x0.encodingField;
    }

    private class ContentDecoderFactorySet
    implements Set<ContentDecoder.Factory> {
        private final Set<ContentDecoder.Factory> set = new HashSet<ContentDecoder.Factory>();

        private ContentDecoderFactorySet() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean add(ContentDecoder.Factory e) {
            void var1_2;
            boolean result = this.set.add(e);
            this.invalidate();
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(Collection<? extends ContentDecoder.Factory> c) {
            void var1_2;
            boolean result = this.set.addAll(c);
            this.invalidate();
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            void var1_2;
            boolean result = this.set.remove(o);
            this.invalidate();
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            void var1_2;
            boolean result = this.set.removeAll(c);
            this.invalidate();
            return (boolean)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            void var1_2;
            boolean result = this.set.retainAll(c);
            this.invalidate();
            return (boolean)var1_2;
        }

        @Override
        public void clear() {
            this.set.clear();
            this.invalidate();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.set.contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsAll(Collection<?> c) {
            void var1_1;
            return this.set.containsAll((Collection<?>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Iterator<ContentDecoder.Factory> iterator() {
            void var1_1;
            Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
            return new Iterator<ContentDecoder.Factory>(this, (Iterator)var1_1){
                final /* synthetic */ Iterator val$iterator;
                final /* synthetic */ ContentDecoderFactorySet this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.val$iterator = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$iterator.hasNext();
                }

                @Override
                public ContentDecoder.Factory next() {
                    return (ContentDecoder.Factory)this.val$iterator.next();
                }

                @Override
                public void remove() {
                    this.val$iterator.remove();
                    this.this$1.invalidate();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a) {
            void var1_1;
            return this.set.toArray((T[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void invalidate() {
            void var1_1;
            if (this.set.isEmpty()) {
                HttpClient.access$402(HttpClient.this, null);
                return;
            }
            StringBuilder value = new StringBuilder();
            Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                ContentDecoder.Factory decoderFactory = iterator.next();
                value.append(var3_3.getEncoding());
                if (!iterator.hasNext()) continue;
                value.append(",");
            }
            HttpClient.access$402(HttpClient.this, new HttpField(HttpHeader.ACCEPT_ENCODING, var1_1.toString()));
        }
    }
}

