/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpChannel
implements CyclicTimeouts.Expirable {
    protected static final Logger LOG = Log.getLogger(HttpChannel.class);
    private final HttpDestination _destination;
    private HttpExchange _exchange;

    /*
     * WARNING - void declaration
     */
    protected HttpChannel(HttpDestination destination) {
        void var1_1;
        this._destination = var1_1;
    }

    public void destroy() {
    }

    public HttpDestination getHttpDestination() {
        return this._destination;
    }

    /*
     * WARNING - void declaration
     */
    public boolean associate(HttpExchange exchange) {
        void var2_3;
        void var3_4;
        boolean result = false;
        boolean abort = true;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            if (this._exchange == null) {
                abort = false;
                result = exchange.associate(this);
                if (result) {
                    this._exchange = exchange;
                }
            }
        }
        if (var3_4 != false) {
            exchange.getRequest().abort(new UnsupportedOperationException("Pipelined requests not supported"));
        } else if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("{} associated {} to {}", new Object[]{var1_1, result, this});
        }
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public boolean disassociate(HttpExchange exchange) {
        void var2_3;
        boolean result = false;
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            HttpExchange existing = this._exchange;
            this._exchange = null;
            if (existing == exchange) {
                existing.disassociate(this);
                result = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("{} disassociated {} from {}", new Object[]{var1_1, result, this});
        }
        return (boolean)var2_3;
    }

    public HttpExchange getHttpExchange() {
        HttpChannel httpChannel = this;
        synchronized (httpChannel) {
            return this._exchange;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getExpireNanoTime() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            void var1_1;
            return var1_1.getExpireNanoTime();
        }
        return Long.MAX_VALUE;
    }

    protected abstract HttpSender getHttpSender();

    protected abstract HttpReceiver getHttpReceiver();

    /*
     * WARNING - void declaration
     */
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            void var1_1;
            this.send((HttpExchange)var1_1);
        }
    }

    public abstract void send(HttpExchange var1);

    public abstract void release();

    /*
     * WARNING - void declaration
     */
    public void proceed(HttpExchange exchange, Throwable failure) {
        void var2_2;
        void var1_1;
        this.getHttpSender().proceed((HttpExchange)var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean abort(HttpExchange exchange, Throwable requestFailure, Throwable responseFailure) {
        void var2_3;
        boolean requestAborted = false;
        if (requestFailure != null) {
            requestAborted = this.getHttpSender().abort(exchange, requestFailure);
        }
        boolean responseAborted = false;
        if (responseFailure != null) {
            void var3_4;
            void var1_1;
            responseAborted = this.abortResponse((HttpExchange)var1_1, (Throwable)var3_4);
        }
        return requestAborted || var2_3 != false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean abortResponse(HttpExchange exchange, Throwable failure) {
        void var2_2;
        void var1_1;
        return this.getHttpReceiver().abort((HttpExchange)var1_1, (Throwable)var2_2);
    }

    public Result exchangeTerminating(HttpExchange exchange, Result result) {
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void exchangeTerminated(HttpExchange exchange, Result result) {
        void var1_1;
        this.disassociate((HttpExchange)var1_1);
    }

    public String toString() {
        return String.format("%s@%x(exchange=%s)", this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange());
    }
}

