/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.util.AbstractAuthentication;

public class HttpAuthenticationStore
implements AuthenticationStore {
    private final List<Authentication> authentications = new CopyOnWriteArrayList<Authentication>();
    private final Map<URI, Authentication.Result> results = new ConcurrentHashMap<URI, Authentication.Result>();

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAuthentication(Authentication authentication) {
        void var1_1;
        this.authentications.add((Authentication)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAuthentication(Authentication authentication) {
        void var1_1;
        this.authentications.remove(var1_1);
    }

    @Override
    public void clearAuthentications() {
        this.authentications.clear();
    }

    @Override
    public Authentication findAuthentication(String type, URI uri, String realm) {
        for (Authentication authentication : this.authentications) {
            if (!authentication.matches(type, uri, realm)) continue;
            return authentication;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAuthenticationResult(Authentication.Result result) {
        URI uri = result.getURI();
        if (uri != null) {
            void var1_1;
            void var2_2;
            this.results.put((URI)var2_2, (Authentication.Result)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAuthenticationResult(Authentication.Result result) {
        void var1_1;
        this.results.remove(var1_1.getURI());
    }

    @Override
    public void clearAuthenticationResults() {
        this.results.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication.Result findAuthenticationResult(URI uri) {
        for (Map.Entry<URI, Authentication.Result> entry : this.results.entrySet()) {
            void var3_3;
            if (!AbstractAuthentication.matchesURI(entry.getKey(), uri)) continue;
            return (Authentication.Result)var3_3.getValue();
        }
        return null;
    }

    @Override
    public boolean hasAuthenticationResults() {
        return !this.results.isEmpty();
    }
}

