/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;

public class ContinueProtocolHandler
implements ProtocolHandler {
    public static final String NAME = "continue";
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";
    private final ResponseNotifier notifier = new ResponseNotifier();

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean accept(Request request, Response response) {
        void var1_2;
        void var3_5;
        void var2_4;
        boolean is100 = response.getStatus() == 100;
        boolean expect100 = request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        boolean handled100 = request.getAttributes().containsKey(ATTRIBUTE);
        return (var2_4 != false || var3_5 != false) && var1_2 == false;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener(this);
    }

    protected void onContinue(Request request) {
    }

    protected class ContinueListener
    extends BufferingResponseListener {
        final /* synthetic */ ContinueProtocolHandler this$0;

        /*
         * WARNING - void declaration
         */
        protected ContinueListener(ContinueProtocolHandler this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onSuccess(Response response) {
            void var2_2;
            void var3_3;
            void var1_1;
            Request request = response.getRequest();
            HttpConversation conversation = ((HttpRequest)request).getConversation();
            request.attribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            if (response.getStatus() == 100) {
                exchange.resetResponse();
                exchange.proceed(null);
                this.this$0.onContinue(request);
                return;
            }
            List<Response.ResponseListener> listeners = exchange.getResponseListeners();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            this.this$0.notifier.forwardSuccess(listeners, (Response)var1_1);
            var3_3.proceed(new HttpRequestException("Expectation failed", (Request)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onFailure(Response response, Throwable failure) {
            void var2_2;
            void var1_1;
            void var3_3;
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            List<Response.ResponseListener> listeners = exchange.getResponseListeners();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            this.this$0.notifier.forwardFailureComplete(listeners, exchange.getRequest(), var3_3.getRequestFailure(), (Response)var1_1, (Throwable)var2_2);
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

