/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AuthenticationProtocolHandler
implements ProtocolHandler {
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 16384;
    public static final Logger LOG = Log.getLogger(AuthenticationProtocolHandler.class);
    private final HttpClient client;
    private final int maxContentLength;
    private final ResponseNotifier notifier;
    private static final Pattern CHALLENGE_PATTERN = Pattern.compile("(?<schemeOnly>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)|(?:(?<scheme>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)\\s+)?(?:(?<token68>[a-zA-Z0-9\\-._~+/]+=*)|(?<paramName>[!#$%&'*+\\-.^_`|~0-9A-Za-z]+)\\s*=\\s*(?:(?<paramValue>.*)))");

    /*
     * WARNING - void declaration
     */
    protected AuthenticationProtocolHandler(HttpClient client, int maxContentLength) {
        void var2_2;
        void var1_1;
        this.client = var1_1;
        this.maxContentLength = var2_2;
        this.notifier = new ResponseNotifier();
    }

    protected HttpClient getHttpClient() {
        return this.client;
    }

    protected abstract HttpHeader getAuthenticateHeader();

    protected abstract HttpHeader getAuthorizationHeader();

    protected abstract URI getAuthenticationURI(Request var1);

    protected abstract String getAuthenticationAttribute();

    @Override
    public Response.Listener getResponseListener() {
        return new AuthenticationListener();
    }

    /*
     * WARNING - void declaration
     */
    protected List<Authentication.HeaderInfo> getHeaderInfo(String header) throws IllegalArgumentException {
        void var2_2;
        ArrayList<Authentication.HeaderInfo> headerInfos = new ArrayList<Authentication.HeaderInfo>();
        for (String value : new QuotedCSV(true, new String[]{header})) {
            void var1_1;
            Matcher m = CHALLENGE_PATTERN.matcher(value);
            if (!m.matches()) continue;
            if (m.group("schemeOnly") != null) {
                headerInfos.add(new Authentication.HeaderInfo(this.getAuthorizationHeader(), m.group(1), new HashMap<String, String>()));
                continue;
            }
            if (m.group("scheme") != null) {
                headerInfos.add(new Authentication.HeaderInfo(this.getAuthorizationHeader(), m.group("scheme"), new HashMap<String, String>()));
            }
            if (headerInfos.isEmpty()) {
                throw new IllegalArgumentException("Parameters without auth-scheme");
            }
            ArrayList<Authentication.HeaderInfo> arrayList = headerInfos;
            Map<String, String> authParams = ((Authentication.HeaderInfo)arrayList.get(arrayList.size() - 1)).getParameters();
            if (m.group("paramName") != null) {
                String paramVal = QuotedCSV.unquote((String)m.group("paramValue"));
                authParams.put(m.group("paramName"), paramVal);
                continue;
            }
            if (m.group("token68") == null) continue;
            if (!authParams.isEmpty()) {
                throw new IllegalArgumentException("token68 after auth-params");
            }
            authParams.put("base64", var1_1.group("token68"));
        }
        return var2_2;
    }

    private class AfterAuthenticationListener
    extends Response.Listener.Adapter {
        private final Authentication.Result authenticationResult;

        /*
         * WARNING - void declaration
         */
        private AfterAuthenticationListener(Authentication.Result authenticationResult) {
            void var2_2;
            this.authenticationResult = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onSuccess(Response response) {
            void var1_2;
            int status = response.getStatus();
            if (HttpStatus.isSuccess((int)status) || HttpStatus.isRedirection((int)var1_2)) {
                AuthenticationProtocolHandler.this.client.getAuthenticationStore().addAuthenticationResult(this.authenticationResult);
            }
        }
    }

    private class AuthenticationListener
    extends BufferingResponseListener {
        private AuthenticationListener() {
            super(AuthenticationProtocolHandler.this.maxContentLength);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onComplete(Result result) {
            HttpRequest request = (HttpRequest)result.getRequest();
            HttpContentResponse response = new HttpContentResponse(result.getResponse(), this.getContent(), this.getMediaType(), this.getEncoding());
            if (result.getResponseFailure() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge failed {}", result.getFailure());
                }
                this.forwardFailureComplete(request, result.getRequestFailure(), response, result.getResponseFailure());
                return;
            }
            String authenticationAttribute = AuthenticationProtocolHandler.this.getAuthenticationAttribute();
            HttpConversation conversation = request.getConversation();
            if (conversation.getAttribute(authenticationAttribute) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bad credentials for {}", new Object[]{request});
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            HttpHeader header = AuthenticationProtocolHandler.this.getAuthenticateHeader();
            List<Authentication.HeaderInfo> headerInfos = this.parseAuthenticateHeader(response, header);
            if (headerInfos.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication challenge without {} header", new Object[]{header});
                }
                this.forwardFailureComplete(request, result.getRequestFailure(), response, new HttpResponseException("HTTP protocol violation: Authentication challenge without " + header + " header", response));
                return;
            }
            Authentication authentication = null;
            Authentication.HeaderInfo headerInfo = null;
            URI authURI = this.resolveURI(request, AuthenticationProtocolHandler.this.getAuthenticationURI(request));
            if (authURI != null) {
                for (Authentication.HeaderInfo element : headerInfos) {
                    authentication = AuthenticationProtocolHandler.this.client.getAuthenticationStore().findAuthentication(element.getType(), authURI, element.getRealm());
                    if (authentication == null) continue;
                    headerInfo = element;
                    break;
                }
            }
            if (authentication == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No authentication available for {}", new Object[]{request});
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            ContentProvider requestContent = request.getContent();
            if (requestContent != null && !requestContent.isReproducible()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request content not reproducible for {}", new Object[]{request});
                }
                this.forwardSuccessComplete(request, response);
                return;
            }
            try {
                void var1_1;
                Authentication.Result authnResult = authentication.authenticate(request, response, headerInfo, (Attributes)conversation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication result {}", new Object[]{authnResult});
                }
                if (authnResult == null) {
                    this.forwardSuccessComplete(request, response);
                    return;
                }
                conversation.setAttribute(authenticationAttribute, Boolean.TRUE);
                URI requestURI = request.getURI();
                String path = null;
                if (requestURI == null) {
                    requestURI = this.resolveURI(request, null);
                    path = request.getPath();
                }
                Request newRequest = AuthenticationProtocolHandler.this.client.copyRequest(request, requestURI);
                long timeoutAt = request.getTimeoutAt();
                if (timeoutAt < Long.MAX_VALUE) {
                    long newTimeout = timeoutAt - System.nanoTime();
                    if (newTimeout > 0L) {
                        newRequest.timeout(newTimeout, TimeUnit.NANOSECONDS);
                    } else {
                        TimeoutException failure = new TimeoutException("Total timeout " + request.getConversation().getTimeout() + " ms elapsed");
                        this.forwardFailureComplete(request, failure, response, (Throwable)var1_1);
                        return;
                    }
                }
                if (path != null) {
                    var1_1.path(path);
                }
                authnResult.apply((Request)var1_1);
                this.copyIfAbsent(request, (Request)var1_1, HttpHeader.AUTHORIZATION);
                this.copyIfAbsent(request, (Request)var1_1, HttpHeader.PROXY_AUTHORIZATION);
                AfterAuthenticationListener listener = new AfterAuthenticationListener(authnResult);
                Connection connection = (Connection)request.getAttributes().get(Connection.class.getName());
                if (connection == null) {
                    var1_1.send(listener);
                    return;
                }
                connection.send((Request)var1_1, listener);
            }
            catch (Throwable x) {
                void var3_3;
                void var2_2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Authentication failed", x);
                }
                this.forwardFailureComplete((HttpRequest)var2_2, null, (Response)var3_3, x);
            }
        }

        /*
         * WARNING - void declaration
         */
        private URI resolveURI(HttpRequest request, URI uri) {
            void var2_3;
            if (uri != null) {
                return uri;
            }
            String target = request.getScheme() + "://" + request.getHost();
            int port = request.getPort();
            if (port > 0) {
                void var1_2;
                target = target + ":" + (int)var1_2;
            }
            return URI.create((String)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        private void copyIfAbsent(HttpRequest oldRequest, Request newRequest, HttpHeader header) {
            void var3_3;
            HttpField field = oldRequest.getHeaders().getField(header);
            if (field != null && !newRequest.getHeaders().contains((HttpHeader)var3_3)) {
                void var1_1;
                void var2_2;
                var2_2.getHeaders().put((HttpField)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void forwardSuccessComplete(HttpRequest request, Response response) {
            void var2_2;
            void var1_1;
            void var3_3;
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            AuthenticationProtocolHandler.this.notifier.forwardSuccessComplete(var3_3.getResponseListeners(), (Request)var1_1, (Response)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void forwardFailureComplete(HttpRequest request, Throwable requestFailure, Response response, Throwable responseFailure) {
            void var3_3;
            void var2_2;
            void var1_1;
            HttpConversation conversation = request.getConversation();
            conversation.updateResponseListeners(null);
            List<Response.ResponseListener> responseListeners = conversation.getResponseListeners();
            if (responseFailure == null) {
                AuthenticationProtocolHandler.this.notifier.forwardSuccess(responseListeners, response);
            } else {
                AuthenticationProtocolHandler.this.notifier.forwardFailure(responseListeners, response, responseFailure);
            }
            AuthenticationProtocolHandler.this.notifier.notifyComplete(responseListeners, new Result((Request)var1_1, (Throwable)var2_2, (Response)var3_3, responseFailure));
        }

        /*
         * WARNING - void declaration
         */
        private List<Authentication.HeaderInfo> parseAuthenticateHeader(Response response, HttpHeader header) {
            void var3_4;
            Object object;
            ArrayList<Authentication.HeaderInfo> result = new ArrayList<Authentication.HeaderInfo>();
            object = object.getHeaders().getValuesList(header);
            object = object.iterator();
            while (object.hasNext()) {
                String value = (String)object.next();
                try {
                    result.addAll(AuthenticationProtocolHandler.this.getHeaderInfo(value));
                }
                catch (IllegalArgumentException e) {
                    void var2_3;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Failed to parse authentication header", (Throwable)var2_3);
                }
            }
            return var3_4;
        }
    }
}

