/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public abstract class AbstractConnectorHttpClientTransport
extends AbstractHttpClientTransport {
    private final int selectors;
    private SelectorManager selectorManager;

    /*
     * WARNING - void declaration
     */
    protected AbstractConnectorHttpClientTransport(int selectors) {
        void var1_1;
        this.selectors = var1_1;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.selectors;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        void var1_1;
        HttpClient httpClient = this.getHttpClient();
        this.selectorManager = this.newSelectorManager(httpClient);
        this.selectorManager.setConnectTimeout(var1_1.getConnectTimeout());
        AbstractConnectorHttpClientTransport abstractConnectorHttpClientTransport = this;
        abstractConnectorHttpClientTransport.addBean(abstractConnectorHttpClientTransport.selectorManager);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        AbstractConnectorHttpClientTransport abstractConnectorHttpClientTransport = this;
        abstractConnectorHttpClientTransport.removeBean(abstractConnectorHttpClientTransport.selectorManager);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connect(InetSocketAddress address, Map<String, Object> context) {
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            HttpDestination httpDestination = (HttpDestination)context.get("http.destination");
            HttpClient client = httpDestination.getHttpClient();
            SocketAddress bindAddress = client.getBindAddress();
            if (bindAddress != null) {
                channel.bind(bindAddress);
            }
            this.configure(client, channel);
            context.put("ssl.peer.host", address.getHostString());
            context.put("ssl.peer.port", address.getPort());
            boolean connected = true;
            if (client.isConnectBlocking()) {
                channel.socket().connect(address, (int)client.getConnectTimeout());
                channel.configureBlocking(false);
            } else {
                channel.configureBlocking(false);
                connected = channel.connect(address);
            }
            if (!connected) {
                this.selectorManager.connect((SelectableChannel)channel, context);
                return;
            }
            this.selectorManager.accept((SelectableChannel)channel, context);
        }
        catch (Throwable throwable) {
            Throwable x = throwable;
            if (throwable.getClass() == SocketException.class) {
                void var1_1;
                x = new SocketException("Could not connect to " + var1_1).initCause(x);
            }
            try {
                if (channel != null) {
                    void var3_4;
                    var3_4.close();
                }
                this.connectFailed(context, x);
                return;
            }
            catch (IOException ignored) {
                try {
                    LOG.ignore((Throwable)ignored);
                    this.connectFailed(context, x);
                    return;
                }
                catch (Throwable throwable2) {
                    void var2_3;
                    this.connectFailed((Map<String, Object>)var2_3, x);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void connectFailed(Map<String, Object> context, Throwable x) {
        void var2_2;
        Promise promise;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Could not connect to {}", new Object[]{context.get("http.destination")});
        }
        promise = (Promise)promise.get("http.connection.promise");
        promise.failed((Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void configure(HttpClient client, SocketChannel channel) throws IOException {
        void var1_1;
        channel.socket().setTcpNoDelay(var1_1.isTCPNoDelay());
    }

    /*
     * WARNING - void declaration
     */
    protected SelectorManager newSelectorManager(HttpClient client) {
        void var1_1;
        return new ClientSelectorManager(this, (HttpClient)var1_1, this.getSelectors());
    }

    protected SelectorManager getSelectorManager() {
        return this.selectorManager;
    }

    protected class ClientSelectorManager
    extends SelectorManager {
        private final HttpClient client;
        final /* synthetic */ AbstractConnectorHttpClientTransport this$0;

        /*
         * WARNING - void declaration
         */
        protected ClientSelectorManager(AbstractConnectorHttpClientTransport this$0, HttpClient client, int selectors) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            super(client.getExecutor(), client.getScheduler(), (int)var3_3);
            this.client = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) {
            void var1_1;
            void var3_3;
            void var2_2;
            SocketChannelEndPoint endp = new SocketChannelEndPoint(channel, (ManagedSelector)var2_2, (SelectionKey)var3_3, this.getScheduler());
            endp.setIdleTimeout(this.client.getIdleTimeout());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Connection newConnection(SelectableChannel channel, EndPoint endPoint, Object attachment) throws IOException {
            void var1_1;
            void var2_2;
            Map context = (Map)attachment;
            HttpDestination httpDestination = (HttpDestination)context.get("http.destination");
            return httpDestination.getClientConnectionFactory().newConnection((EndPoint)var2_2, (Map)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected void connectionFailed(SelectableChannel channel, Throwable x, Object attachment) {
            void var2_2;
            void var1_1;
            Map context = (Map)attachment;
            this.this$0.connectFailed((Map<String, Object>)var1_1, (Throwable)var2_2);
        }
    }
}

