/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Sweeper;

@ManagedObject
public abstract class AbstractConnectionPool
extends ContainerLifeCycle
implements ConnectionPool,
Dumpable,
Sweeper.Sweepable {
    private static final Logger LOG = Log.getLogger(AbstractConnectionPool.class);
    private final AtomicInteger pending = new AtomicInteger();
    private final HttpDestination destination;
    private final Callback requester;
    private final Pool<Connection> pool;
    private boolean maximizeConnections;
    private volatile long maxDurationNanos = 0L;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractConnectionPool(Destination destination, int maxConnections, Callback requester) {
        this((HttpDestination)var1_1, (int)var2_2, false, (Callback)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConnectionPool(HttpDestination destination, int maxConnections, boolean cache, Callback requester) {
        this((HttpDestination)var1_1, Pool.StrategyType.FIRST, (int)var2_2, (boolean)var3_3, requester);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConnectionPool(HttpDestination destination, Pool.StrategyType strategy, int maxConnections, boolean cache, Callback requester) {
        this((HttpDestination)var1_1, (Pool<Connection>)new Pool((Pool.StrategyType)var2_2, (int)var3_3, cache), requester);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractConnectionPool(HttpDestination destination, Pool<Connection> pool, Callback requester) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.destination = var1_1;
        this.requester = var3_3;
        this.pool = pool;
        pool.setMaxMultiplex(1);
        this.addBean(var2_2);
    }

    protected void doStop() throws Exception {
        this.pool.close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompletableFuture<Void> preCreateConnections(int connectionCount) {
        void var2_2;
        Pool.Entry entry;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Pre-creating connections {}/{}", new Object[]{connectionCount, this.getMaxConnectionCount()});
        }
        ArrayList<FutureConnection> futures = new ArrayList<FutureConnection>();
        for (int i = 0; i < connectionCount && (entry = this.pool.reserve()) != null; ++i) {
            this.pending.incrementAndGet();
            FutureConnection future = new FutureConnection(entry);
            futures.add(future);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Pre-creating connection {}/{} at {}", new Object[]{futures.size(), this.getMaxConnectionCount(), entry});
            }
            this.destination.newConnection((Promise<Connection>)future);
        }
        return CompletableFuture.allOf(var2_2.toArray(new CompletableFuture[0]));
    }

    @ManagedAttribute(value="The maximum duration in milliseconds a connection can be used for before it gets closed")
    public long getMaxDuration() {
        return TimeUnit.NANOSECONDS.toMillis(this.maxDurationNanos);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxDuration(long maxDurationInMs) {
        void var1_1;
        this.maxDurationNanos = TimeUnit.MILLISECONDS.toNanos((long)var1_1);
    }

    protected int getMaxMultiplex() {
        return this.pool.getMaxMultiplex();
    }

    /*
     * WARNING - void declaration
     */
    protected void setMaxMultiplex(int maxMultiplex) {
        void var1_1;
        this.pool.setMaxMultiplex((int)var1_1);
    }

    protected int getMaxUsageCount() {
        return this.pool.getMaxUsageCount();
    }

    /*
     * WARNING - void declaration
     */
    protected void setMaxUsageCount(int maxUsageCount) {
        void var1_1;
        this.pool.setMaxUsageCount((int)var1_1);
    }

    @ManagedAttribute(value="The number of active connections", readonly=true)
    public int getActiveConnectionCount() {
        return this.pool.getInUseCount();
    }

    @ManagedAttribute(value="The number of idle connections", readonly=true)
    public int getIdleConnectionCount() {
        return this.pool.getIdleCount();
    }

    @ManagedAttribute(value="The max number of connections", readonly=true)
    public int getMaxConnectionCount() {
        return this.pool.getMaxEntries();
    }

    @ManagedAttribute(value="The number of connections", readonly=true)
    public int getConnectionCount() {
        return this.pool.size();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    @Deprecated
    public int getPendingCount() {
        return this.getPendingConnectionCount();
    }

    @ManagedAttribute(value="The number of pending connections", readonly=true)
    public int getPendingConnectionCount() {
        return this.pending.get();
    }

    @Override
    public boolean isEmpty() {
        return this.pool.size() == 0;
    }

    @Override
    @ManagedAttribute(value="Whether this pool is closed")
    public boolean isClosed() {
        return this.pool.isClosed();
    }

    @ManagedAttribute(value="Whether the pool tries to maximize the number of connections used")
    public boolean isMaximizeConnections() {
        return this.maximizeConnections;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaximizeConnections(boolean maximizeConnections) {
        void var1_1;
        this.maximizeConnections = var1_1;
    }

    @Override
    public Connection acquire() {
        return this.acquire(true);
    }

    /*
     * WARNING - void declaration
     */
    protected Connection acquire(boolean create) {
        void var2_2;
        Connection connection;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Acquiring create={} on {}", new Object[]{create, this});
        }
        if ((connection = this.activate()) == null) {
            void var1_1;
            this.tryCreate((boolean)var1_1);
            connection = this.activate();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void tryCreate(boolean create) {
        int n;
        int connectionCount = this.getConnectionCount();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try creating connection {}/{} with {} pending", new Object[]{connectionCount, this.getMaxConnectionCount(), this.getPendingConnectionCount()});
        }
        int multiplexed = this.getMaxMultiplex();
        do {
            boolean tryCreate;
            int pending = this.pending.get();
            int supply = pending * multiplexed;
            int demand = this.destination.getQueuedRequestCount() + (create ? 1 : 0);
            boolean bl = tryCreate = this.isMaximizeConnections() || supply < demand;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try creating({}) connection, pending/demand/supply: {}/{}/{}, result={}", new Object[]{create, pending, demand, supply, tryCreate});
            }
            if (!tryCreate) {
                return;
            }
            n = pending;
        } while (!this.pending.compareAndSet(n, n + 1));
        Pool.Entry entry = this.pool.reserve();
        if (entry == null) {
            this.pending.decrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not creating connection as pool {} is full, pending: {}", new Object[]{this.pool, this.pending});
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            void var2_2;
            LOG.debug("Creating connection {}/{} at {}", new Object[]{(int)var2_2, this.getMaxConnectionCount(), entry});
        }
        FutureConnection future = new FutureConnection(entry);
        this.destination.newConnection((Promise<Connection>)future);
    }

    protected void proceed() {
        this.requester.succeeded();
    }

    /*
     * WARNING - void declaration
     */
    protected Connection activate() {
        Pool.Entry entry;
        while ((entry = this.pool.acquire()) != null) {
            void var2_2;
            EntryHolder entryHolder;
            Connection connection = (Connection)entry.getPooled();
            long maxDurationNanos = this.maxDurationNanos;
            if (maxDurationNanos > 0L && EntryHolder.access$000(entryHolder = (EntryHolder)((Attachable)connection).getAttachment(), maxDurationNanos)) {
                void var3_3;
                boolean canClose = this.remove(connection);
                if (canClose) {
                    IO.close((Closeable)connection);
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Connection removed{} due to expiration {} {}", new Object[]{var3_3 != false ? " and closed" : "", entry, this.pool});
                continue;
            }
            if (LOG.isDebugEnabled()) {
                void var1_1;
                LOG.debug("Activated {} {}", new Object[]{var1_1, this.pool});
            }
            this.acquired(connection);
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isActive(Connection connection) {
        void var1_1;
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        EntryHolder holder = (EntryHolder)(connection = (Attachable)connection).getAttachment();
        if (holder == null) {
            return false;
        }
        return !((EntryHolder)var1_1).entry.isIdle();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean release(Connection connection) {
        void var1_1;
        if (!this.deactivate(connection)) {
            return false;
        }
        this.released(connection);
        return this.idle((Connection)var1_1, this.isClosed());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean deactivate(Connection connection) {
        void var1_1;
        void var3_4;
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)connection;
        EntryHolder holder = (EntryHolder)attachable.getAttachment();
        if (holder == null) {
            return true;
        }
        long maxDurationNanos = this.maxDurationNanos;
        if (maxDurationNanos > 0L && EntryHolder.access$000(holder, maxDurationNanos)) {
            return !this.remove(connection);
        }
        boolean reusable = this.pool.release(holder.entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released ({}) {} {}", new Object[]{reusable, ((EntryHolder)attachable).entry, this.pool});
        }
        if (var3_4 != false) {
            return true;
        }
        return !this.remove((Connection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Connection connection) {
        if (!(connection instanceof Attachable)) {
            throw new IllegalArgumentException("Invalid connection object: " + connection);
        }
        Attachable attachable = (Attachable)connection;
        EntryHolder holder = (EntryHolder)attachable.getAttachment();
        if (holder == null) {
            return false;
        }
        boolean removed = this.pool.remove(holder.entry);
        if (removed) {
            void var2_2;
            var2_2.setAttachment(null);
        }
        if (LOG.isDebugEnabled()) {
            void var3_3;
            LOG.debug("Removed ({}) {} {}", new Object[]{removed, ((EntryHolder)var3_3).entry, this.pool});
        }
        if (removed) {
            void var1_1;
            this.released(connection);
            this.removed((Connection)var1_1);
        }
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected boolean remove(Connection connection, boolean force) {
        void var1_1;
        return this.remove((Connection)var1_1);
    }

    protected void onCreated(Connection connection) {
    }

    protected boolean idle(Connection connection, boolean close) {
        return !close;
    }

    protected void acquired(Connection connection) {
    }

    protected void released(Connection connection) {
    }

    protected void removed(Connection connection) {
    }

    @Deprecated
    public Queue<Connection> getIdleConnections() {
        return this.pool.values().stream().filter(Pool.Entry::isIdle).filter(entry -> !entry.isClosed()).map(Pool.Entry::getPooled).collect(Collectors.toCollection(ArrayDeque::new));
    }

    @Deprecated
    public Collection<Connection> getActiveConnections() {
        return this.pool.values().stream().filter(entry -> !entry.isIdle()).filter(entry -> !entry.isClosed()).map(Pool.Entry::getPooled).collect(Collectors.toList());
    }

    @Override
    public void close() {
        this.pool.close();
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        Dumpable.dumpObjects((Appendable)out, (String)var2_2, (Object)this, (Object[])new Object[0]);
    }

    public boolean sweep() {
        this.pool.values().stream().map(Pool.Entry::getPooled).filter(connection -> connection instanceof Sweeper.Sweepable).forEach(connection -> {
            if (((Sweeper.Sweepable)connection).sweep()) {
                void var2_2;
                void var1_1;
                boolean removed = this.remove((Connection)connection);
                LOG.warn("Connection swept: {}{}{} from active connections{}{}", new Object[]{var1_1, System.lineSeparator(), var2_2 != false ? "Removed" : "Not removed", System.lineSeparator(), this.dump()});
            }
        });
        return false;
    }

    public String toString() {
        return String.format("%s@%x[s=%s,c=%d/%d/%d,a=%d,i=%d,q=%d,p=%s]", this.getClass().getSimpleName(), this.hashCode(), this.getState(), this.getPendingConnectionCount(), this.getConnectionCount(), this.getMaxConnectionCount(), this.getActiveConnectionCount(), this.getIdleConnectionCount(), this.destination.getQueuedRequestCount(), this.pool);
    }

    private static class EntryHolder {
        private final Pool.Entry entry;
        private final long creationTimestamp = System.nanoTime();

        /*
         * WARNING - void declaration
         */
        private EntryHolder(Pool.Entry entry) {
            void var1_1;
            this.entry = (Pool.Entry)Objects.requireNonNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private boolean isExpired(long timeoutNanos) {
            void var1_1;
            return System.nanoTime() - this.creationTimestamp >= var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$000(EntryHolder x0, long x1) {
            void var1_1;
            return x0.isExpired((long)var1_1);
        }
    }

    private class FutureConnection
    extends Promise.Completable<Connection> {
        private final Pool.Entry reserved;

        /*
         * WARNING - void declaration
         */
        public FutureConnection(Pool.Entry reserved) {
            void var2_2;
            this.reserved = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void succeeded(Connection connection) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation succeeded {}: {}", new Object[]{this.reserved, connection});
            }
            if (connection instanceof Attachable) {
                ((Attachable)connection).setAttachment((Object)new EntryHolder(this.reserved));
                AbstractConnectionPool.this.onCreated(connection);
                AbstractConnectionPool.this.pending.decrementAndGet();
                this.reserved.enable((Object)connection, false);
                AbstractConnectionPool.this.idle(connection, false);
                this.complete(null);
                AbstractConnectionPool.this.proceed();
                return;
            }
            this.failed(new IllegalArgumentException("Invalid connection object: " + var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connection creation failed {}", new Object[]{this.reserved, x});
            }
            AbstractConnectionPool.this.pending.decrementAndGet();
            this.reserved.remove();
            this.completeExceptionally(x);
            AbstractConnectionPool.this.requester.failed((Throwable)var1_1);
        }
    }
}

