/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;

public final class MimeType
implements Externalizable {
    private String primaryType;
    private String subType;
    private MimeTypeParameterList parameters;

    public MimeType() {
        this.primaryType = "application";
        this.subType = "*";
        this.parameters = new MimeTypeParameterList();
    }

    /*
     * WARNING - void declaration
     */
    public MimeType(String rawdata) throws MimeTypeParseException {
        void var1_1;
        this.parse((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void parse(String rawdata) throws MimeTypeParseException {
        int slashIndex = rawdata.indexOf(47);
        int semIndex = rawdata.indexOf(59);
        if (slashIndex < 0 && semIndex < 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (slashIndex < 0 && semIndex >= 0) {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (slashIndex >= 0 && semIndex < 0) {
            this.primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase(Locale.ENGLISH);
            this.subType = rawdata.substring(slashIndex + 1).trim().toLowerCase(Locale.ENGLISH);
            this.parameters = new MimeTypeParameterList();
        } else if (slashIndex < semIndex) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase(Locale.ENGLISH);
            this.subType = rawdata.substring((int)(var2_2 + true), semIndex).trim().toLowerCase(Locale.ENGLISH);
            this.parameters = new MimeTypeParameterList(var1_1.substring((int)var3_3));
        } else {
            throw new MimeTypeParseException("Unable to find a sub type.");
        }
        if (!MimeType.isValidToken(this.primaryType)) {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
        if (!MimeType.isValidToken(this.subType)) {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
    }

    public final String toString() {
        return this.getBaseType() + this.parameters.toString();
    }

    public final String getBaseType() {
        return this.primaryType + "/" + this.subType;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean match(MimeType type) {
        block2: {
            block3: {
                void var1_1;
                MimeType mimeType = type;
                if (!this.primaryType.equals(mimeType.primaryType)) break block2;
                if (this.subType.equals("*")) break block3;
                mimeType = type;
                if (mimeType.subType.equals("*")) break block3;
                mimeType = var1_1;
                if (!this.subType.equals(mimeType.subType)) break block2;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeExternal(ObjectOutput out) throws IOException {
        void var1_1;
        out.writeUTF(this.toString());
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.parse(in.readUTF());
            return;
        }
        catch (MimeTypeParseException e) {
            void var1_2;
            throw new IOException(var1_2.toString());
        }
    }

    private static boolean isTokenChar(char c) {
        char c2;
        return c > ' ' && c < '\u007f' && "()<>@,;:/[]?=\\\"".indexOf(c2) < 0;
    }

    private static boolean isValidToken(String s) {
        int len = s.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (MimeType.isTokenChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

