/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.DataContentHandlerFactory;
import javax.activation.DataSource;
import javax.activation.DataSourceDataContentHandler;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.activation.ObjectDataContentHandler;

public final class DataHandler
implements Transferable {
    private DataSource dataSource = null;
    private DataSource objDataSource = null;
    private Object object = null;
    private String objectMimeType = null;
    private CommandMap currentCommandMap = null;
    private static final DataFlavor[] emptyFlavors = new DataFlavor[0];
    private DataFlavor[] transferFlavors = emptyFlavors;
    private DataContentHandler dataContentHandler = null;
    private DataContentHandler factoryDCH = null;
    private static DataContentHandlerFactory factory = null;
    private DataContentHandlerFactory oldFactory = null;
    private String shortType = null;

    /*
     * WARNING - void declaration
     */
    public DataHandler(DataSource ds) {
        void var1_1;
        this.dataSource = var1_1;
        this.oldFactory = null;
    }

    private synchronized CommandMap getCommandMap() {
        DataHandler dataHandler = this;
        return dataHandler.currentCommandMap.getDefaultCommandMap();
    }

    public final synchronized DataFlavor[] getTransferDataFlavors() {
        if (this.oldFactory != null) {
            this.transferFlavors = emptyFlavors;
        }
        if (this.transferFlavors == emptyFlavors) {
            this.transferFlavors = this.getDataContentHandler().getTransferDataFlavors();
        }
        if (this.transferFlavors == emptyFlavors) {
            return this.transferFlavors;
        }
        return (DataFlavor[])this.transferFlavors.clone();
    }

    public final boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] lFlavors = this.getTransferDataFlavors();
        for (int i = 0; i < lFlavors.length; ++i) {
            if (!lFlavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        void var1_1;
        return this.getDataContentHandler().getTransferData((DataFlavor)var1_1, this.dataSource);
    }

    /*
     * WARNING - void declaration
     */
    private synchronized DataContentHandler getDataContentHandler() {
        if (this.oldFactory != null) {
            this.oldFactory = null;
            this.factoryDCH = null;
            this.dataContentHandler = null;
            this.transferFlavors = emptyFlavors;
        }
        if (this.dataContentHandler != null) {
            return this.dataContentHandler;
        }
        Object simpleMT = this.getBaseType();
        if (this.factoryDCH != null) {
            this.dataContentHandler = this.factoryDCH;
        }
        if (this.dataContentHandler == null) {
            if (this.dataSource != null) {
                String string = simpleMT;
                simpleMT = this.getCommandMap();
                this.dataContentHandler = ((CommandMap)simpleMT).createDataContentHandler(string);
            } else {
                void var1_1;
                this.dataContentHandler = this.getCommandMap().createDataContentHandler((String)var1_1);
            }
        }
        this.dataContentHandler = this.dataSource != null ? new DataSourceDataContentHandler(this.dataContentHandler, this.dataSource) : new ObjectDataContentHandler(this.dataContentHandler, this.object, this.objectMimeType);
        return this.dataContentHandler;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized String getBaseType() {
        if (this.shortType == null) {
            DataHandler dataHandler = this;
            String ct = dataHandler.dataSource != null ? dataHandler.dataSource.getContentType() : dataHandler.objectMimeType;
            try {
                void var2_2;
                MimeType mt = new MimeType(ct);
                this.shortType = var2_2.getBaseType();
            }
            catch (MimeTypeParseException mimeTypeParseException) {
                this.shortType = dataHandler;
            }
        }
        return this.shortType;
    }
}

