/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.http.util.Args;

public class VersionInfo {
    public static final String UNAVAILABLE = "UNAVAILABLE";
    public static final String VERSION_PROPERTY_FILE = "version.properties";
    public static final String PROPERTY_MODULE = "info.module";
    public static final String PROPERTY_RELEASE = "info.release";
    public static final String PROPERTY_TIMESTAMP = "info.timestamp";
    private final String infoPackage;
    private final String infoModule;
    private final String infoRelease;
    private final String infoTimestamp;
    private final String infoClassloader;

    /*
     * WARNING - void declaration
     */
    protected VersionInfo(String pckg, String module, String release, String time, String clsldr) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull(pckg, "Package identifier");
        this.infoPackage = var1_1;
        this.infoModule = module != null ? var2_2 : UNAVAILABLE;
        this.infoRelease = release != null ? var3_3 : UNAVAILABLE;
        this.infoTimestamp = time != null ? time : UNAVAILABLE;
        this.infoClassloader = clsldr != null ? clsldr : UNAVAILABLE;
    }

    public final String getPackage() {
        return this.infoPackage;
    }

    public final String getModule() {
        return this.infoModule;
    }

    public final String getRelease() {
        return this.infoRelease;
    }

    public final String getTimestamp() {
        return this.infoTimestamp;
    }

    public final String getClassloader() {
        return this.infoClassloader;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder(20 + this.infoPackage.length() + this.infoModule.length() + this.infoRelease.length() + this.infoTimestamp.length() + this.infoClassloader.length());
        sb.append("VersionInfo(").append(this.infoPackage).append(':').append(this.infoModule);
        if (!UNAVAILABLE.equals(this.infoRelease)) {
            sb.append(':').append(this.infoRelease);
        }
        if (!UNAVAILABLE.equals(this.infoTimestamp)) {
            sb.append(':').append(this.infoTimestamp);
        }
        sb.append(')');
        if (!UNAVAILABLE.equals(this.infoClassloader)) {
            sb.append('@').append(this.infoClassloader);
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static VersionInfo[] loadVersionInfo(String[] pckgs, ClassLoader clsldr) {
        void var2_2;
        Args.notNull(pckgs, "Package identifier array");
        ArrayList<VersionInfo> vil = new ArrayList<VersionInfo>(pckgs.length);
        String[] arr$ = pckgs;
        int len$ = pckgs.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String string = arr$[i$];
            VersionInfo vi = VersionInfo.loadVersionInfo(string, clsldr);
            if (vi == null) continue;
            vil.add(vi);
        }
        void v0 = var2_2;
        return v0.toArray(new VersionInfo[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    public static VersionInfo loadVersionInfo(String pckg, ClassLoader clsldr) {
        void var3_3;
        Properties vip;
        block6: {
            Args.notNull(pckg, "Package identifier");
            ClassLoader cl = clsldr != null ? clsldr : Thread.currentThread().getContextClassLoader();
            vip = null;
            try {
                InputStream is = cl.getResourceAsStream(pckg.replace('.', '/') + "/version.properties");
                if (is == null) break block6;
                try {
                    Properties props = new Properties();
                    props.load(is);
                    vip = props;
                }
                finally {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        VersionInfo result = null;
        if (vip != null) {
            void var1_1;
            void var2_2;
            String string;
            result = VersionInfo.fromMap(string, var2_2, (ClassLoader)var1_1);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    protected static VersionInfo fromMap(String pckg, Map<?, ?> info, ClassLoader clsldr) {
        void var1_1;
        void var3_3;
        String string;
        Args.notNull(pckg, "Package identifier");
        String module = null;
        String release = null;
        String timestamp = null;
        if (info != null) {
            module = (String)info.get(PROPERTY_MODULE);
            if (module != null && module.length() <= 0) {
                module = null;
            }
            if ((release = (String)info.get(PROPERTY_RELEASE)) != null && (release.length() <= 0 || release.equals("${pom.version}"))) {
                release = null;
            }
            if ((timestamp = (String)info.get(PROPERTY_TIMESTAMP)) != null && (timestamp.length() <= 0 || timestamp.equals("${mvn.timestamp}"))) {
                timestamp = null;
            }
        }
        String clsldrstr = null;
        if (clsldr != null) {
            void var2_2;
            clsldrstr = var2_2.toString();
        }
        return new VersionInfo(string, (String)var3_3, release, timestamp, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String getUserAgent(String name, String pkg, Class<?> cls) {
        void var2_2;
        void var1_1;
        String string;
        VersionInfo vi = VersionInfo.loadVersionInfo(pkg, cls.getClassLoader());
        String release = vi != null ? vi.getRelease() : UNAVAILABLE;
        String javaVersion = System.getProperty("java.version");
        return String.format("%s/%s (Java/%s)", string, var1_1, var2_2);
    }
}

