/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

public final class EntityUtils {
    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity entity) {
        try {
            EntityUtils.consume(entity);
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void consume(HttpEntity entity) throws IOException {
        Object instream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (instream = entity.getContent()) != null) {
            Object object;
            ((InputStream)object).close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void updateEntity(HttpResponse response, HttpEntity entity) throws IOException {
        void var1_1;
        HttpResponse httpResponse;
        Args.notNull(response, "Response");
        EntityUtils.consume(response.getEntity());
        httpResponse.setEntity((HttpEntity)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static byte[] toByteArray(HttpEntity entity) throws IOException {
        byte[] byArray;
        Args.notNull(entity, "Entity");
        InputStream instream = entity.getContent();
        if (instream == null) {
            return null;
        }
        try {
            int l;
            Args.check(entity.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
            int i = (int)entity.getContentLength();
            if (i < 0) {
                i = 4096;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(i);
            byte[] tmp = new byte[4096];
            while ((l = instream.read(tmp)) != -1) {
                void var3_6;
                buffer.append(tmp, 0, (int)var3_6);
            }
            byArray = byArray.toByteArray();
        }
        catch (Throwable throwable) {
            void var1_4;
            var1_4.close();
            throw throwable;
        }
        instream.close();
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getContentCharSet(HttpEntity entity) throws ParseException {
        void var1_1;
        Object param;
        Object values;
        Args.notNull(entity, "Entity");
        String charset = null;
        if (entity.getContentType() != null && ((HeaderElement[])(values = entity.getContentType().getElements())).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            Object object;
            charset = object.getValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static String getContentMimeType(HttpEntity entity) throws ParseException {
        void var1_1;
        HeaderElement[] values;
        Args.notNull(entity, "Entity");
        String mimeType = null;
        if (entity.getContentType() != null && (values = entity.getContentType().getElements()).length > 0) {
            HeaderElement[] headerElementArray;
            mimeType = headerElementArray[0].getName();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(HttpEntity entity, Charset defaultCharset) throws IOException, ParseException {
        InputStreamReader inputStreamReader;
        Args.notNull(entity, "Entity");
        InputStream instream = entity.getContent();
        if (instream == null) {
            return null;
        }
        try {
            void var1_3;
            int l;
            Charset charset;
            int i;
            block10: {
                Args.check(entity.getContentLength() <= Integer.MAX_VALUE, "HTTP entity too large to be buffered in memory");
                i = (int)entity.getContentLength();
                if (i < 0) {
                    i = 4096;
                }
                charset = null;
                try {
                    InputStreamReader contentType = ContentType.get(entity);
                    if (contentType != null) {
                        charset = ((ContentType)((Object)contentType)).getCharset();
                    }
                }
                catch (UnsupportedCharsetException ex) {
                    if (defaultCharset != null) break block10;
                    throw new UnsupportedEncodingException(ex.getMessage());
                }
            }
            if (charset == null) {
                charset = defaultCharset;
            }
            if (charset == null) {
                charset = HTTP.DEF_CONTENT_CHARSET;
            }
            InputStreamReader reader = new InputStreamReader(instream, charset);
            CharArrayBuffer buffer = new CharArrayBuffer(i);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            inputStreamReader = var1_3.toString();
        }
        catch (Throwable throwable) {
            void var2_4;
            var2_4.close();
            throw throwable;
        }
        instream.close();
        return inputStreamReader;
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(HttpEntity entity, String defaultCharset) throws IOException, ParseException {
        void var1_1;
        return EntityUtils.toString(entity, defaultCharset != null ? Charset.forName((String)var1_1) : null);
    }

    public static String toString(HttpEntity entity) throws IOException, ParseException {
        return EntityUtils.toString(entity, null);
    }
}

