/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;

@NotThreadSafe
public final class CharArrayBuffer
implements Serializable,
CharSequence {
    private static final long serialVersionUID = -6208952725094867135L;
    private char[] buffer;
    private int len;

    /*
     * WARNING - void declaration
     */
    public CharArrayBuffer(int capacity) {
        void var1_1;
        Args.notNegative(capacity, "Buffer capacity");
        this.buffer = new char[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private void expand(int newlen) {
        void var1_2;
        char[] newbuffer = new char[Math.max(this.buffer.length << 1, newlen)];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.len);
        this.buffer = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(char[] b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        System.arraycopy(var1_1, (int)var2_2, this.buffer, this.len, (int)var3_3);
        this.len = newlen;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(String str) {
        void var3_3;
        void var2_2;
        void var1_1;
        String s = str != null ? str : "null";
        int strlen = s.length();
        int newlen = this.len + strlen;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        var1_1.getChars(0, (int)var2_2, this.buffer, this.len);
        this.len = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(CharArrayBuffer b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b == null) {
            return;
        }
        this.append(var1_1.buffer, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void append(CharArrayBuffer b) {
        void var1_1;
        if (b == null) {
            return;
        }
        this.append(b.buffer, 0, var1_1.len);
    }

    /*
     * WARNING - void declaration
     */
    public final void append(char ch) {
        void var2_2;
        void var1_1;
        int newlen = this.len + 1;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        this.buffer[this.len] = var1_1;
        this.len = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(byte[] b, int off, int len) {
        void var3_3;
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        if (len == 0) {
            return;
        }
        int oldlen = this.len;
        int newlen = oldlen + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        for (int i2 = oldlen; i2 < newlen; ++i2) {
            void i1;
            this.buffer[i2] = (char)(b[i1] & 0xFF);
            ++i1;
        }
        this.len = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(ByteArrayBuffer b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b == null) {
            return;
        }
        this.append(var1_1.buffer(), (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void append(Object obj) {
        void var1_1;
        this.append(String.valueOf(var1_1));
    }

    public final void clear() {
        this.len = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final char[] toCharArray() {
        void var1_1;
        char[] b = new char[this.len];
        if (this.len > 0) {
            System.arraycopy(this.buffer, 0, b, 0, this.len);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final char charAt(int i) {
        void var1_1;
        return this.buffer[var1_1];
    }

    public final char[] buffer() {
        return this.buffer;
    }

    public final int capacity() {
        return this.buffer.length;
    }

    @Override
    public final int length() {
        return this.len;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int required) {
        void var2_2;
        if (required <= 0) {
            return;
        }
        int available = this.buffer.length - this.len;
        if (required > var2_2) {
            void var1_1;
            CharArrayBuffer charArrayBuffer = this;
            charArrayBuffer.expand(charArrayBuffer.len + var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setLength(int len) {
        void var1_1;
        if (len < 0 || len > this.buffer.length) {
            throw new IndexOutOfBoundsException("len: " + len + " < 0 or > buffer len: " + this.buffer.length);
        }
        this.len = var1_1;
    }

    @Override
    public final boolean isEmpty() {
        return this.len == 0;
    }

    public final boolean isFull() {
        return this.len == this.buffer.length;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(int ch, int from, int to) {
        void i;
        int endIndex;
        int beginIndex = from;
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if ((endIndex = to) > this.len) {
            endIndex = this.len;
        }
        if (beginIndex > endIndex) {
            return -1;
        }
        while (i < endIndex) {
            if (this.buffer[i] == ch) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(int ch) {
        void var1_1;
        return this.indexOf((int)var1_1, 0, this.len);
    }

    /*
     * WARNING - void declaration
     */
    public final String substring(int beginIndex, int endIndex) {
        void var1_1;
        void var2_2;
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + beginIndex);
        }
        if (endIndex > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + endIndex + " > length: " + this.len);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex: " + beginIndex + " > endIndex: " + endIndex);
        }
        return new String(this.buffer, beginIndex, (int)(var2_2 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final String substringTrimmed(int beginIndex, int endIndex) {
        void var1_1;
        void var3_3;
        void beginIndex0;
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + beginIndex);
        }
        if (endIndex > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + endIndex + " > length: " + this.len);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex: " + beginIndex + " > endIndex: " + endIndex);
        }
        int endIndex0 = endIndex;
        while (beginIndex0 < endIndex && HTTP.isWhitespace(this.buffer[beginIndex0])) {
            ++beginIndex0;
        }
        while (endIndex0 > beginIndex0 && HTTP.isWhitespace(this.buffer[endIndex0 - 1])) {
            --endIndex0;
        }
        return new String(this.buffer, (int)beginIndex0, (int)(var3_3 - var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final CharSequence subSequence(int beginIndex, int endIndex) {
        void var2_2;
        void var1_1;
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + beginIndex);
        }
        if (endIndex > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + endIndex + " > length: " + this.len);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex: " + beginIndex + " > endIndex: " + endIndex);
        }
        return CharBuffer.wrap(this.buffer, (int)var1_1, (int)var2_2);
    }

    @Override
    public final String toString() {
        return new String(this.buffer, 0, this.len);
    }
}

