/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.Serializable;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public final class ByteArrayBuffer
implements Serializable {
    private static final long serialVersionUID = 4359112959524048036L;
    private byte[] buffer;
    private int len;

    /*
     * WARNING - void declaration
     */
    public ByteArrayBuffer(int capacity) {
        void var1_1;
        Args.notNegative(capacity, "Buffer capacity");
        this.buffer = new byte[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    private void expand(int newlen) {
        void var1_2;
        byte[] newbuffer = new byte[Math.max(this.buffer.length << 1, newlen)];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.len);
        this.buffer = var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(byte[] b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        System.arraycopy(var1_1, (int)var2_2, this.buffer, this.len, (int)var3_3);
        this.len = newlen;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(int b) {
        void var2_2;
        void var1_1;
        int newlen = this.len + 1;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        this.buffer[this.len] = (byte)var1_1;
        this.len = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(char[] b, int off, int len) {
        void var3_3;
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b.length);
        }
        if (len == 0) {
            return;
        }
        int oldlen = this.len;
        int newlen = oldlen + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        for (int i2 = oldlen; i2 < newlen; ++i2) {
            void i1;
            this.buffer[i2] = (byte)b[i1];
            ++i1;
        }
        this.len = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void append(CharArrayBuffer b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (b == null) {
            return;
        }
        this.append(var1_1.buffer(), (int)var2_2, (int)var3_3);
    }

    public final void clear() {
        this.len = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] toByteArray() {
        void var1_1;
        byte[] b = new byte[this.len];
        if (this.len > 0) {
            System.arraycopy(this.buffer, 0, b, 0, this.len);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final int byteAt(int i) {
        void var1_1;
        return this.buffer[var1_1];
    }

    public final int capacity() {
        return this.buffer.length;
    }

    public final int length() {
        return this.len;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureCapacity(int required) {
        void var2_2;
        if (required <= 0) {
            return;
        }
        int available = this.buffer.length - this.len;
        if (required > var2_2) {
            void var1_1;
            ByteArrayBuffer byteArrayBuffer = this;
            byteArrayBuffer.expand(byteArrayBuffer.len + var1_1);
        }
    }

    public final byte[] buffer() {
        return this.buffer;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLength(int len) {
        void var1_1;
        if (len < 0 || len > this.buffer.length) {
            throw new IndexOutOfBoundsException("len: " + len + " < 0 or > buffer len: " + this.buffer.length);
        }
        this.len = var1_1;
    }

    public final boolean isEmpty() {
        return this.len == 0;
    }

    public final boolean isFull() {
        return this.len == this.buffer.length;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(byte b, int from, int to) {
        void i;
        int endIndex;
        int beginIndex = from;
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if ((endIndex = to) > this.len) {
            endIndex = this.len;
        }
        if (beginIndex > endIndex) {
            return -1;
        }
        while (i < endIndex) {
            if (this.buffer[i] == b) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final int indexOf(byte b) {
        void var1_1;
        return this.indexOf((byte)var1_1, 0, this.len);
    }
}

